/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.recipes.builders;

import io.th0rgal.oraxen.recipes.builders.RecipeBuilder;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class CookingBuilder
extends RecipeBuilder {
    private int cookingTime;
    private int experience;

    public CookingBuilder(Player player, String builderName) {
        super(player, builderName);
    }

    @Override
    Inventory createInventory(Player player, String inventoryTitle) {
        return Bukkit.createInventory((InventoryHolder)player, (InventoryType)InventoryType.FURNACE, (String)inventoryTitle);
    }

    @Override
    public void saveRecipe(String name) {
        this.saveRecipe(name, null);
    }

    @Override
    public void saveRecipe(String name, String permission) {
        ItemStack[] content = this.getInventory().getContents();
        ConfigurationSection newCraftSection = this.getConfig().createSection(name);
        this.setSerializedItem(newCraftSection.createSection("result"), content[2]);
        this.setSerializedItem(newCraftSection.createSection("input"), content[0]);
        newCraftSection.set("cookingTime", (Object)this.cookingTime);
        newCraftSection.set("experience", (Object)this.experience);
        if (permission != null && !permission.isEmpty()) {
            newCraftSection.set("permission", (Object)permission);
        }
        this.saveConfig();
        this.close();
    }

    public void setCookingTime(int cookingTime) {
        this.cookingTime = cookingTime;
    }

    public void setExperience(int experience) {
        this.experience = experience;
    }
}

