/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.pack.generation.slicer;

import io.th0rgal.oraxen.pack.generation.slicer.OutputFile;
import io.th0rgal.oraxen.pack.generation.slicer.Slicer;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.imageio.ImageIO;

@ParametersAreNonnullByDefault
public class InputFile {
    public final String path;
    public final List<OutputFile> outputs = new ArrayList<OutputFile>();

    public InputFile(String path) {
        this.path = path;
    }

    public InputFile outputs(OutputFile ... files) {
        Collections.addAll(this.outputs, files);
        return this;
    }

    public void process(Path inputRoot, Path outputRoot, @Nullable Path leftoverRoot) throws IOException {
        Path inputPath = inputRoot.resolve(this.path);
        if (Files.exists(inputPath, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(inputPath, new OpenOption[0]);){
                BufferedImage image = ImageIO.read(is);
                BufferedImage leftoverImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
                Graphics2D leftoverGraphics = leftoverImage.createGraphics();
                leftoverGraphics.drawImage((Image)image, 0, 0, null);
                for (OutputFile outputFile : this.outputs) {
                    outputFile.process(outputRoot, inputPath, image, leftoverGraphics);
                }
                leftoverGraphics.dispose();
                if (leftoverRoot != null) {
                    Path leftoverPath = leftoverRoot.resolve(this.path);
                    Slicer.writeImage(leftoverPath, leftoverImage);
                }
            }
        }
    }
}

