/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.farmblock;

import com.jeff_media.customblockdata.CustomBlockData;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenBlocks;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.farmblock.FarmBlockDryout;
import io.th0rgal.oraxen.utils.BlockHelpers;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class FarmBlockTask
extends BukkitRunnable {
    private final int delay;

    public FarmBlockTask(int delay) {
        this.delay = delay;
    }

    private boolean isAreaWet(FarmBlockDryout mechanic, Block block, PersistentDataContainer pdc) {
        boolean nearWater = mechanic.isConnectedToWaterSource(block, pdc);
        boolean rainingAtBlock = block.getWorld().hasStorm() && block.getWorld().getHighestBlockAt(block.getLocation()) == block;
        return nearWater || rainingAtBlock;
    }

    private void updateBlockModel(Block block, PersistentDataContainer pdc, String model) {
        pdc.remove(NoteBlockMechanic.FARMBLOCK_KEY);
        NoteBlockMechanicFactory.setBlockModel(block, model);
    }

    private void updateBlock(Block block, PersistentDataContainer pdc) {
        if (pdc.getKeys().contains(NoteBlockMechanic.FARMBLOCK_KEY)) {
            NoteBlockMechanic mechanic = OraxenBlocks.getNoteBlockMechanic(block);
            if (mechanic != null && mechanic.hasDryout()) {
                FarmBlockDryout farmMechanic = mechanic.getDryout();
                if (this.isAreaWet(farmMechanic, block, pdc)) {
                    if (pdc.has(NoteBlockMechanic.FARMBLOCK_KEY, PersistentDataType.STRING)) {
                        this.updateBlockModel(block, pdc, farmMechanic.getMoistFarmBlock());
                    }
                    pdc.set(NoteBlockMechanic.FARMBLOCK_KEY, PersistentDataType.INTEGER, (Object)0);
                } else if (pdc.has(NoteBlockMechanic.FARMBLOCK_KEY, PersistentDataType.INTEGER)) {
                    int moistTimerRemain = (Integer)pdc.getOrDefault(NoteBlockMechanic.FARMBLOCK_KEY, PersistentDataType.INTEGER, (Object)0) + this.delay;
                    if (farmMechanic.getDryoutTime() - moistTimerRemain <= 0) {
                        this.updateBlockModel(block, pdc, farmMechanic.getFarmBlock());
                        pdc.set(NoteBlockMechanic.FARMBLOCK_KEY, PersistentDataType.STRING, (Object)farmMechanic.getFarmBlock());
                    } else {
                        pdc.set(NoteBlockMechanic.FARMBLOCK_KEY, PersistentDataType.INTEGER, (Object)moistTimerRemain);
                    }
                }
            } else {
                pdc.remove(NoteBlockMechanic.FARMBLOCK_KEY);
            }
        }
    }

    public void run() {
        for (World world : Bukkit.getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                CustomBlockData.getBlocksWithCustomData((Plugin)OraxenPlugin.get(), (Chunk)chunk).forEach(block -> this.updateBlock((Block)block, BlockHelpers.getPDC(block)));
            }
        }
    }
}

