/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.efficiency;

import io.th0rgal.oraxen.mechanics.Mechanic;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.utils.PotionUtils;
import java.util.function.Function;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.potion.PotionEffectType;

public class EfficiencyMechanic
extends Mechanic {
    private final int amount;
    private final PotionEffectType type;

    public EfficiencyMechanic(MechanicFactory mechanicFactory, ConfigurationSection section) {
        super(mechanicFactory, section, new Function[0]);
        int tempAmount = section.getInt("amount", 1);
        if (tempAmount < 0) {
            this.type = PotionUtils.getEffectType("mining_fatigue");
            this.amount = -tempAmount;
        } else {
            this.type = PotionUtils.getEffectType("haste");
            this.amount = tempAmount;
        }
    }

    public int getAmount() {
        return this.amount;
    }

    public PotionEffectType getType() {
        return this.type;
    }
}

