/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.combat.spell.energyblast;

import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.combat.spell.SpellMechanic;
import java.util.Objects;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;

public class EnergyBlastMechanic
extends SpellMechanic {
    private final Particle particle;
    private Particle.DustOptions particleColor = null;
    private final double damage;
    private final int length;

    public EnergyBlastMechanic(MechanicFactory mechanicFactory, ConfigurationSection section) {
        super(mechanicFactory, section);
        ConfigurationSection particleSection = section.getConfigurationSection("particle");
        assert (particleSection != null);
        this.particle = Particle.valueOf((String)particleSection.getString("type"));
        if (particleSection.isConfigurationSection("color")) {
            ConfigurationSection colorSection = particleSection.getConfigurationSection("color");
            this.particleColor = new Particle.DustOptions(Color.fromRGB((int)Objects.requireNonNull(colorSection).getInt("red"), (int)colorSection.getInt("green"), (int)colorSection.getInt("blue")), (float)particleSection.getInt("size"));
        }
        this.damage = section.getDouble("damage");
        this.length = section.getInt("length");
    }

    public Particle.DustOptions getParticleColor() {
        return this.particleColor;
    }

    public double getDamage() {
        return this.damage;
    }

    public int getLength() {
        return this.length;
    }

    public Particle getParticle() {
        return this.particle;
    }
}

