/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics;

import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.events.OraxenNativeMechanicsRegisteredEvent;
import io.th0rgal.oraxen.compatibilities.CompatibilitiesManager;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.combat.lifeleech.LifeLeechMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.combat.spell.energyblast.EnergyBlastMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.combat.spell.fireball.FireballMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.combat.spell.thor.ThorMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.combat.spell.witherskull.WitherSkullMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.cosmetic.aura.AuraMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.cosmetic.hat.HatMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.cosmetic.skin.SkinMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.cosmetic.skinnable.SkinnableMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.farming.bedrockbreak.BedrockBreakMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.farming.bigmining.BigMiningMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.farming.bottledexp.BottledExpMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.farming.harvesting.HarvestingMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.farming.smelting.SmeltingMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.farming.watering.WateringMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.block.BlockMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.durability.DurabilityMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.efficiency.EfficiencyMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.FurnitureFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.repair.RepairMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.StringBlockMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.misc.armor_effects.ArmorEffectsFactory;
import io.th0rgal.oraxen.mechanics.provided.misc.backpack.BackpackMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.misc.commands.CommandsMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.misc.consumable.ConsumableMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.misc.consumablepotioneffects.ConsumablePotionEffectsFactory;
import io.th0rgal.oraxen.mechanics.provided.misc.custom.CustomMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.misc.food.FoodMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.misc.itemtype.ItemTypeMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.misc.misc.MiscMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.misc.music_disc.MusicDiscMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.misc.soulbound.SoulBoundMechanicFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;

public class MechanicsManager {
    private static final Map<String, MechanicFactory> FACTORIES_BY_MECHANIC_ID = new HashMap<String, MechanicFactory>();
    public static final Map<String, List<Integer>> MECHANIC_TASKS = new HashMap<String, List<Integer>>();
    private static final Map<String, List<Listener>> MECHANICS_LISTENERS = new HashMap<String, List<Listener>>();

    public static void registerNativeMechanics() {
        MechanicsManager.registerFactory("armor_effects", ArmorEffectsFactory::new);
        MechanicsManager.registerFactory("consumable_potion_effects", ConsumablePotionEffectsFactory::new);
        MechanicsManager.registerFactory("soulbound", SoulBoundMechanicFactory::new);
        MechanicsManager.registerFactory("itemtype", ItemTypeMechanicFactory::new);
        MechanicsManager.registerFactory("consumable", ConsumableMechanicFactory::new);
        MechanicsManager.registerFactory("custom", CustomMechanicFactory::new);
        MechanicsManager.registerFactory("commands", CommandsMechanicFactory::new);
        MechanicsManager.registerFactory("backpack", BackpackMechanicFactory::new);
        MechanicsManager.registerFactory("music_disc", MusicDiscMechanicFactory::new);
        MechanicsManager.registerFactory("misc", MiscMechanicFactory::new);
        MechanicsManager.registerFactory("food", FoodMechanicFactory::new);
        MechanicsManager.registerFactory("repair", RepairMechanicFactory::new);
        MechanicsManager.registerFactory("durability", DurabilityMechanicFactory::new);
        MechanicsManager.registerFactory("efficiency", EfficiencyMechanicFactory::new);
        MechanicsManager.registerFactory("block", BlockMechanicFactory::new);
        MechanicsManager.registerFactory("noteblock", NoteBlockMechanicFactory::new);
        MechanicsManager.registerFactory("stringblock", StringBlockMechanicFactory::new);
        MechanicsManager.registerFactory("furniture", FurnitureFactory::new);
        MechanicsManager.registerFactory("aura", AuraMechanicFactory::new);
        MechanicsManager.registerFactory("hat", HatMechanicFactory::new);
        MechanicsManager.registerFactory("skin", SkinMechanicFactory::new);
        MechanicsManager.registerFactory("skinnable", SkinnableMechanicFactory::new);
        MechanicsManager.registerFactory("thor", ThorMechanicFactory::new);
        MechanicsManager.registerFactory("lifeleech", LifeLeechMechanicFactory::new);
        MechanicsManager.registerFactory("energyblast", EnergyBlastMechanicFactory::new);
        MechanicsManager.registerFactory("witherskull", WitherSkullMechanicFactory::new);
        MechanicsManager.registerFactory("fireball", FireballMechanicFactory::new);
        MechanicsManager.registerFactory("bigmining", BigMiningMechanicFactory::new);
        MechanicsManager.registerFactory("smelting", SmeltingMechanicFactory::new);
        MechanicsManager.registerFactory("bottledexp", BottledExpMechanicFactory::new);
        MechanicsManager.registerFactory("harvesting", HarvestingMechanicFactory::new);
        MechanicsManager.registerFactory("watering", WateringMechanicFactory::new);
        if (CompatibilitiesManager.hasPlugin("ProtocolLib")) {
            MechanicsManager.registerFactory("bedrockbreak", BedrockBreakMechanicFactory::new);
        }
        Bukkit.getScheduler().callSyncMethod((Plugin)OraxenPlugin.get(), () -> {
            Bukkit.getPluginManager().callEvent((Event)new OraxenNativeMechanicsRegisteredEvent());
            return null;
        });
    }

    public static void registerMechanicFactory(String mechanicId, MechanicFactory factory, boolean enabled) {
        if (enabled) {
            FACTORIES_BY_MECHANIC_ID.put(mechanicId, factory);
        }
    }

    public static void unregisterMechanicFactory(String mechanicId) {
        FACTORIES_BY_MECHANIC_ID.remove(mechanicId);
        MechanicsManager.unloadListeners(mechanicId);
        MechanicsManager.unregisterTasks(mechanicId);
    }

    @Deprecated(forRemoval=true, since="1.158.0")
    public static void registerMechanicFactory(String mechanicId, FactoryConstructor constructor) {
        MechanicsManager.registerFactory(mechanicId, constructor);
    }

    private static void registerFactory(String mechanicId, FactoryConstructor constructor) {
        Map.Entry<File, YamlConfiguration> mechanicsEntry = OraxenPlugin.get().getResourceManager().getMechanicsEntry();
        YamlConfiguration mechanicsConfig = mechanicsEntry.getValue();
        boolean updated = false;
        ConfigurationSection factorySection = mechanicsConfig.getConfigurationSection(mechanicId);
        if (factorySection != null && factorySection.getBoolean("enabled")) {
            FACTORIES_BY_MECHANIC_ID.put(mechanicId, constructor.create(factorySection));
        }
    }

    public static void registerTask(String mechanicId, BukkitTask task) {
        MECHANIC_TASKS.compute(mechanicId, (key, value) -> {
            if (value == null) {
                value = new ArrayList<Integer>();
            }
            value.add(task.getTaskId());
            return value;
        });
    }

    public static void unregisterTasks() {
        MECHANIC_TASKS.values().forEach(tasks -> tasks.forEach(arg_0 -> ((BukkitScheduler)Bukkit.getScheduler()).cancelTask(arg_0)));
        MECHANIC_TASKS.clear();
    }

    public static void unregisterTasks(String mechanicId) {
        MECHANIC_TASKS.computeIfPresent(mechanicId, (key, value) -> {
            value.forEach(arg_0 -> ((BukkitScheduler)Bukkit.getScheduler()).cancelTask(arg_0));
            return Collections.emptyList();
        });
    }

    public static void registerListeners(JavaPlugin plugin, String mechanicId, Listener ... listeners) {
        for (Listener listener : listeners) {
            Bukkit.getPluginManager().registerEvents(listener, (Plugin)plugin);
        }
        MECHANICS_LISTENERS.compute(mechanicId, (key, value) -> {
            if (value == null) {
                value = new ArrayList<Listener>();
            }
            value.addAll(Arrays.asList(listeners));
            return value;
        });
    }

    public static void unloadListeners() {
        for (Listener listener : MECHANICS_LISTENERS.values().stream().flatMap(Collection::stream).toList()) {
            HandlerList.unregisterAll((Listener)listener);
        }
    }

    public static void unloadListeners(String mechanicId) {
        for (Listener listener : MECHANICS_LISTENERS.remove(mechanicId)) {
            HandlerList.unregisterAll((Listener)listener);
        }
    }

    public static MechanicFactory getMechanicFactory(String mechanicID) {
        return FACTORIES_BY_MECHANIC_ID.get(mechanicID);
    }

    @FunctionalInterface
    public static interface FactoryConstructor {
        public MechanicFactory create(ConfigurationSection var1);
    }
}

