/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics;

import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.mechanics.Mechanic;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public abstract class MechanicFactory {
    private final Map<String, Mechanic> mechanicByItem = new HashMap<String, Mechanic>();
    private final String mechanicId;
    private final ConfigurationSection section;

    protected MechanicFactory(ConfigurationSection section) {
        this.section = section;
        this.mechanicId = section.getName();
    }

    protected MechanicFactory(String mechanicId) {
        this.mechanicId = mechanicId;
        this.section = null;
    }

    protected ConfigurationSection getSection() {
        return this.section;
    }

    public abstract Mechanic parse(ConfigurationSection var1);

    protected void addToImplemented(Mechanic mechanic) {
        this.mechanicByItem.put(mechanic.getItemID(), mechanic);
    }

    public Set<String> getItems() {
        return this.mechanicByItem.keySet();
    }

    public boolean isNotImplementedIn(String itemID) {
        return !this.mechanicByItem.containsKey(itemID);
    }

    public boolean isNotImplementedIn(ItemStack itemStack) {
        return !this.mechanicByItem.containsKey(OraxenItems.getIdByItem(itemStack));
    }

    public Mechanic getMechanic(String itemID) {
        return this.mechanicByItem.get(itemID);
    }

    public Mechanic getMechanic(ItemStack itemStack) {
        return this.mechanicByItem.get(OraxenItems.getIdByItem(itemStack));
    }

    public String getMechanicID() {
        return this.mechanicId;
    }
}

