/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.font.packets;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.utils.AdventureUtils;
import io.th0rgal.oraxen.utils.PacketHelpers;
import io.th0rgal.oraxen.utils.logs.Logs;
import net.kyori.adventure.text.Component;
import org.bukkit.plugin.Plugin;

public class TitlePacketListener
extends PacketAdapter {
    public TitlePacketListener() {
        super((Plugin)OraxenPlugin.get(), ListenerPriority.MONITOR, new PacketType[]{PacketType.Play.Server.SET_TITLE_TEXT, PacketType.Play.Server.SET_SUBTITLE_TEXT, PacketType.Play.Server.SET_ACTION_BAR_TEXT});
    }

    public void onPacketSending(PacketEvent event) {
        WrappedChatComponent actionbar;
        PacketContainer packet = event.getPacket();
        if (packet.getType() == PacketType.Play.Server.SET_TITLE_TEXT && Settings.FORMAT_TITLES.toBool().booleanValue()) {
            WrappedChatComponent title = this.formatTitle(packet);
            if (title != null) {
                packet.getChatComponents().write(0, (Object)title);
            }
        } else if (packet.getType() == PacketType.Play.Server.SET_SUBTITLE_TEXT && Settings.FORMAT_SUBTITLES.toBool().booleanValue()) {
            WrappedChatComponent subtitle = this.formatTitle(packet);
            if (subtitle != null) {
                packet.getChatComponents().write(0, (Object)subtitle);
            }
        } else if (packet.getType() == PacketType.Play.Server.SET_ACTION_BAR_TEXT && Settings.FORMAT_ACTION_BAR.toBool().booleanValue() && (actionbar = this.formatTitle(packet)) != null) {
            packet.getChatComponents().write(0, (Object)actionbar);
        }
    }

    private WrappedChatComponent formatTitle(PacketContainer packet) {
        try {
            String title = packet.getChatComponents().read(0) == null ? (String)AdventureUtils.MINI_MESSAGE.serialize((Component)packet.getModifier().read(1)) : PacketHelpers.readJson(((WrappedChatComponent)packet.getChatComponents().read(0)).getJson());
            return WrappedChatComponent.fromJson((String)PacketHelpers.toJson(title));
        }
        catch (Exception e) {
            String type = packet.getType() == PacketType.Play.Server.SET_TITLE_TEXT ? "title" : (packet.getType() == PacketType.Play.Server.SET_SUBTITLE_TEXT ? "subtitle" : "actionbar");
            if (Settings.DEBUG.toBool().booleanValue()) {
                Logs.logWarning("Error whilst reading " + type + " packet");
                if (Settings.DEBUG.toBool().booleanValue()) {
                    e.printStackTrace();
                }
            }
            return null;
        }
    }
}

