/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.commands;

import dev.jorel.commandapi.AbstractCommandAPICommand;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ArgumentSuggestions;
import dev.jorel.commandapi.arguments.TextArgument;
import dev.jorel.commandapi.executors.ExecutorType;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.config.Message;
import io.th0rgal.oraxen.hud.Hud;
import io.th0rgal.oraxen.hud.HudManager;
import io.th0rgal.oraxen.utils.AdventureUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class HudCommand {
    private final HudManager manager = OraxenPlugin.get().getHudManager();

    CommandAPICommand getHudCommand() {
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("hud").withPermission("oraxen.command.hud.toggle")).withArguments((AbstractArgument[])new Argument[]{(Argument)new TextArgument("type").replaceSuggestions(ArgumentSuggestions.strings((String[])new String[]{"toggle"}))})).withSubcommand((AbstractCommandAPICommand)this.disableHudsCommand());
    }

    private CommandAPICommand disableHudsCommand() {
        String[] huds = this.manager.getHuds().keySet().toArray(new String[0]);
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("toggle").withPermission("oraxen.command.hud.toggle")).withArguments((AbstractArgument[])new Argument[]{(Argument)new TextArgument("type").replaceSuggestions(ArgumentSuggestions.strings((String[])huds))})).executes((sender, args) -> {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                String hudId = (String)args.get("type");
                Hud hud = this.manager.getHudFromID(hudId);
                if (hud == null) {
                    Message.HUD_NO_HUD.send((CommandSender)player, AdventureUtils.tagResolver("hud_id", hudId));
                    return;
                }
                boolean toggle = !this.manager.getHudState(player);
                this.manager.setHudState(player, toggle);
                this.manager.setActiveHud(player, hud);
                if (toggle) {
                    Message.HUD_TOGGLE_ON.send((CommandSender)player, AdventureUtils.tagResolver("hud_id", hudId));
                    this.manager.enableHud(player, hud);
                } else {
                    Message.HUD_TOGGLE_OFF.send((CommandSender)player, AdventureUtils.tagResolver("hud_id", hudId));
                    this.manager.disableHud(player);
                }
            }
        }, new ExecutorType[0]);
    }
}

