/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.mariadb.jdbc.type;

import com.craftaro.third_party.org.mariadb.jdbc.type.Geometry;
import com.craftaro.third_party.org.mariadb.jdbc.type.Point;
import java.util.Arrays;
import java.util.Objects;

public class LineString
implements Geometry {
    private final Point[] points;
    private final boolean open;

    public LineString(Point[] points, boolean open) {
        this.points = points;
        this.open = open;
    }

    public Point[] getPoints() {
        return this.points;
    }

    public boolean isOpen() {
        return this.open;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LINESTRING(");
        int index = 0;
        for (Point pt : this.points) {
            if (index++ > 0) {
                sb.append(",");
            }
            sb.append(pt.getX()).append(" ").append(pt.getY());
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof LineString)) {
            return false;
        }
        return this.open == ((LineString)o).isOpen() && this.toString().equals(o.toString());
    }

    public int hashCode() {
        int result = Objects.hash(this.open);
        result = 31 * result + Arrays.hashCode(this.points);
        return result;
    }
}

