/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.mariadb.jdbc.plugin.codec;

import com.craftaro.third_party.org.mariadb.jdbc.client.ColumnDecoder;
import com.craftaro.third_party.org.mariadb.jdbc.client.Context;
import com.craftaro.third_party.org.mariadb.jdbc.client.DataType;
import com.craftaro.third_party.org.mariadb.jdbc.client.ReadableByteBuf;
import com.craftaro.third_party.org.mariadb.jdbc.client.socket.Writer;
import com.craftaro.third_party.org.mariadb.jdbc.client.util.MutableInt;
import com.craftaro.third_party.org.mariadb.jdbc.plugin.Codec;
import com.craftaro.third_party.org.mariadb.jdbc.type.Geometry;
import com.craftaro.third_party.org.mariadb.jdbc.type.LineString;
import com.craftaro.third_party.org.mariadb.jdbc.type.Point;
import com.craftaro.third_party.org.mariadb.jdbc.type.Polygon;
import java.io.IOException;
import java.sql.SQLDataException;
import java.util.Calendar;

public class PolygonCodec
implements Codec<Polygon> {
    public static final PolygonCodec INSTANCE = new PolygonCodec();

    @Override
    public String className() {
        return Polygon.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return column.getType() == DataType.GEOMETRY && type.isAssignableFrom(Polygon.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Polygon;
    }

    @Override
    public Polygon decodeText(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        return this.decodeBinary(buf, length, column, cal);
    }

    @Override
    public Polygon decodeBinary(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        if (column.getType() == DataType.GEOMETRY) {
            buf.skip(4);
            Geometry geo = Geometry.getGeometry(buf, length.get() - 4, column);
            if (geo instanceof Polygon) {
                return (Polygon)geo;
            }
            throw new SQLDataException(String.format("Geometric type %s cannot be decoded as Polygon", geo.getClass().getName()));
        }
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Polygon", new Object[]{column.getType()}));
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLength) throws IOException {
        encoder.writeBytes(("ST_PolyFromText('" + value.toString() + "')").getBytes());
    }

    @Override
    public void encodeBinary(Writer encoder, Object value, Calendar cal, Long maxLength) throws IOException {
        Polygon poly = (Polygon)value;
        int length = 13;
        for (LineString ls : poly.getLines()) {
            length += 4 + ls.getPoints().length * 16;
        }
        encoder.writeLength(length);
        encoder.writeInt(0);
        encoder.writeByte(1);
        encoder.writeInt(3);
        encoder.writeInt(poly.getLines().length);
        for (LineString ls : poly.getLines()) {
            encoder.writeInt(ls.getPoints().length);
            for (Point pt : ls.getPoints()) {
                encoder.writeDouble(pt.getX());
                encoder.writeDouble(pt.getY());
            }
        }
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.BLOB.get();
    }
}

