/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.mariadb.jdbc.plugin.codec;

import com.craftaro.third_party.org.mariadb.jdbc.client.ColumnDecoder;
import com.craftaro.third_party.org.mariadb.jdbc.client.Context;
import com.craftaro.third_party.org.mariadb.jdbc.client.DataType;
import com.craftaro.third_party.org.mariadb.jdbc.client.ReadableByteBuf;
import com.craftaro.third_party.org.mariadb.jdbc.client.socket.Writer;
import com.craftaro.third_party.org.mariadb.jdbc.client.util.MutableInt;
import com.craftaro.third_party.org.mariadb.jdbc.plugin.Codec;
import java.io.IOException;
import java.sql.SQLDataException;
import java.util.Calendar;
import java.util.EnumSet;

public class LongCodec
implements Codec<Long> {
    public static final LongCodec INSTANCE = new LongCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.FLOAT, new DataType[]{DataType.DOUBLE, DataType.OLDDECIMAL, DataType.VARCHAR, DataType.DECIMAL, DataType.ENUM, DataType.VARSTRING, DataType.STRING, DataType.TINYINT, DataType.SMALLINT, DataType.MEDIUMINT, DataType.INTEGER, DataType.BIGINT, DataType.BIT, DataType.YEAR, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    @Override
    public String className() {
        return Long.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && (type.isPrimitive() && type == Integer.TYPE || type.isAssignableFrom(Long.class));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Long;
    }

    @Override
    public Long decodeText(ReadableByteBuf buffer, MutableInt length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        return column.decodeLongText(buffer, length);
    }

    @Override
    public Long decodeBinary(ReadableByteBuf buffer, MutableInt length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        return column.decodeLongBinary(buffer, length);
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLen) throws IOException {
        encoder.writeAscii(value.toString());
    }

    @Override
    public void encodeBinary(Writer encoder, Object value, Calendar cal, Long maxLength) throws IOException {
        encoder.writeLong((Long)value);
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.BIGINT.get();
    }
}

