/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.mariadb.jdbc.plugin.codec;

import com.craftaro.third_party.org.mariadb.jdbc.client.ColumnDecoder;
import com.craftaro.third_party.org.mariadb.jdbc.client.Context;
import com.craftaro.third_party.org.mariadb.jdbc.client.DataType;
import com.craftaro.third_party.org.mariadb.jdbc.client.ReadableByteBuf;
import com.craftaro.third_party.org.mariadb.jdbc.client.socket.Writer;
import com.craftaro.third_party.org.mariadb.jdbc.client.util.MutableInt;
import com.craftaro.third_party.org.mariadb.jdbc.plugin.Codec;
import java.io.IOException;
import java.sql.SQLDataException;
import java.util.Calendar;
import java.util.EnumSet;

public class FloatCodec
implements Codec<Float> {
    public static final FloatCodec INSTANCE = new FloatCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.TINYINT, new DataType[]{DataType.SMALLINT, DataType.MEDIUMINT, DataType.INTEGER, DataType.FLOAT, DataType.BIGINT, DataType.OLDDECIMAL, DataType.DECIMAL, DataType.YEAR, DataType.DOUBLE, DataType.VARCHAR, DataType.VARSTRING, DataType.STRING, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    @Override
    public String className() {
        return Float.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && (type.isPrimitive() && type == Float.TYPE || type.isAssignableFrom(Float.class));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Float;
    }

    @Override
    public Float decodeText(ReadableByteBuf buffer, MutableInt length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        return Float.valueOf(column.decodeFloatText(buffer, length));
    }

    @Override
    public Float decodeBinary(ReadableByteBuf buffer, MutableInt length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        return Float.valueOf(column.decodeFloatBinary(buffer, length));
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLen) throws IOException {
        encoder.writeAscii(value.toString());
    }

    @Override
    public void encodeBinary(Writer encoder, Object value, Calendar cal, Long maxLength) throws IOException {
        encoder.writeFloat(((Float)value).floatValue());
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.FLOAT.get();
    }
}

