/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.mariadb.jdbc.message.client;

import com.craftaro.third_party.org.mariadb.jdbc.ServerPreparedStatement;
import com.craftaro.third_party.org.mariadb.jdbc.client.Context;
import com.craftaro.third_party.org.mariadb.jdbc.client.socket.Writer;
import com.craftaro.third_party.org.mariadb.jdbc.client.util.Parameter;
import com.craftaro.third_party.org.mariadb.jdbc.client.util.Parameters;
import com.craftaro.third_party.org.mariadb.jdbc.export.MaxAllowedPacketException;
import com.craftaro.third_party.org.mariadb.jdbc.export.Prepare;
import com.craftaro.third_party.org.mariadb.jdbc.message.client.RedoableWithPrepareClientMessage;
import com.craftaro.third_party.org.mariadb.jdbc.message.server.PrepareResultPacket;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class BulkExecutePacket
implements RedoableWithPrepareClientMessage {
    private List<Parameters> batchParameterList;
    private final String command;
    private final ServerPreparedStatement prep;
    private Prepare prepareResult;

    public BulkExecutePacket(Prepare prepareResult, List<Parameters> batchParameterList, String command, ServerPreparedStatement prep) {
        this.batchParameterList = batchParameterList;
        this.prepareResult = prepareResult;
        this.command = command;
        this.prep = prep;
    }

    @Override
    public void saveParameters() {
        ArrayList<Parameters> savedList = new ArrayList<Parameters>(this.batchParameterList.size());
        for (Parameters parameterList : this.batchParameterList) {
            savedList.add(parameterList.clone());
        }
        this.batchParameterList = savedList;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int encode(Writer writer, Context context, Prepare newPrepareResult) throws IOException, SQLException {
        statementId = newPrepareResult != null && newPrepareResult.getStatementId() != -1 ? newPrepareResult.getStatementId() : (this.prepareResult != null ? this.prepareResult.getStatementId() : -1);
        paramIterator = this.batchParameterList.iterator();
        parameters = paramIterator.next();
        parameterCount = parameters.size();
        parameterHeaderType = new Parameter[parameterCount];
        for (i = 0; i < parameterCount; ++i) {
            parameterHeaderType[i] = parameters.get(i);
        }
        lastCmdData = null;
        bulkPacketNo = 0;
        block1: while (true) {
            ++bulkPacketNo;
            writer.initPacket();
            writer.writeByte(250);
            writer.writeInt(statementId);
            writer.writeShort((short)128);
            for (i = 0; i < parameterCount; ++i) {
                writer.writeShort((short)parameterHeaderType[i].getBinaryEncodeType());
            }
            if (lastCmdData != null) {
                if (writer.throwMaxAllowedLength(lastCmdData.length)) {
                    throw new MaxAllowedPacketException("query size is >= to max_allowed_packet", writer.getCmdLength() != 0L);
                }
                writer.writeBytes(lastCmdData);
                writer.mark();
                lastCmdData = null;
                if (!paramIterator.hasNext()) break;
                parameters = paramIterator.next();
            }
            while (true) {
                for (i = 0; i < parameterCount; ++i) {
                    param = parameters.get(i);
                    if (param.isNull()) {
                        writer.writeByte(1);
                        continue;
                    }
                    writer.writeByte(0);
                    param.encodeBinary(writer);
                }
                if (!writer.isMarked() && writer.hasFlushed()) {
                    writer.flush();
                    if (!paramIterator.hasNext()) break block1;
                    parameters = paramIterator.next();
                    j = 0;
                    while (true) {
                        if (j >= parameterCount) continue block1;
                        parameterHeaderType[j] = parameters.get(j);
                        ++j;
                    }
                }
                if (writer.isMarked() && writer.throwMaxAllowedLength(writer.pos())) {
                    writer.flushBufferStopAtMark();
                    writer.mark();
                    lastCmdData = writer.resetMark();
                    continue block1;
                }
                writer.mark();
                if (writer.bufIsDataAfterMark()) {
                    lastCmdData = writer.resetMark();
                    continue block1;
                }
                if (!paramIterator.hasNext()) break block1;
                parameters = paramIterator.next();
                i = 0;
                while (true) {
                    if (i >= parameterCount) ** continue;
                    if (parameterHeaderType[i].getBinaryEncodeType() != parameters.get(i).getBinaryEncodeType() && !parameters.get(i).isNull()) {
                        writer.flush();
                        j = 0;
                        while (true) {
                            if (j < parameterCount) ** break;
                            continue block1;
                            parameterHeaderType[j] = parameters.get(j);
                            ++j;
                        }
                    }
                    ++i;
                }
                break;
            }
            break;
        }
        writer.flush();
        return bulkPacketNo;
    }

    @Override
    public int batchUpdateLength() {
        return this.batchParameterList.size();
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public ServerPreparedStatement prep() {
        return this.prep;
    }

    @Override
    public boolean binaryProtocol() {
        return true;
    }

    @Override
    public String description() {
        return this.command;
    }

    @Override
    public void setPrepareResult(PrepareResultPacket prepareResult) {
        this.prepareResult = prepareResult;
    }
}

