/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.mariadb.jdbc.client.socket.impl;

import com.craftaro.third_party.org.mariadb.jdbc.client.util.MutableByte;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;

public class CompressOutputStream
extends OutputStream {
    private static final int MIN_COMPRESSION_SIZE = 1536;
    private final OutputStream out;
    private final MutableByte sequence;
    private final byte[] header = new byte[7];
    private byte[] longPacketBuffer = null;

    public CompressOutputStream(OutputStream out, MutableByte compressionSequence) {
        this.out = out;
        this.sequence = compressionSequence;
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        if (len + (this.longPacketBuffer != null ? this.longPacketBuffer.length : 0) < 1536) {
            if (this.longPacketBuffer != null) {
                this.header[0] = (byte)(len + this.longPacketBuffer.length);
                this.header[1] = (byte)(len + this.longPacketBuffer.length >>> 8);
                this.header[2] = 0;
                this.header[3] = this.sequence.incrementAndGet();
                this.header[4] = 0;
                this.header[5] = 0;
                this.header[6] = 0;
                this.out.write(this.header, 0, 7);
                this.out.write(this.longPacketBuffer, 0, this.longPacketBuffer.length);
                this.out.write(b2, off, len);
                this.longPacketBuffer = null;
                return;
            }
            this.header[0] = (byte)len;
            this.header[1] = (byte)(len >>> 8);
            this.header[2] = 0;
            this.header[3] = this.sequence.incrementAndGet();
            this.header[4] = 0;
            this.header[5] = 0;
            this.header[6] = 0;
            this.out.write(this.header, 0, 7);
            this.out.write(b2, off, len);
        } else {
            int sent = 0;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                try (DeflaterOutputStream deflater = new DeflaterOutputStream(baos);){
                    if (this.longPacketBuffer != null) {
                        deflater.write(this.longPacketBuffer, 0, this.longPacketBuffer.length);
                        sent = this.longPacketBuffer.length;
                        this.longPacketBuffer = null;
                    }
                    if (len + sent > 0xFFFFFF) {
                        int remaining = len + sent - 0xFFFFFF;
                        this.longPacketBuffer = new byte[remaining];
                        System.arraycopy(b2, off + 0xFFFFFF - sent, this.longPacketBuffer, 0, remaining);
                    }
                    int bufLenSent = Math.min(0xFFFFFF - sent, len);
                    deflater.write(b2, off, bufLenSent);
                    sent += bufLenSent;
                    deflater.finish();
                }
                byte[] compressedBytes = baos.toByteArray();
                int compressLen = compressedBytes.length;
                this.header[0] = (byte)compressLen;
                this.header[1] = (byte)(compressLen >>> 8);
                this.header[2] = (byte)(compressLen >>> 16);
                this.header[3] = this.sequence.incrementAndGet();
                this.header[4] = (byte)sent;
                this.header[5] = (byte)(sent >>> 8);
                this.header[6] = (byte)(sent >>> 16);
                this.out.write(this.header, 0, 7);
                this.out.write(compressedBytes, 0, compressLen);
                this.out.flush();
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.longPacketBuffer != null) {
            byte[] b2 = this.longPacketBuffer;
            this.longPacketBuffer = null;
            this.write(b2, 0, b2.length);
        }
        this.out.flush();
        this.sequence.set((byte)-1);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void write(int b2) throws IOException {
        throw new IOException("NOT EXPECTED !");
    }
}

