/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.impl.AbstractField;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.Internal;
import com.craftaro.third_party.org.jooq.impl.Names;

final class WidthBucket<T extends Number>
extends AbstractField<T> {
    private static final long serialVersionUID = -4866100604361006859L;
    private final Field<T> field;
    private final Field<T> low;
    private final Field<T> high;
    private final Field<Integer> buckets;

    WidthBucket(Field<T> field, Field<T> low, Field<T> high, Field<Integer> buckets) {
        super(Names.N_WIDTH_BUCKET, field.getDataType());
        this.field = field;
        this.low = low;
        this.high = high;
        this.buckets = buckets;
    }

    @Override
    public void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case POSTGRES: {
                ctx.visit(DSL.keyword("width_bucket")).sql('(').visit(this.field).sql(", ").visit(this.low).sql(", ").visit(this.high).sql(", ").visit(this.buckets).sql(')');
                break;
            }
            default: {
                ctx.visit(DSL.when(this.field.lt(this.low), DSL.zero()).when(this.field.ge(this.high), Internal.iadd(this.buckets, DSL.one())).otherwise(Internal.iadd(DSL.floor(Internal.idiv(Internal.imul(Internal.isub(this.field, this.low), this.buckets), Internal.isub(this.high, this.low))), DSL.one())));
            }
        }
    }
}

