/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Clause;
import com.craftaro.third_party.org.jooq.Configuration;
import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.Record;
import com.craftaro.third_party.org.jooq.Table;
import com.craftaro.third_party.org.jooq.TruncateCascadeStep;
import com.craftaro.third_party.org.jooq.TruncateFinalStep;
import com.craftaro.third_party.org.jooq.TruncateIdentityStep;
import com.craftaro.third_party.org.jooq.impl.AbstractRowCountQuery;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.Keywords;

final class TruncateImpl<R extends Record>
extends AbstractRowCountQuery
implements TruncateIdentityStep<R> {
    private static final long serialVersionUID = 8904572826501186329L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.TRUNCATE};
    private final Table<R> table;
    private Boolean cascade;
    private Boolean restartIdentity;

    public TruncateImpl(Configuration configuration, Table<R> table) {
        super(configuration);
        this.table = table;
    }

    final Table<?> $table() {
        return this.table;
    }

    final boolean $cascade() {
        return Boolean.TRUE.equals(this.cascade);
    }

    @Override
    public final TruncateFinalStep<R> cascade() {
        this.cascade = true;
        return this;
    }

    @Override
    public final TruncateFinalStep<R> restrict() {
        this.cascade = false;
        return this;
    }

    @Override
    public final TruncateCascadeStep<R> restartIdentity() {
        this.restartIdentity = true;
        return this;
    }

    @Override
    public final TruncateCascadeStep<R> continueIdentity() {
        this.restartIdentity = false;
        return this;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case FIREBIRD: 
            case SQLITE: {
                ctx.visit(DSL.delete(this.table));
                break;
            }
            default: {
                ctx.start(Clause.TRUNCATE_TRUNCATE).visit(Keywords.K_TRUNCATE_TABLE).sql(' ').visit(this.table);
                if (this.restartIdentity != null) {
                    ctx.formatSeparator().visit(this.restartIdentity != false ? Keywords.K_RESTART_IDENTITY : Keywords.K_CONTINUE_IDENTITY);
                }
                if (this.cascade != null) {
                    ctx.formatSeparator().visit(this.cascade != false ? Keywords.K_CASCADE : Keywords.K_RESTRICT);
                }
                ctx.end(Clause.TRUNCATE_TRUNCATE);
            }
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

