/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Configuration;
import com.craftaro.third_party.org.jooq.Meta;
import com.craftaro.third_party.org.jooq.MetaProvider;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.Source;
import com.craftaro.third_party.org.jooq.impl.InformationSchemaMetaProvider;
import com.craftaro.third_party.org.jooq.impl.InterpreterMetaProvider;
import com.craftaro.third_party.org.jooq.impl.TranslatingMetaProvider;
import com.craftaro.third_party.org.jooq.tools.StringUtils;

final class SourceMetaProvider
implements MetaProvider {
    private final Configuration configuration;
    private final Source[] sources;

    SourceMetaProvider(Configuration configuration, Source ... sources) {
        this.configuration = configuration;
        this.sources = sources;
    }

    @Override
    public final Meta provide() {
        if (this.sources.length > 0) {
            String s = this.sources[0].readString();
            this.sources[0] = Source.of(s);
            if (s.startsWith("<?xml") || s.startsWith("<information_schema") || s.startsWith("<!--")) {
                return new InformationSchemaMetaProvider(this.configuration, this.sources).provide();
            }
        }
        SQLDialect dialect = this.configuration.settings().getInterpreterDialect();
        switch (StringUtils.defaultIfNull(dialect, SQLDialect.DEFAULT).family()) {
            case DEFAULT: {
                return new InterpreterMetaProvider(this.configuration, this.sources).provide();
            }
            case DERBY: 
            case H2: 
            case HSQLDB: 
            case SQLITE: {
                return new TranslatingMetaProvider(this.configuration, this.sources).provide();
            }
        }
        throw new UnsupportedOperationException("Interpreter dialect not yet supported: " + (Object)((Object)dialect));
    }
}

