/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Catalog;
import com.craftaro.third_party.org.jooq.Clause;
import com.craftaro.third_party.org.jooq.Comment;
import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.Domain;
import com.craftaro.third_party.org.jooq.Internal;
import com.craftaro.third_party.org.jooq.Name;
import com.craftaro.third_party.org.jooq.Schema;
import com.craftaro.third_party.org.jooq.Sequence;
import com.craftaro.third_party.org.jooq.Table;
import com.craftaro.third_party.org.jooq.UDT;
import com.craftaro.third_party.org.jooq.impl.AbstractNamed;
import com.craftaro.third_party.org.jooq.impl.CatalogImpl;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.Tools;
import com.craftaro.third_party.org.jooq.tools.StringUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

@Internal
public class SchemaImpl
extends AbstractNamed
implements Schema {
    private static final long serialVersionUID = -8101463810207566546L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.SCHEMA, Clause.SCHEMA_REFERENCE};
    static final Schema DEFAULT_SCHEMA = new SchemaImpl("");
    private Catalog catalog;

    public SchemaImpl(String name) {
        this(name, null);
    }

    public SchemaImpl(String name, Catalog catalog) {
        this(DSL.name(name), catalog);
    }

    public SchemaImpl(String name, Catalog catalog, String comment) {
        this(DSL.name(name), catalog, DSL.comment(comment));
    }

    public SchemaImpl(Name name) {
        this(name, (Catalog)null);
    }

    public SchemaImpl(Name name, Catalog catalog) {
        this(name, catalog, null);
    }

    public SchemaImpl(Name name, Catalog catalog, Comment comment) {
        super(SchemaImpl.qualify(catalog, name), comment);
        this.catalog = catalog;
    }

    @Override
    public Catalog getCatalog() {
        if (this.catalog == null) {
            this.catalog = this.getQualifiedName().qualified() ? DSL.catalog(this.getQualifiedName().qualifier()) : null;
        }
        return this.catalog;
    }

    @Override
    public final void accept(Context<?> ctx) {
        Schema mappedSchema;
        Catalog mappedCatalog;
        if (ctx.qualifyCatalog() && (mappedCatalog = Tools.getMappedCatalog(ctx.configuration(), this.getCatalog())) != null && !"".equals(mappedCatalog.getName())) {
            ctx.visit(mappedCatalog);
            ctx.sql('.');
        }
        ctx.visit((mappedSchema = Tools.getMappedSchema(ctx.configuration(), this)) != null ? mappedSchema.getUnqualifiedName() : this.getUnqualifiedName());
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public final Table<?> getTable(String name) {
        return SchemaImpl.find(name, this.getTables());
    }

    @Override
    public final Table<?> getTable(Name name) {
        return SchemaImpl.find(name, this.getTables());
    }

    @Override
    public final UDT<?> getUDT(String name) {
        return SchemaImpl.find(name, this.getUDTs());
    }

    @Override
    public final UDT<?> getUDT(Name name) {
        return SchemaImpl.find(name, this.getUDTs());
    }

    @Override
    public final Domain<?> getDomain(String name) {
        return SchemaImpl.find(name, this.getDomains());
    }

    @Override
    public final Domain<?> getDomain(Name name) {
        return SchemaImpl.find(name, this.getDomains());
    }

    @Override
    public final Sequence<?> getSequence(String name) {
        return SchemaImpl.find(name, this.getSequences());
    }

    @Override
    public final Sequence<?> getSequence(Name name) {
        return SchemaImpl.find(name, this.getSequences());
    }

    @Override
    public List<Table<?>> getTables() {
        return Collections.emptyList();
    }

    @Override
    public List<UDT<?>> getUDTs() {
        return Collections.emptyList();
    }

    @Override
    public List<Domain<?>> getDomains() {
        return Collections.emptyList();
    }

    @Override
    public List<Sequence<?>> getSequences() {
        return Collections.emptyList();
    }

    @Override
    public final Stream<Table<?>> tableStream() {
        return this.getTables().stream();
    }

    @Override
    public final Stream<UDT<?>> udtStream() {
        return this.getUDTs().stream();
    }

    @Override
    public final Stream<Domain<?>> domainStream() {
        return this.getDomains().stream();
    }

    @Override
    public final Stream<Sequence<?>> sequenceStream() {
        return this.getSequences().stream();
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof SchemaImpl) {
            SchemaImpl other = (SchemaImpl)that;
            return StringUtils.equals(StringUtils.defaultIfNull(this.getCatalog(), CatalogImpl.DEFAULT_CATALOG), StringUtils.defaultIfNull(other.getCatalog(), CatalogImpl.DEFAULT_CATALOG)) && StringUtils.equals(this.getName(), other.getName());
        }
        return super.equals(that);
    }
}

