/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Clause;
import com.craftaro.third_party.org.jooq.Condition;
import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.Row;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.Select;
import com.craftaro.third_party.org.jooq.Table;
import com.craftaro.third_party.org.jooq.TableLike;
import com.craftaro.third_party.org.jooq.impl.AbstractCondition;
import com.craftaro.third_party.org.jooq.impl.AliasedSelect;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.Keywords;
import com.craftaro.third_party.org.jooq.impl.Tools;
import java.util.ArrayList;
import java.util.Set;

final class RowIsNull
extends AbstractCondition {
    private static final long serialVersionUID = -1806139685201770706L;
    private static final Set<SQLDialect> EMULATE_NULL_ROW = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE);
    private static final Set<SQLDialect> EMULATE_NULL_QUERY = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.SQLITE);
    private final Row row;
    private final Select<?> select;
    private final boolean isNull;

    RowIsNull(Row row, boolean isNull) {
        this.row = row;
        this.select = null;
        this.isNull = isNull;
    }

    RowIsNull(Select<?> select, boolean isNull) {
        this.row = null;
        this.select = select;
        this.isNull = isNull;
    }

    @Override
    final boolean isNullable() {
        return false;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.row != null && EMULATE_NULL_ROW.contains((Object)ctx.dialect())) {
            ctx.visit(this.condition(this.row.fields()));
        } else if (this.select != null && EMULATE_NULL_QUERY.contains((Object)ctx.dialect())) {
            if (this.select.getSelect().size() == 1) {
                this.acceptStandard(ctx);
            } else {
                Table t = new AliasedSelect(this.select).as("t");
                ctx.visit(DSL.inline(1).eq(DSL.selectCount().from((TableLike<?>)t).where(this.condition(t.fields()))));
            }
        } else {
            this.acceptStandard(ctx);
        }
    }

    private final Condition condition(Field<?>[] fields) {
        ArrayList<Condition> conditions = new ArrayList<Condition>(fields.length);
        for (Field<?> field : fields) {
            conditions.add(this.isNull ? field.isNull() : field.isNotNull());
        }
        return DSL.and(conditions);
    }

    private final void acceptStandard(Context<?> ctx) {
        if (this.row != null) {
            ctx.visit(this.row);
        } else {
            Tools.visitSubquery(ctx, this.select, true);
        }
        ctx.sql(' ').visit(this.isNull ? Keywords.K_IS_NULL : Keywords.K_IS_NOT_NULL);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }
}

