/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Clause;
import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.impl.AbstractCondition;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.Keywords;

final class RegexpLike
extends AbstractCondition {
    private static final long serialVersionUID = 3162855665213654276L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.CONDITION, Clause.CONDITION_COMPARISON};
    private final Field<?> search;
    private final Field<String> pattern;

    RegexpLike(Field<?> search, Field<String> pattern) {
        this.search = search;
        this.pattern = pattern;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case CUBRID: 
            case H2: 
            case MARIADB: 
            case MYSQL: 
            case SQLITE: {
                ctx.visit(this.search).sql(' ').visit(Keywords.K_REGEXP).sql(' ').visit(this.pattern);
                break;
            }
            case HSQLDB: {
                ctx.visit(DSL.keyword("regexp_matches")).sql('(').visit(this.search).sql(", ").visit(this.pattern).sql(')');
                break;
            }
            case POSTGRES: {
                ctx.sql('(').visit(this.search).sql(" ~ ").visit(this.pattern).sql(')');
                break;
            }
            default: {
                ctx.sql('(').visit(this.search).sql(' ').visit(Keywords.K_LIKE_REGEX).sql(' ').visit(this.pattern).sql(')');
            }
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

