/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.CaseConditionStep;
import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.QueryPart;
import com.craftaro.third_party.org.jooq.impl.AbstractAggregateFunction;
import com.craftaro.third_party.org.jooq.impl.CustomField;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.Internal;
import com.craftaro.third_party.org.jooq.impl.Names;
import com.craftaro.third_party.org.jooq.impl.SQLDataType;
import java.math.BigDecimal;

final class Product
extends AbstractAggregateFunction<BigDecimal> {
    private static final long serialVersionUID = 1027749554935573353L;

    Product(boolean distinct, Field<?> ... arguments) {
        super(distinct, Names.N_PRODUCT, SQLDataType.NUMERIC, arguments);
    }

    @Override
    public final void accept(Context<?> ctx) {
        final Field<Integer> f = DSL.field("{0}", ((Field)this.arguments.get(0)).getDataType(), new QueryPart[]{this.arguments.get(0)});
        final CaseConditionStep<Integer> negatives = DSL.when(f.lt(DSL.zero()), DSL.inline(-1));
        CustomField<BigDecimal> negativesSum = new CustomField<BigDecimal>("sum", SQLDataType.NUMERIC){

            @Override
            public void accept(Context<?> c2) {
                c2.visit(Product.this.distinct ? DSL.sumDistinct(negatives) : DSL.sum(negatives));
                Product.this.acceptFilterClause(c2);
                Product.this.acceptOverClause(c2);
            }
        };
        CustomField<BigDecimal> zerosSum = new CustomField<BigDecimal>("sum", SQLDataType.NUMERIC){

            @Override
            public void accept(Context<?> c2) {
                c2.visit(DSL.sum(DSL.choose(f).when((Field<Integer>)DSL.zero(), DSL.one())));
                Product.this.acceptFilterClause(c2);
                Product.this.acceptOverClause(c2);
            }
        };
        CustomField<BigDecimal> logarithmsSum = new CustomField<BigDecimal>("sum", SQLDataType.NUMERIC){

            @Override
            public void accept(Context<?> c2) {
                Field<Integer> abs = DSL.abs(DSL.nullif(f, DSL.zero()));
                Field<BigDecimal> ln = DSL.ln(abs);
                c2.visit(Product.this.distinct ? DSL.sumDistinct(ln) : DSL.sum(ln));
                Product.this.acceptFilterClause(c2);
                Product.this.acceptOverClause(c2);
            }
        };
        ctx.visit(Internal.imul(DSL.when(zerosSum.gt(DSL.inline(BigDecimal.ZERO)), DSL.zero()).when(negativesSum.mod(DSL.inline(2)).lt(DSL.inline(BigDecimal.ZERO)), DSL.inline(-1)).otherwise(DSL.one()), DSL.exp((Field<? extends Number>)logarithmsSum)));
    }
}

