/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.impl.AbstractField;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.Internal;
import com.craftaro.third_party.org.jooq.impl.Keywords;
import com.craftaro.third_party.org.jooq.impl.Names;
import java.util.Set;

final class Overlay
extends AbstractField<String> {
    private static final long serialVersionUID = 3544690069533526544L;
    private static final Set<SQLDialect> NO_SUPPORT = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE);
    private static final Set<SQLDialect> SUPPORT_INSERT = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    private final Field<String> in;
    private final Field<String> placing;
    private final Field<? extends Number> startIndex;
    private final Field<? extends Number> length;

    Overlay(Field<String> in, Field<String> placing, Field<? extends Number> startIndex) {
        this(in, placing, startIndex, null);
    }

    Overlay(Field<String> in, Field<String> placing, Field<? extends Number> startIndex, Field<? extends Number> length) {
        super(Names.N_OVERLAY, in.getDataType());
        this.in = in;
        this.placing = placing;
        this.startIndex = startIndex;
        this.length = length;
    }

    @Override
    public final void accept(Context<?> ctx) {
        Field<? extends Number> l = this.length;
        if (l != null) {
            if (SUPPORT_INSERT.contains((Object)ctx.dialect())) {
                ctx.visit(Names.N_INSERT).sql('(').visit(this.in).sql(", ").visit(this.startIndex).sql(", ").visit(l).sql(", ").visit(this.placing).sql(')');
            } else if (NO_SUPPORT.contains((Object)ctx.dialect())) {
                ctx.visit(DSL.substring(this.in, DSL.inline(1), Internal.isub(this.startIndex, DSL.inline(1))).concat(this.placing).concat(DSL.substring(this.in, Internal.iadd(this.startIndex, l))));
            } else {
                ctx.visit(Names.N_OVERLAY).sql('(').visit(this.in).sql(' ').visit(Keywords.K_PLACING).sql(' ').visit(this.placing).sql(' ').visit(Keywords.K_FROM).sql(' ').visit(this.startIndex).sql(' ').visit(Keywords.K_FOR).sql(' ').visit(l).sql(')');
            }
        } else if (SUPPORT_INSERT.contains((Object)ctx.dialect())) {
            ctx.visit(Names.N_INSERT).sql('(').visit(this.in).sql(", ").visit(this.startIndex).sql(", ").visit(DSL.length(this.placing)).sql(", ").visit(this.placing).sql(')');
        } else if (NO_SUPPORT.contains((Object)ctx.dialect())) {
            ctx.visit(DSL.substring(this.in, DSL.inline(1), Internal.isub(this.startIndex, DSL.inline(1))).concat(this.placing).concat(DSL.substring(this.in, Internal.iadd(this.startIndex, DSL.length(this.placing)))));
        } else {
            ctx.visit(Names.N_OVERLAY).sql('(').visit(this.in).sql(' ').visit(Keywords.K_PLACING).sql(' ').visit(this.placing).sql(' ').visit(Keywords.K_FROM).sql(' ').visit(this.startIndex).sql(')');
        }
    }
}

