/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.QueryPart;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.impl.DefaultAggregateFunction;
import com.craftaro.third_party.org.jooq.impl.Keywords;
import com.craftaro.third_party.org.jooq.impl.Names;
import com.craftaro.third_party.org.jooq.impl.QueryPartListView;
import com.craftaro.third_party.org.jooq.impl.SQLDataType;
import com.craftaro.third_party.org.jooq.impl.Tools;
import java.util.Set;

final class ListAgg
extends DefaultAggregateFunction<String> {
    private static final long serialVersionUID = -1760389929938136896L;
    private static final Set<SQLDialect> SUPPORT_GROUP_CONCAT = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE);
    private static final Set<SQLDialect> SUPPORT_STRING_AGG = SQLDialect.supportedBy(SQLDialect.POSTGRES);

    ListAgg(boolean distinct, Field<?> arg) {
        super(distinct, Names.N_LISTAGG, SQLDataType.VARCHAR, arg);
    }

    ListAgg(boolean distinct, Field<?> arg, Field<String> separator) {
        super(distinct, Names.N_LISTAGG, SQLDataType.VARCHAR, arg, separator);
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (SUPPORT_GROUP_CONCAT.contains((Object)ctx.dialect())) {
            this.acceptGroupConcat(ctx);
        } else if (SUPPORT_STRING_AGG.contains((Object)ctx.dialect())) {
            this.acceptStringAgg(ctx);
            this.acceptFilterClause(ctx);
            this.acceptOverClause(ctx);
        } else {
            super.accept(ctx);
        }
    }

    private final void acceptGroupConcat(Context<?> ctx) {
        ctx.visit(Names.N_GROUP_CONCAT).sql('(');
        this.acceptArguments1(ctx, new QueryPartListView((QueryPart[])new Field[]{(Field)this.arguments.get(0)}));
        this.acceptOrderBy(ctx);
        if (this.arguments.size() > 1) {
            if (ctx.family() == SQLDialect.SQLITE) {
                ctx.sql(", ").visit((QueryPart)this.arguments.get(1));
            } else {
                ctx.sql(' ').visit(Keywords.K_SEPARATOR).sql(' ').visit((QueryPart)this.arguments.get(1));
            }
        }
        ctx.sql(')');
    }

    private final void acceptStringAgg(Context<?> ctx) {
        switch (ctx.family()) {
            default: 
        }
        ctx.visit(Names.N_STRING_AGG);
        ctx.sql('(');
        if (this.distinct) {
            ctx.visit(Keywords.K_DISTINCT).sql(' ');
        }
        ctx.visit(Tools.castIfNeeded((Field)this.arguments.get(0), String.class));
        if (this.arguments.size() > 1) {
            ctx.sql(", ").visit((QueryPart)this.arguments.get(1));
        } else {
            ctx.sql(", ''");
        }
        this.acceptOrderBy(ctx);
        ctx.sql(')');
    }
}

