/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.DataType;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.JSONValueDefaultStep;
import com.craftaro.third_party.org.jooq.JSONValueOnStep;
import com.craftaro.third_party.org.jooq.Keyword;
import com.craftaro.third_party.org.jooq.impl.AbstractField;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.Names;
import com.craftaro.third_party.org.jooq.impl.SQLDataType;
import com.craftaro.third_party.org.jooq.impl.Tools;

final class JSONValue<J>
extends AbstractField<J>
implements JSONValueOnStep<J>,
JSONValueDefaultStep<J> {
    private static final long serialVersionUID = 1772007627336725780L;
    private final Field<?> json;
    private final Field<String> path;

    JSONValue(DataType<J> type, Field<?> json, Field<String> path) {
        this(type, json, path, null, null, null, null, null);
    }

    private JSONValue(DataType<J> type, Field<?> json, Field<String> path, Behaviour onError, Field<?> onErrorDefault, Behaviour onEmpty, Field<?> onEmptyDefault, Field<?> default_) {
        super(Names.N_JSON_VALUE, type);
        this.json = json;
        this.path = path;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case MYSQL: {
                ctx.visit(Names.N_JSON_EXTRACT).sql('(').visit(this.json).sql(", ").visit(this.path).sql(')');
                break;
            }
            case POSTGRES: {
                ctx.visit(Names.N_JSONB_PATH_QUERY_FIRST).sql('(').visit(Tools.castIfNeeded(this.json, SQLDataType.JSONB)).sql(", ").visit(this.path).sql("::jsonpath)");
                break;
            }
            default: {
                ctx.visit(Names.N_JSON_VALUE).sql('(').visit(this.json).sql(", ");
                ctx.visit(this.path);
                ctx.sql(')');
            }
        }
    }

    static enum Behaviour {
        ERROR,
        NULL,
        DEFAULT;

        final Keyword keyword = DSL.keyword(this.name().toLowerCase());
    }
}

