/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.DataType;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.JSON;
import com.craftaro.third_party.org.jooq.JSONEntry;
import com.craftaro.third_party.org.jooq.JSONObjectAggNullStep;
import com.craftaro.third_party.org.jooq.JSONObjectNullStep;
import com.craftaro.third_party.org.jooq.QueryPart;
import com.craftaro.third_party.org.jooq.impl.AbstractAggregateFunction;
import com.craftaro.third_party.org.jooq.impl.CustomQueryPart;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.JSONNull;
import com.craftaro.third_party.org.jooq.impl.Names;
import com.craftaro.third_party.org.jooq.impl.QueryPartListView;
import com.craftaro.third_party.org.jooq.impl.RegexpReplace;
import com.craftaro.third_party.org.jooq.impl.SQLDataType;

final class JSONObjectAgg<J>
extends AbstractAggregateFunction<J>
implements JSONObjectAggNullStep<J> {
    private static final long serialVersionUID = 1772007627336725780L;
    private final JSONEntry<?> entry;
    private JSONNull.JSONNullType nullType;

    JSONObjectAgg(DataType<J> type, JSONEntry<?> entry) {
        super(false, Names.N_JSON_OBJECTAGG, type, entry.key(), entry.value());
        this.entry = entry;
    }

    @Override
    public void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case POSTGRES: {
                this.acceptPostgres(ctx);
                break;
            }
            case MARIADB: 
            case MYSQL: {
                if (this.nullType == JSONNull.JSONNullType.ABSENT_ON_NULL || this.filter != null) {
                    this.acceptGroupConcat(ctx);
                    break;
                }
                this.acceptStandard(ctx);
                break;
            }
            default: {
                this.acceptStandard(ctx);
            }
        }
    }

    private final void acceptPostgres(Context<?> ctx) {
        ctx.visit(this.getDataType() == SQLDataType.JSON ? Names.N_JSON_OBJECT_AGG : Names.N_JSONB_OBJECT_AGG).sql('(');
        ctx.visit(this.entry);
        ctx.sql(')');
        if (this.nullType == JSONNull.JSONNullType.ABSENT_ON_NULL) {
            JSONObjectAgg.acceptFilterClause(ctx, (this.filter == null ? DSL.noCondition() : this.filter).and(this.entry.value().isNotNull()));
        } else {
            this.acceptFilterClause(ctx);
        }
        this.acceptOverClause(ctx);
    }

    private final void acceptGroupConcat(final Context<?> ctx) {
        Field<String> listagg = DSL.field("{0}", SQLDataType.VARCHAR, new QueryPart[]{new CustomQueryPart(){

            @Override
            public void accept(Context<?> c1) {
                Field<JSON> o1 = DSL.jsonObject(JSONObjectAgg.this.entry.key(), JSONObjectAgg.this.entry.value());
                if (JSONObjectAgg.this.nullType == JSONNull.JSONNullType.ABSENT_ON_NULL) {
                    o1 = DSL.when(JSONObjectAgg.this.entry.value().isNull(), DSL.inline((JSON)null)).else_(o1);
                }
                final JSONObjectNullStep<JSON> o2 = o1;
                c1.visit(DSL.groupConcat(DSL.concat(DSL.field("{0}", SQLDataType.VARCHAR, new QueryPart[]{new CustomQueryPart(){

                    @Override
                    public void accept(Context<?> c2) {
                        JSONObjectAgg.this.acceptArguments2(c2, QueryPartListView.wrap((QueryPart[])new Field[]{DSL.regexpReplaceAll(o2.cast(SQLDataType.VARCHAR), DSL.inline("^\\{(.*)\\}$"), DSL.inline(RegexpReplace.replacement(ctx, 1)))}));
                    }
                }}))));
                JSONObjectAgg.this.acceptFilterClause(c1);
                JSONObjectAgg.this.acceptOverClause(c1);
            }
        }});
        ctx.sql('(').visit(DSL.concat(DSL.inline('{'), listagg, DSL.inline('}'))).sql(')');
    }

    private final void acceptStandard(Context<?> ctx) {
        ctx.visit(Names.N_JSON_OBJECTAGG).sql('(').visit(this.entry);
        JSONNull jsonNull = new JSONNull(this.nullType);
        if (jsonNull.rendersContent(ctx)) {
            ctx.sql(' ').visit(jsonNull);
        }
        ctx.sql(')');
        this.acceptFilterClause(ctx);
        this.acceptOverClause(ctx);
    }

    @Override
    public final JSONObjectAgg<J> nullOnNull() {
        this.nullType = JSONNull.JSONNullType.NULL_ON_NULL;
        return this;
    }

    @Override
    public final JSONObjectAgg<J> absentOnNull() {
        this.nullType = JSONNull.JSONNullType.ABSENT_ON_NULL;
        return this;
    }
}

