/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Comparator;
import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.QueryPartInternal;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.impl.AbstractCondition;
import com.craftaro.third_party.org.jooq.impl.CompareCondition;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.Tools;
import java.util.Set;

final class IsDistinctFrom<T>
extends AbstractCondition {
    private static final long serialVersionUID = 4568269684824736461L;
    private static final Set<SQLDialect> EMULATE_DISTINCT_PREDICATE = SQLDialect.supportedUntil(SQLDialect.CUBRID, SQLDialect.DERBY);
    private static final Set<SQLDialect> SUPPORT_DISTINCT_WITH_ARROW = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    private final Field<T> lhs;
    private final Field<T> rhs;
    private final Comparator comparator;

    IsDistinctFrom(Field<T> lhs, Field<T> rhs, Comparator comparator) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.comparator = comparator;
    }

    @Override
    final boolean isNullable() {
        return false;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.lhs.getDataType().isEmbeddable() && this.rhs.getDataType().isEmbeddable()) {
            ctx.visit(DSL.row(Tools.embeddedFields(this.lhs)).compare(this.comparator, DSL.row(Tools.embeddedFields(this.rhs))));
        } else if (EMULATE_DISTINCT_PREDICATE.contains((Object)ctx.dialect())) {
            ctx.visit(this.comparator == Comparator.IS_DISTINCT_FROM ? (QueryPartInternal)((Object)DSL.notExists(DSL.select(this.lhs.as("x")).intersect(DSL.select(this.rhs.as("x"))))) : (QueryPartInternal)((Object)DSL.exists(DSL.select(this.lhs.as("x")).intersect(DSL.select(this.rhs.as("x"))))));
        } else if (SUPPORT_DISTINCT_WITH_ARROW.contains((Object)ctx.dialect())) {
            ctx.visit(this.comparator == Comparator.IS_DISTINCT_FROM ? DSL.condition("{not}({0} <=> {1})", this.lhs, this.rhs) : DSL.condition("{0} <=> {1}", this.lhs, this.rhs));
        } else if (SQLDialect.SQLITE == ctx.family()) {
            ctx.visit(this.comparator == Comparator.IS_DISTINCT_FROM ? DSL.condition("{0} {is not} {1}", this.lhs, this.rhs) : DSL.condition("{0} {is} {1}", this.lhs, this.rhs));
        } else {
            ctx.visit(new CompareCondition(this.lhs, this.rhs, this.comparator));
        }
    }
}

