/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Catalog;
import com.craftaro.third_party.org.jooq.Check;
import com.craftaro.third_party.org.jooq.Configuration;
import com.craftaro.third_party.org.jooq.DataType;
import com.craftaro.third_party.org.jooq.Domain;
import com.craftaro.third_party.org.jooq.ForeignKey;
import com.craftaro.third_party.org.jooq.Index;
import com.craftaro.third_party.org.jooq.Name;
import com.craftaro.third_party.org.jooq.OrderField;
import com.craftaro.third_party.org.jooq.Record;
import com.craftaro.third_party.org.jooq.Schema;
import com.craftaro.third_party.org.jooq.Sequence;
import com.craftaro.third_party.org.jooq.Table;
import com.craftaro.third_party.org.jooq.TableField;
import com.craftaro.third_party.org.jooq.TableOptions;
import com.craftaro.third_party.org.jooq.UniqueKey;
import com.craftaro.third_party.org.jooq.exception.SQLDialectNotSupportedException;
import com.craftaro.third_party.org.jooq.impl.AbstractMeta;
import com.craftaro.third_party.org.jooq.impl.AbstractTable;
import com.craftaro.third_party.org.jooq.impl.CatalogImpl;
import com.craftaro.third_party.org.jooq.impl.CheckImpl;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.DefaultDataType;
import com.craftaro.third_party.org.jooq.impl.DomainImpl;
import com.craftaro.third_party.org.jooq.impl.IndexImpl;
import com.craftaro.third_party.org.jooq.impl.Internal;
import com.craftaro.third_party.org.jooq.impl.SQLDataType;
import com.craftaro.third_party.org.jooq.impl.SchemaImpl;
import com.craftaro.third_party.org.jooq.impl.SequenceImpl;
import com.craftaro.third_party.org.jooq.impl.TableImpl;
import com.craftaro.third_party.org.jooq.impl.Tools;
import com.craftaro.third_party.org.jooq.impl.UniqueKeyImpl;
import com.craftaro.third_party.org.jooq.tools.StringUtils;
import com.craftaro.third_party.org.jooq.util.xml.jaxb.CheckConstraint;
import com.craftaro.third_party.org.jooq.util.xml.jaxb.Column;
import com.craftaro.third_party.org.jooq.util.xml.jaxb.DomainConstraint;
import com.craftaro.third_party.org.jooq.util.xml.jaxb.IndexColumnUsage;
import com.craftaro.third_party.org.jooq.util.xml.jaxb.InformationSchema;
import com.craftaro.third_party.org.jooq.util.xml.jaxb.KeyColumnUsage;
import com.craftaro.third_party.org.jooq.util.xml.jaxb.ReferentialConstraint;
import com.craftaro.third_party.org.jooq.util.xml.jaxb.TableConstraint;
import com.craftaro.third_party.org.jooq.util.xml.jaxb.TableConstraintType;
import com.craftaro.third_party.org.jooq.util.xml.jaxb.View;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class InformationSchemaMetaImpl
extends AbstractMeta {
    private static final long serialVersionUID = -1623783405104005307L;
    private final InformationSchema source;
    private final List<Catalog> catalogs;
    private final Map<Name, Catalog> catalogsByName;
    private final List<Schema> schemas;
    private final Map<Name, Schema> schemasByName;
    private final Map<Catalog, List<Schema>> schemasPerCatalog;
    private final List<InformationSchemaTable> tables;
    private final Map<Name, InformationSchemaTable> tablesByName;
    private final Map<Schema, List<InformationSchemaTable>> tablesPerSchema;
    private final List<InformationSchemaDomain<?>> domains;
    private final Map<Name, InformationSchemaDomain<?>> domainsByName;
    private final Map<Schema, List<InformationSchemaDomain<?>>> domainsPerSchema;
    private final List<Sequence<?>> sequences;
    private final Map<Schema, List<Sequence<?>>> sequencesPerSchema;
    private final List<UniqueKeyImpl<Record>> primaryKeys;
    private final Map<Name, UniqueKeyImpl<Record>> uniqueKeysByName;
    private final Map<Name, Name> referentialKeys;
    private final Map<Name, IndexImpl> indexesByName;

    InformationSchemaMetaImpl(Configuration configuration, InformationSchema source) {
        super(configuration);
        this.source = source;
        this.catalogs = new ArrayList<Catalog>();
        this.catalogsByName = new HashMap<Name, Catalog>();
        this.schemas = new ArrayList<Schema>();
        this.schemasByName = new HashMap<Name, Schema>();
        this.schemasPerCatalog = new HashMap<Catalog, List<Schema>>();
        this.tables = new ArrayList<InformationSchemaTable>();
        this.tablesByName = new HashMap<Name, InformationSchemaTable>();
        this.tablesPerSchema = new HashMap<Schema, List<InformationSchemaTable>>();
        this.domains = new ArrayList();
        this.domainsByName = new HashMap();
        this.domainsPerSchema = new HashMap();
        this.sequences = new ArrayList();
        this.sequencesPerSchema = new HashMap();
        this.primaryKeys = new ArrayList<UniqueKeyImpl<Record>>();
        this.uniqueKeysByName = new HashMap<Name, UniqueKeyImpl<Record>>();
        this.referentialKeys = new HashMap<Name, Name>();
        this.indexesByName = new HashMap<Name, IndexImpl>();
        this.init(source);
    }

    /*
     * WARNING - void declaration
     */
    private final void init(InformationSchema meta) {
        InformationSchemaTable table;
        Schema schema;
        Name schemaName;
        InformationSchemaCatalog ic;
        ArrayList<String> errors = new ArrayList<String>();
        boolean hasCatalogs = false;
        for (com.craftaro.third_party.org.jooq.util.xml.jaxb.Catalog catalog : meta.getCatalogs()) {
            ic = new InformationSchemaCatalog(catalog.getCatalogName(), catalog.getComment());
            this.catalogs.add(ic);
            this.catalogsByName.put(DSL.name(catalog.getCatalogName()), ic);
            hasCatalogs = true;
        }
        for (com.craftaro.third_party.org.jooq.util.xml.jaxb.Schema schema2 : meta.getSchemata()) {
            Name catalogName;
            Catalog catalog;
            if (!hasCatalogs && !this.catalogs.contains(ic = new InformationSchemaCatalog(schema2.getCatalogName(), null))) {
                this.catalogs.add(ic);
                this.catalogsByName.put(DSL.name(schema2.getCatalogName()), ic);
            }
            if ((catalog = this.catalogsByName.get(catalogName = DSL.name(schema2.getCatalogName()))) == null) {
                errors.add(String.format("Catalog " + catalogName + " not defined for schema " + schema2.getSchemaName(), new Object[0]));
                continue;
            }
            InformationSchemaSchema is = new InformationSchemaSchema(schema2.getSchemaName(), catalog, schema2.getComment());
            this.schemas.add(is);
            this.schemasByName.put(DSL.name(schema2.getCatalogName(), schema2.getSchemaName()), is);
        }
        for (com.craftaro.third_party.org.jooq.util.xml.jaxb.Domain domain : meta.getDomains()) {
            schemaName = DSL.name(domain.getDomainCatalog(), domain.getDomainSchema());
            schema = this.schemasByName.get(schemaName);
            if (schema == null) {
                errors.add(String.format("Schema " + schemaName + " not defined for domain " + domain.getDomainName(), new Object[0]));
                continue;
            }
            Name domainName = DSL.name(domain.getDomainCatalog(), domain.getDomainSchema(), domain.getDomainName());
            int length = domain.getCharacterMaximumLength() == null ? 0 : domain.getCharacterMaximumLength();
            int n = domain.getNumericPrecision() == null ? 0 : domain.getNumericPrecision();
            int scale = domain.getNumericScale() == null ? 0 : domain.getNumericScale();
            boolean nullable = true;
            ArrayList checks = new ArrayList();
            for (DomainConstraint dc : meta.getDomainConstraints()) {
                if (!domainName.equals(DSL.name(dc.getDomainCatalog(), dc.getDomainSchema(), dc.getDomainName()))) continue;
                Name constraintName = DSL.name(dc.getConstraintCatalog(), dc.getConstraintSchema(), dc.getConstraintName());
                for (CheckConstraint cc : meta.getCheckConstraints()) {
                    if (!constraintName.equals(DSL.name(cc.getConstraintCatalog(), cc.getConstraintSchema(), cc.getConstraintName()))) continue;
                    checks.add(new CheckImpl(null, constraintName, DSL.condition(cc.getCheckClause()), true));
                }
            }
            InformationSchemaDomain id = new InformationSchemaDomain(schema, DSL.name(domain.getDomainName()), this.type(domain.getDataType(), length, n, scale, nullable), checks.toArray(Tools.EMPTY_CHECK));
            this.domains.add(id);
            this.domainsByName.put(domainName, id);
        }
        for (com.craftaro.third_party.org.jooq.util.xml.jaxb.Table table2 : meta.getTables()) {
            TableOptions.TableType tableType;
            schemaName = DSL.name(table2.getTableCatalog(), table2.getTableSchema());
            schema = this.schemasByName.get(schemaName);
            if (schema == null) {
                errors.add(String.format("Schema " + schemaName + " not defined for table " + table2.getTableName(), new Object[0]));
                continue;
            }
            switch (table2.getTableType()) {
                case GLOBAL_TEMPORARY: {
                    tableType = TableOptions.TableType.TEMPORARY;
                    break;
                }
                case VIEW: {
                    tableType = TableOptions.TableType.VIEW;
                    break;
                }
                default: {
                    tableType = TableOptions.TableType.TABLE;
                }
            }
            String sql = null;
            if (tableType == TableOptions.TableType.VIEW) {
                for (View vt : meta.getViews()) {
                    if (!StringUtils.equals(StringUtils.defaultIfNull(table2.getTableCatalog(), ""), StringUtils.defaultIfNull(vt.getTableCatalog(), "")) || !StringUtils.equals(StringUtils.defaultIfNull(table2.getTableSchema(), ""), StringUtils.defaultIfNull(vt.getTableSchema(), "")) || !StringUtils.equals(StringUtils.defaultIfNull(table2.getTableName(), ""), StringUtils.defaultIfNull(vt.getTableName(), ""))) continue;
                    sql = vt.getViewDefinition();
                    break;
                }
            }
            InformationSchemaTable informationSchemaTable = new InformationSchemaTable(table2.getTableName(), schema, table2.getComment(), tableType, sql);
            this.tables.add(informationSchemaTable);
            this.tablesByName.put(DSL.name(table2.getTableCatalog(), table2.getTableSchema(), table2.getTableName()), informationSchemaTable);
        }
        ArrayList<Column> columns = new ArrayList<Column>(meta.getColumns());
        Collections.sort(columns, new Comparator<Column>(){

            @Override
            public int compare(Column o1, Column o2) {
                Integer p2;
                Integer p1 = o1.getOrdinalPosition();
                if (p1 == (p2 = o2.getOrdinalPosition())) {
                    return 0;
                }
                if (p1 == null) {
                    return -1;
                }
                if (p2 == null) {
                    return 1;
                }
                return p1.compareTo(p2);
            }
        });
        for (Column xc : columns) {
            Iterator<com.craftaro.third_party.org.jooq.util.xml.jaxb.Index> typeName = xc.getDataType();
            int length = xc.getCharacterMaximumLength() == null ? 0 : xc.getCharacterMaximumLength();
            int precision = xc.getNumericPrecision() == null ? 0 : xc.getNumericPrecision();
            int n = xc.getNumericScale() == null ? 0 : xc.getNumericScale();
            boolean nullable = xc.isIsNullable() == null ? true : xc.isIsNullable();
            Name tableName = DSL.name(xc.getTableCatalog(), xc.getTableSchema(), xc.getTableName());
            table = this.tablesByName.get(tableName);
            if (table == null) {
                errors.add(String.format("Table " + tableName + " not defined for column " + xc.getColumnName(), new Object[0]));
                continue;
            }
            AbstractTable.createField(DSL.name(xc.getColumnName()), this.type((String)((Object)typeName), length, precision, n, nullable), table, xc.getComment());
        }
        HashMap hashMap = new HashMap();
        ArrayList<IndexColumnUsage> indexColumnUsages = new ArrayList<IndexColumnUsage>(meta.getIndexColumnUsages());
        Collections.sort(indexColumnUsages, new Comparator<IndexColumnUsage>(){

            @Override
            public int compare(IndexColumnUsage o1, IndexColumnUsage o2) {
                int p2;
                int p1 = o1.getOrdinalPosition();
                return p1 < (p2 = o2.getOrdinalPosition()) ? -1 : (p1 == p2 ? 0 : 1);
            }
        });
        for (IndexColumnUsage ic2 : indexColumnUsages) {
            void var10_33;
            Name tableName;
            InformationSchemaTable table2;
            Name indexName = DSL.name(ic2.getIndexCatalog(), ic2.getIndexSchema(), ic2.getTableName(), ic2.getIndexName());
            List list = (List)hashMap.get(indexName);
            if (list == null) {
                ArrayList arrayList = new ArrayList();
                hashMap.put(indexName, arrayList);
            }
            if ((table2 = this.tablesByName.get(tableName = DSL.name(ic2.getTableCatalog(), ic2.getTableSchema(), ic2.getTableName()))) == null) {
                errors.add(String.format("Table " + tableName + " not defined for index " + indexName, new Object[0]));
                continue;
            }
            TableField field = (TableField)table2.field(ic2.getColumnName());
            if (field == null) {
                errors.add(String.format("Column " + ic2.getColumnName() + " not defined for table " + tableName, new Object[0]));
                continue;
            }
            var10_33.add(Boolean.TRUE.equals(ic2.isIsDescending()) ? field.desc() : field.asc());
        }
        for (com.craftaro.third_party.org.jooq.util.xml.jaxb.Index i : meta.getIndexes()) {
            Name tableName = DSL.name(i.getTableCatalog(), i.getTableSchema(), i.getTableName());
            Name name = DSL.name(i.getIndexCatalog(), i.getIndexSchema(), i.getTableName(), i.getIndexName());
            InformationSchemaTable table3 = this.tablesByName.get(tableName);
            if (table3 == null) {
                errors.add(String.format("Table " + tableName + " not defined for index " + name, new Object[0]));
                continue;
            }
            List c3 = (List)hashMap.get(name);
            if (c3 == null || c3.isEmpty()) {
                errors.add(String.format("No columns defined for index " + name, new Object[0]));
                continue;
            }
            IndexImpl index = (IndexImpl)Internal.createIndex(i.getIndexName(), table3, (OrderField[])c3.toArray(Tools.EMPTY_SORTFIELD), Boolean.TRUE.equals(i.isIsUnique()));
            table3.indexes.add(index);
            this.indexesByName.put(name, index);
        }
        HashMap columnsByConstraint = new HashMap();
        ArrayList<KeyColumnUsage> keyColumnUsages = new ArrayList<KeyColumnUsage>(meta.getKeyColumnUsages());
        Collections.sort(keyColumnUsages, new Comparator<KeyColumnUsage>(){

            @Override
            public int compare(KeyColumnUsage o1, KeyColumnUsage o2) {
                int p2;
                int p1 = o1.getOrdinalPosition();
                return p1 < (p2 = o2.getOrdinalPosition()) ? -1 : (p1 == p2 ? 0 : 1);
            }
        });
        for (KeyColumnUsage keyColumnUsage : keyColumnUsages) {
            Name tableName;
            InformationSchemaTable table4;
            Name constraintName = DSL.name(keyColumnUsage.getConstraintCatalog(), keyColumnUsage.getConstraintSchema(), keyColumnUsage.getConstraintName());
            ArrayList<TableField> fields = (ArrayList<TableField>)columnsByConstraint.get(constraintName);
            if (fields == null) {
                fields = new ArrayList<TableField>();
                columnsByConstraint.put(constraintName, fields);
            }
            if ((table4 = this.tablesByName.get(tableName = DSL.name(keyColumnUsage.getTableCatalog(), keyColumnUsage.getTableSchema(), keyColumnUsage.getTableName()))) == null) {
                errors.add(String.format("Table " + tableName + " not defined for constraint " + constraintName, new Object[0]));
                continue;
            }
            TableField field = (TableField)table4.field(keyColumnUsage.getColumnName());
            if (field == null) {
                errors.add(String.format("Column " + keyColumnUsage.getColumnName() + " not defined for table " + tableName, new Object[0]));
                continue;
            }
            fields.add(field);
        }
        for (TableConstraint tableConstraint : meta.getTableConstraints()) {
            switch (tableConstraint.getConstraintType()) {
                case PRIMARY_KEY: 
                case UNIQUE: {
                    Name tableName = DSL.name(tableConstraint.getTableCatalog(), tableConstraint.getTableSchema(), tableConstraint.getTableName());
                    Name constraintName = DSL.name(tableConstraint.getConstraintCatalog(), tableConstraint.getConstraintSchema(), tableConstraint.getConstraintName());
                    table = this.tablesByName.get(tableName);
                    if (table == null) {
                        errors.add(String.format("Table " + tableName + " not defined for constraint " + constraintName, new Object[0]));
                        break;
                    }
                    List c2 = (List)columnsByConstraint.get(constraintName);
                    if (c2 == null || c2.isEmpty()) {
                        errors.add(String.format("No columns defined for constraint " + constraintName, new Object[0]));
                        break;
                    }
                    UniqueKeyImpl key = (UniqueKeyImpl)Internal.createUniqueKey(table, tableConstraint.getConstraintName(), c2.toArray(new TableField[0]));
                    if (tableConstraint.getConstraintType() == TableConstraintType.PRIMARY_KEY) {
                        table.primaryKey = key;
                        this.primaryKeys.add(key);
                    }
                    table.uniqueKeys.add(key);
                    this.uniqueKeysByName.put(constraintName, key);
                    break;
                }
            }
        }
        for (ReferentialConstraint referentialConstraint : meta.getReferentialConstraints()) {
            this.referentialKeys.put(DSL.name(referentialConstraint.getConstraintCatalog(), referentialConstraint.getConstraintSchema(), referentialConstraint.getConstraintName()), DSL.name(referentialConstraint.getUniqueConstraintCatalog(), referentialConstraint.getUniqueConstraintSchema(), referentialConstraint.getUniqueConstraintName()));
        }
        for (TableConstraint tableConstraint : meta.getTableConstraints()) {
            switch (tableConstraint.getConstraintType()) {
                case FOREIGN_KEY: {
                    Name tableName = DSL.name(tableConstraint.getTableCatalog(), tableConstraint.getTableSchema(), tableConstraint.getTableName());
                    Name constraintName = DSL.name(tableConstraint.getConstraintCatalog(), tableConstraint.getConstraintSchema(), tableConstraint.getConstraintName());
                    table = this.tablesByName.get(tableName);
                    if (table == null) {
                        errors.add(String.format("Table " + tableName + " not defined for constraint " + constraintName, new Object[0]));
                        break;
                    }
                    List c2 = (List)columnsByConstraint.get(constraintName);
                    if (c2 == null || c2.isEmpty()) {
                        errors.add(String.format("No columns defined for constraint " + constraintName, new Object[0]));
                        break;
                    }
                    UniqueKeyImpl<Record> uniqueKey = this.uniqueKeysByName.get(this.referentialKeys.get(constraintName));
                    if (uniqueKey == null) {
                        errors.add(String.format("No unique key defined for foreign key " + constraintName, new Object[0]));
                        break;
                    }
                    ForeignKey<Record, Record> key = Internal.createForeignKey(uniqueKey, table, tableConstraint.getConstraintName(), c2.toArray(new TableField[0]));
                    table.foreignKeys.add(key);
                    break;
                }
            }
        }
        block27: for (TableConstraint tableConstraint : meta.getTableConstraints()) {
            switch (tableConstraint.getConstraintType()) {
                case CHECK: {
                    Name tableName = DSL.name(tableConstraint.getTableCatalog(), tableConstraint.getTableSchema(), tableConstraint.getTableName());
                    Name constraintName = DSL.name(tableConstraint.getConstraintCatalog(), tableConstraint.getConstraintSchema(), tableConstraint.getConstraintName());
                    table = this.tablesByName.get(tableName);
                    if (table == null) {
                        errors.add(String.format("Table " + tableName + " not defined for constraint " + constraintName, new Object[0]));
                        continue block27;
                    }
                    for (CheckConstraint cc : meta.getCheckConstraints()) {
                        if (!constraintName.equals(DSL.name(cc.getConstraintCatalog(), cc.getConstraintSchema(), cc.getConstraintName()))) continue;
                        table.checks.add(new CheckImpl<Record>(table, constraintName, DSL.condition(cc.getCheckClause()), true));
                        continue block27;
                    }
                    errors.add(String.format("No check clause found for check constraint " + constraintName, new Object[0]));
                    continue block27;
                }
            }
        }
        for (com.craftaro.third_party.org.jooq.util.xml.jaxb.Sequence sequence : meta.getSequences()) {
            Name schemaName2 = DSL.name(sequence.getSequenceCatalog(), sequence.getSequenceSchema());
            Schema schema2 = this.schemasByName.get(schemaName2);
            if (schema2 == null) {
                errors.add(String.format("Schema " + schemaName2 + " not defined for sequence " + sequence.getSequenceName(), new Object[0]));
                continue;
            }
            String typeName = sequence.getDataType();
            int length = sequence.getCharacterMaximumLength() == null ? 0 : sequence.getCharacterMaximumLength();
            int precision = sequence.getNumericPrecision() == null ? 0 : sequence.getNumericPrecision();
            int scale = sequence.getNumericScale() == null ? 0 : sequence.getNumericScale();
            boolean nullable = true;
            BigInteger startWith = sequence.getStartValue();
            BigInteger incrementBy = sequence.getIncrement();
            BigInteger minvalue = sequence.getMinimumValue();
            BigInteger maxvalue = sequence.getMaximumValue();
            Boolean cycle = sequence.isCycleOption();
            BigInteger cache = sequence.getCache();
            InformationSchemaSequence is = new InformationSchemaSequence(sequence.getSequenceName(), schema2, this.type(typeName, length, precision, scale, nullable), startWith, incrementBy, minvalue, maxvalue, cycle, cache);
            this.sequences.add(is);
        }
        for (Schema schema3 : this.schemas) {
            this.initLookup(this.schemasPerCatalog, schema3.getCatalog(), schema3);
        }
        for (InformationSchemaDomain informationSchemaDomain : this.domains) {
            this.initLookup(this.domainsPerSchema, informationSchemaDomain.getSchema(), informationSchemaDomain);
        }
        for (InformationSchemaTable informationSchemaTable : this.tables) {
            this.initLookup(this.tablesPerSchema, informationSchemaTable.getSchema(), informationSchemaTable);
        }
        for (Sequence sequence : this.sequences) {
            this.initLookup(this.sequencesPerSchema, sequence.getSchema(), sequence);
        }
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException(((Object)errors).toString());
        }
    }

    private final <K, V> void initLookup(Map<K, List<V>> lookup, K key, V value) {
        List<V> list = lookup.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            lookup.put(key, list);
        }
        list.add(value);
    }

    private final DataType<?> type(String typeName, int length, int precision, int scale, boolean nullable) {
        DataType<Object> type = null;
        try {
            type = DefaultDataType.getDataType(this.configuration.family(), typeName);
            type = type.nullable(nullable);
            if (length != 0) {
                type = type.length(length);
            } else if (precision != 0 || scale != 0) {
                type = type.precision(precision, scale);
            }
        }
        catch (SQLDialectNotSupportedException e) {
            type = SQLDataType.OTHER;
        }
        return type;
    }

    @Override
    final List<Catalog> getCatalogs0() {
        return this.catalogs;
    }

    @Override
    final List<Schema> getSchemas0() {
        return this.schemas;
    }

    @Override
    final List<Table<?>> getTables0() {
        return this.tables;
    }

    @Override
    final List<Domain<?>> getDomains0() {
        return this.domains;
    }

    @Override
    final List<Sequence<?>> getSequences0() {
        return this.sequences;
    }

    @Override
    final List<UniqueKey<?>> getPrimaryKeys0() {
        return this.primaryKeys;
    }

    private static final <T> List<T> unmodifiableList(List<? extends T> list) {
        return list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
    }

    private final class InformationSchemaSequence<N extends Number>
    extends SequenceImpl<N> {
        private static final long serialVersionUID = -1246697252597049756L;

        InformationSchemaSequence(String name, Schema schema, DataType<N> type, Number startWith, Number incrementBy, Number minvalue, Number maxvalue, Boolean cycle, Number cache) {
            super(DSL.name(name), schema, type, false, startWith != null ? Tools.field((Object)startWith, type) : null, incrementBy != null ? Tools.field((Object)incrementBy, type) : null, minvalue != null ? Tools.field((Object)minvalue, type) : null, maxvalue != null ? Tools.field((Object)maxvalue, type) : null, Boolean.TRUE.equals(cycle), cache != null ? Tools.field((Object)cache, type) : null);
        }
    }

    private final class InformationSchemaDomain<T>
    extends DomainImpl<T> {
        private static final long serialVersionUID = -6334830117626566343L;

        InformationSchemaDomain(Schema schema, Name name, DataType<T> type, Check<?>[] checks) {
            super(schema, name, type, checks);
        }
    }

    private final class InformationSchemaTable
    extends TableImpl<Record> {
        private static final long serialVersionUID = 4314110578549768267L;
        UniqueKey<Record> primaryKey;
        final List<UniqueKey<Record>> uniqueKeys;
        final List<ForeignKey<Record, Record>> foreignKeys;
        final List<Check<Record>> checks;
        final List<Index> indexes;

        InformationSchemaTable(String name, Schema schema, String comment, TableOptions.TableType tableType, String source) {
            super(DSL.name(name), schema, null, null, DSL.comment(comment), tableType == TableOptions.TableType.VIEW ? TableOptions.view(source) : TableOptions.of(tableType));
            this.uniqueKeys = new ArrayList<UniqueKey<Record>>();
            this.foreignKeys = new ArrayList<ForeignKey<Record, Record>>();
            this.checks = new ArrayList<Check<Record>>();
            this.indexes = new ArrayList<Index>();
        }

        @Override
        public List<Index> getIndexes() {
            return InformationSchemaMetaImpl.unmodifiableList(this.indexes);
        }

        @Override
        public UniqueKey<Record> getPrimaryKey() {
            return this.primaryKey;
        }

        @Override
        public List<UniqueKey<Record>> getKeys() {
            return InformationSchemaMetaImpl.unmodifiableList(this.uniqueKeys);
        }

        @Override
        public List<ForeignKey<Record, ?>> getReferences() {
            return InformationSchemaMetaImpl.unmodifiableList(this.foreignKeys);
        }

        @Override
        public List<Check<Record>> getChecks() {
            return InformationSchemaMetaImpl.unmodifiableList(this.checks);
        }
    }

    private final class InformationSchemaSchema
    extends SchemaImpl {
        private static final long serialVersionUID = 7290709749127378187L;

        InformationSchemaSchema(String name, Catalog catalog, String comment) {
            super(name, catalog, comment);
        }

        @Override
        public final List<Domain<?>> getDomains() {
            return InformationSchemaMetaImpl.unmodifiableList((List)InformationSchemaMetaImpl.this.domainsPerSchema.get(this));
        }

        @Override
        public final List<Table<?>> getTables() {
            return InformationSchemaMetaImpl.unmodifiableList((List)InformationSchemaMetaImpl.this.tablesPerSchema.get(this));
        }

        @Override
        public final List<Sequence<?>> getSequences() {
            return InformationSchemaMetaImpl.unmodifiableList((List)InformationSchemaMetaImpl.this.sequencesPerSchema.get(this));
        }
    }

    private final class InformationSchemaCatalog
    extends CatalogImpl {
        private static final long serialVersionUID = 87038321849045492L;

        InformationSchemaCatalog(String name, String comment) {
            super(name, comment);
        }

        @Override
        public final List<Schema> getSchemas() {
            return InformationSchemaMetaImpl.unmodifiableList((List)InformationSchemaMetaImpl.this.schemasPerCatalog.get(this));
        }
    }
}

