/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Condition;
import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.Index;
import com.craftaro.third_party.org.jooq.Name;
import com.craftaro.third_party.org.jooq.OrderField;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.SortField;
import com.craftaro.third_party.org.jooq.Table;
import com.craftaro.third_party.org.jooq.impl.AbstractNamed;
import com.craftaro.third_party.org.jooq.impl.CommentImpl;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.Tools;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

class IndexImpl
extends AbstractNamed
implements Index {
    private static final long serialVersionUID = -5253463940194393996L;
    private static final Set<SQLDialect> NO_SUPPORT_INDEX_QUALIFICATION = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES);
    private final Table<?> table;
    private final SortField<?>[] fields;
    private final Condition where;
    private final boolean unique;

    IndexImpl(Name name) {
        this(name, null, Tools.EMPTY_SORTFIELD, null, false);
    }

    IndexImpl(Name name, Table<?> table, OrderField<?>[] fields, Condition where, boolean unique) {
        super(name.empty() ? name : IndexImpl.qualify(table, name), CommentImpl.NO_COMMENT);
        this.table = table;
        this.fields = Tools.sortFields(fields);
        this.where = where;
        this.unique = unique;
    }

    final SortField<?>[] $fields() {
        return this.fields;
    }

    final boolean $unique() {
        return this.unique;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (NO_SUPPORT_INDEX_QUALIFICATION.contains((Object)ctx.dialect())) {
            ctx.visit(this.getUnqualifiedName());
        } else if (this.getTable() == null) {
            ctx.visit(this.getQualifiedName());
        } else {
            ctx.visit(DSL.name(this.getTable().getQualifiedName().qualifier(), this.getUnqualifiedName()));
        }
    }

    @Override
    public final Table<?> getTable() {
        return this.table;
    }

    @Override
    public final List<SortField<?>> getFields() {
        return Arrays.asList(this.fields);
    }

    @Override
    public final Condition getWhere() {
        return this.where;
    }

    @Override
    public boolean getUnique() {
        return this.unique;
    }
}

