/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Clause;
import com.craftaro.third_party.org.jooq.Condition;
import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.QueryPart;
import com.craftaro.third_party.org.jooq.RenderContext;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.Table;
import com.craftaro.third_party.org.jooq.impl.AbstractQueryPartMap;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.Tools;
import java.util.Map;
import java.util.Set;

final class FieldMapForUpdate
extends AbstractQueryPartMap<Field<?>, Field<?>> {
    private static final long serialVersionUID = -6139709404698673799L;
    private static final Set<SQLDialect> CASTS_NEEDED = SQLDialect.supportedBy(SQLDialect.POSTGRES);
    private static final Set<SQLDialect> NO_SUPPORT_QUALIFY = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.SQLITE);
    private final Table<?> table;
    private final Clause assignmentClause;

    FieldMapForUpdate(Table<?> table, Clause assignmentClause) {
        this.table = table;
        this.assignmentClause = assignmentClause;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.size() > 0) {
            String separator = "";
            boolean restoreQualify = ctx.qualify();
            boolean supportsQualify = NO_SUPPORT_QUALIFY.contains((Object)ctx.dialect()) ? false : restoreQualify;
            RenderContext.CastMode previous = ctx.castMode();
            if (!CASTS_NEEDED.contains((Object)ctx.dialect())) {
                ctx.castMode(RenderContext.CastMode.NEVER);
            }
            for (Map.Entry entry : Tools.flattenEntrySet(this.entrySet(), true)) {
                if (!"".equals(separator)) {
                    ctx.sql(separator).formatSeparator();
                }
                ctx.start(this.assignmentClause).qualify(supportsQualify).visit((QueryPart)entry.getKey()).qualify(restoreQualify).sql(" = ");
                Condition condition = (Condition)ctx.data((Object)Tools.DataKey.DATA_ON_DUPLICATE_KEY_WHERE);
                if (condition != null) {
                    ctx.visit(DSL.when(condition, (Field)entry.getValue()).else_((Field)entry.getKey()));
                } else {
                    ctx.visit((QueryPart)entry.getValue());
                }
                ctx.end(this.assignmentClause);
                separator = ",";
            }
            if (!CASTS_NEEDED.contains((Object)ctx.dialect())) {
                ctx.castMode(previous);
            }
        } else {
            ctx.sql("[ no fields are updated ]");
        }
    }

    final void set(Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Field<?> field = Tools.tableField(this.table, entry.getKey());
            Object value = entry.getValue();
            this.put(field, Tools.field(value, field));
        }
    }
}

