/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Configuration;
import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.Domain;
import com.craftaro.third_party.org.jooq.DropDomainCascadeStep;
import com.craftaro.third_party.org.jooq.DropDomainFinalStep;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.impl.AbstractRowCountQuery;
import com.craftaro.third_party.org.jooq.impl.DDLStatementType;
import com.craftaro.third_party.org.jooq.impl.Keywords;
import com.craftaro.third_party.org.jooq.impl.Tools;
import java.util.Set;

final class DropDomainImpl
extends AbstractRowCountQuery
implements DropDomainCascadeStep,
DropDomainFinalStep {
    private static final long serialVersionUID = 1L;
    private final Domain<?> domain;
    private final boolean dropDomainIfExists;
    private Boolean cascade;
    private static final Set<SQLDialect> NO_SUPPORT_IF_EXISTS = SQLDialect.supportedBy(SQLDialect.FIREBIRD);

    DropDomainImpl(Configuration configuration, Domain domain, boolean dropDomainIfExists) {
        this(configuration, domain, dropDomainIfExists, null);
    }

    DropDomainImpl(Configuration configuration, Domain domain, boolean dropDomainIfExists, Boolean cascade) {
        super(configuration);
        this.domain = domain;
        this.dropDomainIfExists = dropDomainIfExists;
        this.cascade = cascade;
    }

    final Domain<?> $domain() {
        return this.domain;
    }

    final boolean $dropDomainIfExists() {
        return this.dropDomainIfExists;
    }

    final Boolean $cascade() {
        return this.cascade;
    }

    @Override
    public final DropDomainImpl cascade() {
        this.cascade = true;
        return this;
    }

    @Override
    public final DropDomainImpl restrict() {
        this.cascade = false;
        return this;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.dropDomainIfExists && !this.supportsIfExists(ctx)) {
            Tools.beginTryCatch(ctx, DDLStatementType.DROP_DOMAIN);
            this.accept0(ctx);
            Tools.endTryCatch(ctx, DDLStatementType.DROP_DOMAIN);
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        switch (ctx.family()) {
            default: 
        }
        ctx.visit(Keywords.K_DROP).sql(' ').visit(Keywords.K_DOMAIN);
        if (this.dropDomainIfExists && this.supportsIfExists(ctx)) {
            ctx.sql(' ').visit(Keywords.K_IF_EXISTS);
        }
        ctx.sql(' ').visit(this.domain);
        if (this.cascade != null) {
            if (this.cascade.booleanValue()) {
                ctx.sql(' ').visit(Keywords.K_CASCADE);
            } else {
                ctx.sql(' ').visit(Keywords.K_RESTRICT);
            }
        }
    }
}

