/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.AlterSequenceFlagsStep;
import com.craftaro.third_party.org.jooq.AlterSequenceStep;
import com.craftaro.third_party.org.jooq.Catalog;
import com.craftaro.third_party.org.jooq.Check;
import com.craftaro.third_party.org.jooq.Configuration;
import com.craftaro.third_party.org.jooq.DDLExportConfiguration;
import com.craftaro.third_party.org.jooq.DSLContext;
import com.craftaro.third_party.org.jooq.DataType;
import com.craftaro.third_party.org.jooq.Domain;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.ForeignKey;
import com.craftaro.third_party.org.jooq.Index;
import com.craftaro.third_party.org.jooq.Meta;
import com.craftaro.third_party.org.jooq.MigrationConfiguration;
import com.craftaro.third_party.org.jooq.Name;
import com.craftaro.third_party.org.jooq.Named;
import com.craftaro.third_party.org.jooq.Nullability;
import com.craftaro.third_party.org.jooq.Queries;
import com.craftaro.third_party.org.jooq.Query;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.Schema;
import com.craftaro.third_party.org.jooq.Sequence;
import com.craftaro.third_party.org.jooq.Table;
import com.craftaro.third_party.org.jooq.TableOptions;
import com.craftaro.third_party.org.jooq.UniqueKey;
import com.craftaro.third_party.org.jooq.impl.Comparators;
import com.craftaro.third_party.org.jooq.impl.ConstraintType;
import com.craftaro.third_party.org.jooq.impl.DDL;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.tools.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

final class Diff {
    private static final Set<SQLDialect> NO_SUPPORT_PK_NAMES = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    private final MigrationConfiguration migrateConf;
    private final DDLExportConfiguration exportConf;
    private final DSLContext ctx;
    private final Meta meta1;
    private final Meta meta2;
    private final DDL ddl;
    private final Create<Schema> CREATE_SCHEMA = new Create<Schema>(){

        @Override
        public void create(DiffResult r, Schema s) {
            r.queries.addAll(Arrays.asList(Diff.this.ctx.ddl(s).queries()));
        }
    };
    private final Drop<Schema> DROP_SCHEMA = new Drop<Schema>(){

        @Override
        public void drop(DiffResult r, Schema s) {
            if (s.getTables().isEmpty() && s.getSequences().isEmpty()) {
                r.queries.add(Diff.this.ctx.dropSchema(s));
            } else if (Diff.this.migrateConf.dropSchemaCascade()) {
                for (Table<?> table : s.getTables()) {
                    for (UniqueKey<?> uk : table.getKeys()) {
                        for (ForeignKey<?, ?> fk : uk.getReferences()) {
                            r.droppedFks.add(fk);
                        }
                    }
                }
                r.queries.add(Diff.this.ctx.dropSchema(s).cascade());
            } else {
                for (Table<?> table : s.getTables()) {
                    Diff.this.DROP_TABLE.drop(r, table);
                }
                for (Sequence sequence : s.getSequences()) {
                    Diff.this.DROP_SEQUENCE.drop(r, sequence);
                }
                r.queries.add(Diff.this.ctx.dropSchema(s));
            }
        }
    };
    private final Merge<Schema> MERGE_SCHEMA = new Merge<Schema>(){

        @Override
        public void merge(DiffResult r, Schema s1, Schema s2) {
            Diff.this.appendDomains(r, s1.getDomains(), s2.getDomains());
            Diff.this.appendTables(r, s1.getTables(), s2.getTables());
            Diff.this.appendSequences(r, s1.getSequences(), s2.getSequences());
        }
    };
    private final Create<Sequence<?>> CREATE_SEQUENCE = new Create<Sequence<?>>(){

        @Override
        public void create(DiffResult r, Sequence<?> s) {
            r.queries.add(Diff.this.ddl.createSequence(s));
        }
    };
    private final Drop<Sequence<?>> DROP_SEQUENCE = new Drop<Sequence<?>>(){

        @Override
        public void drop(DiffResult r, Sequence<?> s) {
            r.queries.add(Diff.this.ctx.dropSequence(s));
        }
    };
    private final Merge<Sequence<?>> MERGE_SEQUENCE = new Merge<Sequence<?>>(){

        @Override
        public void merge(DiffResult r, Sequence<?> s1, Sequence<?> s2) {
            AlterSequenceFlagsStep stmt = null;
            AlterSequenceStep<?> stmt0 = Diff.this.ctx.alterSequence(s1);
            if (s2.getStartWith() != null && !s2.getStartWith().equals(s1.getStartWith())) {
                stmt = ((AlterSequenceFlagsStep)StringUtils.defaultIfNull(stmt, stmt0)).startWith(s2.getStartWith());
            } else if (s2.getStartWith() == null && s1.getStartWith() != null) {
                stmt = ((AlterSequenceFlagsStep)StringUtils.defaultIfNull(stmt, stmt0)).startWith(1);
            }
            if (s2.getIncrementBy() != null && !s2.getIncrementBy().equals(s1.getIncrementBy())) {
                stmt = ((AlterSequenceFlagsStep)StringUtils.defaultIfNull(stmt, stmt0)).incrementBy(s2.getIncrementBy());
            } else if (s2.getIncrementBy() == null && s1.getIncrementBy() != null) {
                stmt = ((AlterSequenceFlagsStep)StringUtils.defaultIfNull(stmt, stmt0)).incrementBy(1);
            }
            if (s2.getMinvalue() != null && !s2.getMinvalue().equals(s1.getMinvalue())) {
                stmt = ((AlterSequenceFlagsStep)StringUtils.defaultIfNull(stmt, stmt0)).minvalue(s2.getMinvalue());
            } else if (s2.getMinvalue() == null && s1.getMinvalue() != null) {
                stmt = ((AlterSequenceFlagsStep)StringUtils.defaultIfNull(stmt, stmt0)).noMinvalue();
            }
            if (s2.getMaxvalue() != null && !s2.getMaxvalue().equals(s1.getMaxvalue())) {
                stmt = ((AlterSequenceFlagsStep)StringUtils.defaultIfNull(stmt, stmt0)).maxvalue(s2.getMaxvalue());
            } else if (s2.getMaxvalue() == null && s1.getMaxvalue() != null) {
                stmt = ((AlterSequenceFlagsStep)StringUtils.defaultIfNull(stmt, stmt0)).noMaxvalue();
            }
            if (s2.getCache() != null && !s2.getCache().equals(s1.getCache())) {
                stmt = ((AlterSequenceFlagsStep)StringUtils.defaultIfNull(stmt, stmt0)).cache(s2.getCache());
            } else if (s2.getCache() == null && s1.getCache() != null) {
                stmt = ((AlterSequenceFlagsStep)StringUtils.defaultIfNull(stmt, stmt0)).noCache();
            }
            if (s2.getCycle() && !s1.getCycle()) {
                stmt = ((AlterSequenceFlagsStep)StringUtils.defaultIfNull(stmt, stmt0)).cycle();
            } else if (!s2.getCycle() && s1.getCycle()) {
                stmt = ((AlterSequenceFlagsStep)StringUtils.defaultIfNull(stmt, stmt0)).noCycle();
            }
            if (stmt != null) {
                r.queries.add(stmt);
            }
        }
    };
    private final Create<Domain<?>> CREATE_DOMAIN = new Create<Domain<?>>(){

        @Override
        public void create(DiffResult r, Domain<?> d) {
            r.queries.add(Diff.this.ddl.createDomain(d));
        }
    };
    private final Drop<Domain<?>> DROP_DOMAIN = new Drop<Domain<?>>(){

        @Override
        public void drop(DiffResult r, Domain<?> d) {
            r.queries.add(Diff.this.ctx.dropDomain(d));
        }
    };
    private final Merge<Domain<?>> MERGE_DOMAIN = new Merge<Domain<?>>(){

        @Override
        public void merge(DiffResult r, Domain<?> d1, Domain<?> d2) {
            if (!d1.getDataType().getSQLDataType().equals(d2.getDataType().getSQLDataType())) {
                r.queries.addAll(Arrays.asList(Diff.this.ctx.dropDomain(d1), Diff.this.ddl.createDomain(d2)));
            } else {
                if (d1.getDataType().defaulted() && !d2.getDataType().defaulted()) {
                    r.queries.add(Diff.this.ctx.alterDomain(d1).dropDefault());
                } else if (d2.getDataType().defaulted() && !d2.getDataType().defaultValue().equals(d1.getDataType().defaultValue())) {
                    r.queries.add(Diff.this.ctx.alterDomain(d1).setDefault(d2.getDataType().defaultValue()));
                }
                Diff.this.appendChecks(r, d1, d1.getChecks(), d2.getChecks());
            }
        }
    };
    private final Create<Table<?>> CREATE_TABLE = new Create<Table<?>>(){

        @Override
        public void create(DiffResult r, Table<?> t) {
            r.queries.addAll(Arrays.asList(Diff.this.ddl.queries(t).queries()));
        }
    };
    private final Drop<Table<?>> DROP_TABLE = new Drop<Table<?>>(){

        @Override
        public void drop(DiffResult r, Table<?> t) {
            for (UniqueKey<?> uk : t.getKeys()) {
                for (ForeignKey<?, ?> fk : uk.getReferences()) {
                    if (!r.droppedFks.add(fk) || Diff.this.migrateConf.dropTableCascade()) continue;
                    r.queries.add(Diff.this.ctx.alterTable(fk.getTable()).dropForeignKey(fk.constraint()));
                }
            }
            if (t.getType().isView()) {
                r.queries.add(Diff.this.ctx.dropView(t));
            } else if (t.getType() == TableOptions.TableType.TEMPORARY) {
                r.queries.add(Diff.this.ctx.dropTemporaryTable(t));
            } else {
                r.queries.add(Diff.this.migrateConf.dropTableCascade() ? Diff.this.ctx.dropTable(t).cascade() : Diff.this.ctx.dropTable(t));
            }
        }
    };
    private final Merge<Table<?>> MERGE_TABLE = new Merge<Table<?>>(){

        @Override
        public void merge(DiffResult r, Table<?> t1, Table<?> t2) {
            String c2;
            String c1;
            boolean v1 = t1.getType().isView();
            boolean v2 = t2.getType().isView();
            if (v1 && v2) {
                if (!Arrays.equals(t1.fields(), t2.fields()) || t2.getOptions().select() != null && !t2.getOptions().select().equals(t1.getOptions().select()) || t2.getOptions().source() != null && !t2.getOptions().source().equals(t1.getOptions().source())) {
                    this.replaceView(r, t1, t2);
                    return;
                }
            } else {
                if (v1 != v2) {
                    this.replaceView(r, t1, t2);
                    return;
                }
                Diff.this.appendColumns(r, t1, Arrays.asList(t1.fields()), Arrays.asList(t2.fields()));
                Diff.this.appendPrimaryKey(r, t1, Arrays.asList(t1.getPrimaryKey()), Arrays.asList(t2.getPrimaryKey()));
                Diff.this.appendUniqueKeys(r, t1, Diff.this.removePrimary(t1.getKeys()), Diff.this.removePrimary(t2.getKeys()));
                Diff.this.appendForeignKeys(r, t1, t1.getReferences(), t2.getReferences());
                Diff.this.appendChecks(r, t1, t1.getChecks(), t2.getChecks());
                Diff.this.appendIndexes(r, t1, t1.getIndexes(), t2.getIndexes());
            }
            if (!(c1 = StringUtils.defaultString(t1.getComment())).equals(c2 = StringUtils.defaultString(t2.getComment()))) {
                if (v2) {
                    r.queries.add(Diff.this.ctx.commentOnView(t2).is(c2));
                } else {
                    r.queries.add(Diff.this.ctx.commentOnTable(t2).is(c2));
                }
            }
        }

        private void replaceView(DiffResult r, Table<?> v1, Table<?> v2) {
            if (!Diff.this.migrateConf.createOrReplaceView()) {
                Diff.this.DROP_TABLE.drop(r, v1);
            }
            Diff.this.CREATE_TABLE.create(r, v2);
        }
    };

    Diff(Configuration configuration, MigrationConfiguration migrateConf, Meta meta1, Meta meta2) {
        this.migrateConf = migrateConf;
        this.exportConf = new DDLExportConfiguration().createOrReplaceView(migrateConf.createOrReplaceView());
        this.ctx = configuration.dsl();
        this.meta1 = meta1;
        this.meta2 = meta2;
        this.ddl = new DDL(this.ctx, this.exportConf);
    }

    final Queries queries() {
        return this.ctx.queries(this.appendCatalogs((DiffResult)new DiffResult(), this.meta1.getCatalogs(), this.meta2.getCatalogs()).queries);
    }

    private final DiffResult appendCatalogs(DiffResult result, List<Catalog> l1, List<Catalog> l2) {
        return this.append(result, l1, l2, null, null, null, new Merge<Catalog>(){

            @Override
            public void merge(DiffResult r, Catalog c1, Catalog c2) {
                Diff.this.appendSchemas(r, c1.getSchemas(), c2.getSchemas());
            }
        });
    }

    private final DiffResult appendSchemas(DiffResult result, List<Schema> l1, List<Schema> l2) {
        return this.append(result, l1, l2, null, this.CREATE_SCHEMA, this.DROP_SCHEMA, this.MERGE_SCHEMA);
    }

    private final DiffResult appendSequences(DiffResult result, List<? extends Sequence<?>> l1, List<? extends Sequence<?>> l2) {
        return this.append(result, l1, l2, null, this.CREATE_SEQUENCE, this.DROP_SEQUENCE, this.MERGE_SEQUENCE);
    }

    private final DiffResult appendDomains(DiffResult result, List<? extends Domain<?>> l1, List<? extends Domain<?>> l2) {
        return this.append(result, l1, l2, null, this.CREATE_DOMAIN, this.DROP_DOMAIN, this.MERGE_DOMAIN);
    }

    private final DiffResult appendTables(DiffResult result, List<? extends Table<?>> l1, List<? extends Table<?>> l2) {
        return this.append(result, l1, l2, null, this.CREATE_TABLE, this.DROP_TABLE, this.MERGE_TABLE);
    }

    private final List<UniqueKey<?>> removePrimary(List<? extends UniqueKey<?>> list) {
        ArrayList result = new ArrayList();
        for (UniqueKey<?> uk : list) {
            if (uk.isPrimary()) continue;
            result.add(uk);
        }
        return result;
    }

    private final DiffResult appendColumns(DiffResult result, final Table<?> t1, List<? extends Field<?>> l1, List<? extends Field<?>> l2) {
        final ArrayList add = new ArrayList();
        final ArrayList drop = new ArrayList();
        result = this.append(result, l1, l2, null, new Create<Field<?>>(){

            @Override
            public void create(DiffResult r, Field<?> f) {
                if (Diff.this.migrateConf.alterTableAddMultiple()) {
                    add.add(f);
                } else {
                    r.queries.add(Diff.this.ctx.alterTable(t1).add(f));
                }
            }
        }, new Drop<Field<?>>(){

            @Override
            public void drop(DiffResult r, Field<?> f) {
                if (Diff.this.migrateConf.alterTableDropMultiple()) {
                    drop.add(f);
                } else {
                    r.queries.add(Diff.this.ctx.alterTable(t1).drop(f));
                }
            }
        }, new Merge<Field<?>>(){

            @Override
            public void merge(DiffResult r, Field<?> f1, Field<?> f2) {
                DataType type1 = f1.getDataType();
                DataType type2 = f2.getDataType();
                if (!type1.getTypeName().equals(type2.getTypeName())) {
                    r.queries.add(Diff.this.ctx.alterTable(t1).alter(f1).set(type2.nullability(Nullability.DEFAULT)));
                }
                if (type1.nullable() && !type2.nullable()) {
                    r.queries.add(Diff.this.ctx.alterTable(t1).alter(f1).setNotNull());
                } else if (!type1.nullable() && type2.nullable()) {
                    r.queries.add(Diff.this.ctx.alterTable(t1).alter(f1).dropNotNull());
                }
                Field d1 = type1.defaultValue();
                Field d2 = type2.defaultValue();
                if (type1.defaulted() && !type2.defaulted()) {
                    r.queries.add(Diff.this.ctx.alterTable(t1).alter(f1).dropDefault());
                } else if (!(!type2.defaulted() || type1.defaulted() && d2.equals(d1))) {
                    r.queries.add(Diff.this.ctx.alterTable(t1).alter(f1).setDefault(d2));
                }
                if (type1.hasLength() && type2.hasLength() && (type1.lengthDefined() != type2.lengthDefined() || type1.length() != type2.length()) || type1.hasPrecision() && type2.hasPrecision() && (type1.precisionDefined() != type2.precisionDefined() || type1.precision() != type2.precision()) || type1.hasScale() && type2.hasScale() && (type1.scaleDefined() != type2.scaleDefined() || type1.scale() != type2.scale())) {
                    r.queries.add(Diff.this.ctx.alterTable(t1).alter(f1).set(type2));
                }
            }
        });
        if (!drop.isEmpty()) {
            result.queries.add(0, this.ctx.alterTable(t1).drop(drop));
        }
        if (!add.isEmpty()) {
            result.queries.add(this.ctx.alterTable(t1).add(add));
        }
        return result;
    }

    private final DiffResult appendPrimaryKey(DiffResult result, final Table<?> t1, List<? extends UniqueKey<?>> pk1, List<? extends UniqueKey<?>> pk2) {
        Create create = new Create<UniqueKey<?>>(){

            @Override
            public void create(DiffResult r, UniqueKey<?> pk) {
                r.queries.add(Diff.this.ctx.alterTable(t1).add(pk.constraint()));
            }
        };
        Drop drop = new Drop<UniqueKey<?>>(){

            @Override
            public void drop(DiffResult r, UniqueKey<?> pk) {
                if (StringUtils.isEmpty(pk.getName())) {
                    r.queries.add(Diff.this.ctx.alterTable(t1).dropPrimaryKey());
                } else {
                    r.queries.add(Diff.this.ctx.alterTable(t1).dropPrimaryKey(pk.constraint()));
                }
            }
        };
        return this.append(result, pk1, pk2, Comparators.KEY_COMP, create, drop, this.keyMerge(t1, create, drop, ConstraintType.PRIMARY_KEY), true);
    }

    private final DiffResult appendUniqueKeys(DiffResult result, final Table<?> t1, List<? extends UniqueKey<?>> uk1, List<? extends UniqueKey<?>> uk2) {
        Create create = new Create<UniqueKey<?>>(){

            @Override
            public void create(DiffResult r, UniqueKey<?> u) {
                r.queries.add(Diff.this.ctx.alterTable(t1).add(u.constraint()));
            }
        };
        Drop drop = new Drop<UniqueKey<?>>(){

            @Override
            public void drop(DiffResult r, UniqueKey<?> u) {
                r.queries.add(Diff.this.ctx.alterTable(t1).dropUnique(u.constraint()));
            }
        };
        return this.append(result, uk1, uk2, Comparators.KEY_COMP, create, drop, this.keyMerge(t1, create, drop, ConstraintType.UNIQUE), true);
    }

    private final <K extends Named> Merge<K> keyMerge(final Table<?> t1, final Create<K> create, final Drop<K> drop, final ConstraintType type) {
        return new Merge<K>(){

            @Override
            public void merge(DiffResult r, K k1, K k2) {
                Name n1 = k1.getUnqualifiedName();
                Name n2 = k2.getUnqualifiedName();
                if (n1.empty() ^ n2.empty()) {
                    drop.drop(r, k1);
                    create.create(r, k2);
                    return;
                }
                if (!(Comparators.NAMED_COMP.compare((Named)k1, (Named)k2) == 0 || type == ConstraintType.PRIMARY_KEY && NO_SUPPORT_PK_NAMES.contains((Object)Diff.this.ctx.dialect()))) {
                    r.queries.add(Diff.this.ctx.alterTable(t1).renameConstraint(n1).to(n2));
                }
            }
        };
    }

    private final <K extends Named> Merge<K> keyMerge(final Domain<?> d1, final Create<K> create, final Drop<K> drop) {
        return new Merge<K>(){

            @Override
            public void merge(DiffResult r, K k1, K k2) {
                Name n1 = k1.getUnqualifiedName();
                Name n2 = k2.getUnqualifiedName();
                if (n1.empty() ^ n2.empty()) {
                    drop.drop(r, k1);
                    create.create(r, k2);
                    return;
                }
                if (Comparators.NAMED_COMP.compare((Named)k1, (Named)k2) != 0) {
                    r.queries.add(Diff.this.ctx.alterDomain(d1).renameConstraint(n1).to(n2));
                }
            }
        };
    }

    private final DiffResult appendForeignKeys(DiffResult result, final Table<?> t1, List<? extends ForeignKey<?, ?>> fk1, List<? extends ForeignKey<?, ?>> fk2) {
        Create create = new Create<ForeignKey<?, ?>>(){

            @Override
            public void create(DiffResult r, ForeignKey<?, ?> fk) {
                r.queries.add(Diff.this.ctx.alterTable(t1).add(fk.constraint()));
            }
        };
        Drop drop = new Drop<ForeignKey<?, ?>>(){

            @Override
            public void drop(DiffResult r, ForeignKey<?, ?> fk) {
                if (r.droppedFks.add(fk)) {
                    r.queries.add(Diff.this.ctx.alterTable(t1).dropForeignKey(fk.constraint()));
                }
            }
        };
        return this.append(result, fk1, fk2, Comparators.FOREIGN_KEY_COMP, create, drop, this.keyMerge(t1, create, drop, ConstraintType.FOREIGN_KEY), true);
    }

    private final DiffResult appendChecks(DiffResult result, final Table<?> t1, List<? extends Check<?>> c1, List<? extends Check<?>> c2) {
        Create create = new Create<Check<?>>(){

            @Override
            public void create(DiffResult r, Check<?> c2) {
                r.queries.add(Diff.this.ctx.alterTable(t1).add(c2.constraint()));
            }
        };
        Drop drop = new Drop<Check<?>>(){

            @Override
            public void drop(DiffResult r, Check<?> c2) {
                r.queries.add(Diff.this.ctx.alterTable(t1).drop(c2.constraint()));
            }
        };
        return this.append(result, c1, c2, Comparators.CHECK_COMP, create, drop, this.keyMerge(t1, create, drop, ConstraintType.CHECK), true);
    }

    private final DiffResult appendChecks(DiffResult result, final Domain<?> d1, List<? extends Check<?>> c1, List<? extends Check<?>> c2) {
        Create create = new Create<Check<?>>(){

            @Override
            public void create(DiffResult r, Check<?> c2) {
                r.queries.add(Diff.this.ctx.alterDomain(d1).add(c2.constraint()));
            }
        };
        Drop drop = new Drop<Check<?>>(){

            @Override
            public void drop(DiffResult r, Check<?> c2) {
                r.queries.add(Diff.this.ctx.alterDomain(d1).dropConstraint(c2.constraint()));
            }
        };
        return this.append(result, c1, c2, Comparators.CHECK_COMP, create, drop, this.keyMerge(d1, create, drop), true);
    }

    private final DiffResult appendIndexes(DiffResult result, final Table<?> t1, List<? extends Index> l1, List<? extends Index> l2) {
        final Create<Index> create = new Create<Index>(){

            @Override
            public void create(DiffResult r, Index i) {
                r.queries.add(Diff.this.ctx.createIndex(i).on(t1, i.getFields()));
            }
        };
        final Drop<Index> drop = new Drop<Index>(){

            @Override
            public void drop(DiffResult r, Index i) {
                r.queries.add(Diff.this.ctx.dropIndex(i).on(t1));
            }
        };
        return this.append(result, l1, l2, Comparators.INDEX_COMP, create, drop, new Merge<Index>(){

            @Override
            public void merge(DiffResult r, Index ix1, Index ix2) {
                if (ix1.getUnique() != ix2.getUnique() || !ix1.getFields().equals(ix2.getFields()) || !StringUtils.defaultIfNull(ix1.getWhere(), DSL.noCondition()).equals(StringUtils.defaultIfNull(ix2.getWhere(), DSL.noCondition()))) {
                    drop.drop(r, ix1);
                    create.create(r, ix2);
                } else if (Comparators.NAMED_COMP.compare(ix1, ix2) != 0) {
                    r.queries.add(Diff.this.ctx.alterTable(t1).renameIndex(ix1).to(ix2));
                }
            }
        }, true);
    }

    private final <N extends Named> DiffResult append(DiffResult result, List<? extends N> l1, List<? extends N> l2, Comparator<? super N> comp, Create<N> create, Drop<N> drop, Merge<N> merge) {
        return this.append(result, l1, l2, comp, create, drop, merge, false);
    }

    private final <N extends Named> DiffResult append(DiffResult result, List<? extends N> l1, List<? extends N> l2, Comparator<? super N> comp, Create<N> create, Drop<N> drop, Merge<N> merge, boolean dropMergeCreate) {
        DiffResult created;
        if (comp == null) {
            comp = Comparators.NAMED_COMP;
        }
        Named s1 = null;
        Named s2 = null;
        Iterator<N> i1 = Diff.sorted(l1, comp);
        Iterator<N> i2 = Diff.sorted(l2, comp);
        DiffResult dropped = dropMergeCreate ? new DiffResult(new ArrayList<Query>(), result.droppedFks) : result;
        DiffResult merged = dropMergeCreate ? new DiffResult(new ArrayList<Query>(), result.droppedFks) : result;
        DiffResult diffResult = created = dropMergeCreate ? new DiffResult(new ArrayList<Query>(), result.droppedFks) : result;
        while (true) {
            int c2;
            if (s1 == null && i1.hasNext()) {
                s1 = (Named)i1.next();
            }
            if (s2 == null && i2.hasNext()) {
                s2 = (Named)i2.next();
            }
            if (s1 == null && s2 == null) break;
            int n = s1 == null ? 1 : (c2 = s2 == null ? -1 : comp.compare(s1, s2));
            if (c2 < 0) {
                if (drop != null) {
                    drop.drop(dropped, s1);
                }
                s1 = null;
                continue;
            }
            if (c2 > 0) {
                if (create != null) {
                    create.create(created, s2);
                }
                s2 = null;
                continue;
            }
            if (merge != null) {
                merge.merge(merged, s1, s2);
            }
            s2 = null;
            s1 = null;
        }
        if (dropMergeCreate) {
            result.addAll(dropped);
            result.addAll(merged);
            result.addAll(created);
        }
        return result;
    }

    private static final <N extends Named> Iterator<N> sorted(List<N> list, Comparator<? super N> comp) {
        ArrayList<N> result = new ArrayList<N>(list);
        Collections.sort(result, comp);
        return result.iterator();
    }

    private static final class DiffResult {
        final List<Query> queries;
        final Set<ForeignKey<?, ?>> droppedFks;

        DiffResult() {
            this(new ArrayList<Query>(), new HashSet());
        }

        DiffResult(List<Query> queries, Set<ForeignKey<?, ?>> droppedFks) {
            this.queries = queries;
            this.droppedFks = droppedFks;
        }

        void addAll(DiffResult other) {
            this.queries.addAll(other.queries);
            this.droppedFks.addAll(other.droppedFks);
        }

        public String toString() {
            return this.queries.toString();
        }
    }

    private static interface Merge<N extends Named> {
        public void merge(DiffResult var1, N var2, N var3);
    }

    private static interface Drop<N extends Named> {
        public void drop(DiffResult var1, N var2);
    }

    private static interface Create<N extends Named> {
        public void create(DiffResult var1, N var2);
    }
}

