/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Unwrapper;
import com.craftaro.third_party.org.jooq.UnwrapperProvider;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Wrapper;

final class DefaultUnwrapperProvider
implements UnwrapperProvider {
    static final Unwrapper INSTANCE = new DefaultUnwrapper();

    DefaultUnwrapperProvider() {
    }

    @Override
    public Unwrapper provide() {
        return INSTANCE;
    }

    static final class DefaultUnwrapper
    implements Unwrapper {
        private static int maxUnwrappedConnections = 256;
        private static int maxUnwrappedStatements = 256;

        DefaultUnwrapper() {
        }

        static final boolean isWrapperFor(Wrapper w, Class<?> iface) {
            try {
                return w.isWrapperFor(iface);
            }
            catch (SQLException ignore) {
                return false;
            }
        }

        @Override
        public <T> T unwrap(Wrapper wrapper, Class<T> iface) {
            if (wrapper instanceof Connection) {
                return this.unwrap((Connection)wrapper, iface);
            }
            if (wrapper instanceof Statement) {
                return this.unwrap((Statement)wrapper, iface);
            }
            throw new IllegalArgumentException("Cannot unwrap: " + wrapper);
        }

        private <T> T unwrap(Connection wrapper, Class<T> iface) {
            Connection result = wrapper;
            return (T)result;
        }

        private <T> T unwrap(Statement wrapper, Class<T> iface) {
            Statement result = wrapper;
            return (T)result;
        }
    }
}

