/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Attachable;
import com.craftaro.third_party.org.jooq.Configuration;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.Record;
import com.craftaro.third_party.org.jooq.RecordMapper;
import com.craftaro.third_party.org.jooq.RecordType;
import com.craftaro.third_party.org.jooq.exception.MappingException;
import com.craftaro.third_party.org.jooq.impl.AbstractRecord;
import com.craftaro.third_party.org.jooq.impl.AbstractRow;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.DefaultConfiguration;
import com.craftaro.third_party.org.jooq.impl.RecordDelegate;
import com.craftaro.third_party.org.jooq.impl.RecordOperation;
import com.craftaro.third_party.org.jooq.impl.Tools;
import com.craftaro.third_party.org.jooq.tools.Convert;
import com.craftaro.third_party.org.jooq.tools.StringUtils;
import com.craftaro.third_party.org.jooq.tools.reflect.Reflect;
import com.craftaro.third_party.org.jooq.tools.reflect.ReflectException;
import java.beans.ConstructorProperties;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultRecordMapper<R extends Record, E>
implements RecordMapper<R, E> {
    private final Field<?>[] fields;
    private final RecordType<R> rowType;
    private final Class<? extends E> type;
    private final Configuration configuration;
    private RecordMapper<R, E> delegate;
    private transient Set<String> prefixes;

    public DefaultRecordMapper(RecordType<R> rowType, Class<? extends E> type) {
        this(rowType, type, null, null);
    }

    public DefaultRecordMapper(RecordType<R> rowType, Class<? extends E> type, Configuration configuration) {
        this(rowType, type, null, configuration);
    }

    DefaultRecordMapper(RecordType<R> rowType, Class<? extends E> type, E instance, Configuration configuration) {
        this.rowType = rowType;
        this.fields = rowType.fields();
        this.type = type;
        this.configuration = configuration != null ? configuration : new DefaultConfiguration();
        this.init(instance);
    }

    private final void init(E instance) {
        Constructor<?> constructor;
        Parameter[] parameters;
        if (this.type.isArray()) {
            this.delegate = new ArrayMapper(instance);
            return;
        }
        if (Stream.class.isAssignableFrom(this.type)) {
            RecordMapper local = this.configuration.recordMapperProvider().provide(this.rowType, Object[].class);
            this.delegate = r -> Stream.of((Object[])local.map(r));
            return;
        }
        if (Modifier.isAbstract(this.type.getModifiers()) && !this.type.isPrimitive()) {
            this.delegate = new ProxyMapper();
            return;
        }
        if (AbstractRecord.class.isAssignableFrom(this.type)) {
            this.delegate = new RecordToRecordMapper();
            return;
        }
        if (this.fields.length == 1 && Tools.converter(this.configuration, this.fields[0].getType(), this.type) != null) {
            this.delegate = new ValueTypeMapper();
            return;
        }
        try {
            MutablePOJOMapper m = new MutablePOJOMapper(new ConstructorCall<E>(Reflect.accessible(this.type.getDeclaredConstructor(new Class[0]))), instance);
            if (m.isMutable() || this.type.getDeclaredConstructors().length <= 1) {
                this.delegate = m;
                return;
            }
        }
        catch (NoSuchMethodException m) {
            // empty catch block
        }
        Constructor<?>[] constructors = this.type.getDeclaredConstructors();
        Arrays.sort(constructors, new Comparator<Constructor<E>>(){

            @Override
            public int compare(Constructor<E> c1, Constructor<E> c2) {
                return (c2.getModifiers() & 1) - (c1.getModifiers() & 1);
            }
        });
        for (Constructor<?> constructor2 : constructors) {
            ConstructorProperties properties = constructor2.getAnnotation(ConstructorProperties.class);
            if (properties == null) continue;
            this.delegate = new ImmutablePOJOMapperWithParameterNames(constructor2, Arrays.asList(properties.value()), true);
            return;
        }
        if (Tools.isKotlinAvailable() && !Boolean.FALSE.equals(this.configuration.settings().isMapConstructorParameterNamesInKotlin())) {
            try {
                Reflect jvmClassMappingKt = Tools.ktJvmClassMapping();
                Reflect kClasses = Tools.ktKClasses();
                Reflect kTypeParameter = Tools.ktKTypeParameter();
                Object klass = jvmClassMappingKt.call("getKotlinClass", this.type).get();
                Reflect primaryConstructor = kClasses.call("getPrimaryConstructor", klass);
                if (primaryConstructor.get() != null) {
                    List parameters2 = (List)primaryConstructor.call("getParameters").get();
                    Class<?> klassType = Tools.ktKClass().type();
                    Method getJavaClass = jvmClassMappingKt.type().getMethod("getJavaClass", klassType);
                    ArrayList<String> parameterNames = new ArrayList<String>(parameters2.size());
                    Class[] parameterTypes = new Class[parameters2.size()];
                    for (int i = 0; i < parameterTypes.length; ++i) {
                        Reflect parameter = Reflect.on(parameters2.get(i));
                        Object typeClassifier = parameter.call("getType").call("getClassifier").get();
                        String name = (String)parameter.call("getName").get();
                        parameterTypes[i] = (Class)getJavaClass.invoke(jvmClassMappingKt.get(), kTypeParameter.type().isInstance(typeClassifier) ? Reflect.on(typeClassifier).call("getUpperBounds").call("get", 0).call("getClassifier").get() : typeClassifier);
                        String typeName = parameterTypes[i].getName();
                        if (name.startsWith("is") && (Boolean.TYPE.getName().equalsIgnoreCase(typeName) || Boolean.class.getName().equals(typeName))) {
                            name = Tools.getPropertyName(name);
                        }
                        parameterNames.add(name);
                    }
                    Constructor<? extends E> javaConstructor = Reflect.accessible(this.type.getDeclaredConstructor(parameterTypes));
                    this.delegate = new ImmutablePOJOMapperWithParameterNames(javaConstructor, parameterNames, true);
                    return;
                }
            }
            catch (ReflectException jvmClassMappingKt) {
            }
            catch (NoSuchMethodException jvmClassMappingKt) {
            }
            catch (IllegalAccessException jvmClassMappingKt) {
            }
            catch (InvocationTargetException jvmClassMappingKt) {
                // empty catch block
            }
        }
        boolean mapConstructorParameterNames = Boolean.TRUE.equals(this.configuration.settings().isMapConstructorParameterNames());
        for (boolean supportsNesting : new boolean[]{true, false}) {
            for (Constructor<?> constructor3 : constructors) {
                Parameter[] parameters3;
                Class<?>[] parameterTypes = constructor3.getParameterTypes();
                if (parameterTypes.length != (supportsNesting ? this.prefixes().size() : this.fields.length)) continue;
                if (mapConstructorParameterNames && (parameters3 = constructor3.getParameters()) != null && parameters3.length > 0) {
                    this.delegate = new ImmutablePOJOMapperWithParameterNames(constructor3, this.collectParameterNames(parameters3), supportsNesting);
                }
                if (this.delegate == null) {
                    this.delegate = new ImmutablePOJOMapper(constructor3, parameterTypes, supportsNesting);
                }
                return;
            }
        }
        if (mapConstructorParameterNames && (parameters = (constructor = constructors[0]).getParameters()) != null && parameters.length > 0) {
            this.delegate = new ImmutablePOJOMapperWithParameterNames(constructor, this.collectParameterNames(parameters), false);
            return;
        }
        throw new MappingException("No matching constructor found on type " + this.type + " for row type " + this.rowType);
    }

    private List<String> collectParameterNames(Parameter[] parameters) {
        return Arrays.stream(parameters).map(Parameter::getName).collect(Collectors.toList());
    }

    @Override
    public final E map(R record) {
        if (record == null) {
            return null;
        }
        try {
            return DefaultRecordMapper.attach(this.delegate.map(record), record);
        }
        catch (MappingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MappingException("An error ocurred when mapping record to " + this.type, e);
        }
    }

    private static <E> E attach(E attachable, Record record) {
        if (attachable instanceof Attachable && Tools.attachRecords(record.configuration())) {
            ((Attachable)attachable).attach(record.configuration());
        }
        return attachable;
    }

    private final Set<String> prefixes() {
        if (this.prefixes == null) {
            this.prefixes = new LinkedHashSet<String>();
            for (Field<?> field : this.fields) {
                String name = field.getName();
                int dot = name.indexOf(46);
                this.prefixes.add(dot > -1 ? name.substring(0, dot) : name);
            }
        }
        return this.prefixes;
    }

    static class NestedMappingInfo {
        final List<RecordMapper<AbstractRecord, Object>> mappers = new ArrayList<RecordMapper<AbstractRecord, Object>>();
        AbstractRow row;
        final List<Integer> indexLookup = new ArrayList<Integer>();
        RecordDelegate<? extends AbstractRecord> recordDelegate;

        NestedMappingInfo() {
        }
    }

    private class ImmutablePOJOMapperWithParameterNames
    extends ImmutablePOJOMapper {
        private final List<String> propertyNames;
        private final boolean useAnnotations;
        private final List<java.lang.reflect.Field>[] members;
        private final Method[] methods;
        private final Integer[] propertyIndexes;

        ImmutablePOJOMapperWithParameterNames(Constructor<E> constructor, List<String> propertyNames, boolean supportsNesting) {
            super(constructor, constructor.getParameterTypes(), supportsNesting);
            this.propertyNames = propertyNames;
            this.useAnnotations = Tools.hasColumnAnnotations(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type);
            this.members = new List[DefaultRecordMapper.this.fields.length];
            this.methods = new Method[DefaultRecordMapper.this.fields.length];
            this.propertyIndexes = new Integer[DefaultRecordMapper.this.fields.length];
            block0: for (int i = 0; i < DefaultRecordMapper.this.fields.length; ++i) {
                Field field = DefaultRecordMapper.this.fields[i];
                String name = field.getName();
                String nameLC = StringUtils.toCamelCaseLC(name);
                if (this.useAnnotations) {
                    this.members[i] = Tools.getAnnotatedMembers(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type, name, false);
                    this.methods[i] = Tools.getAnnotatedGetter(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type, name, true);
                } else {
                    this.members[i] = Tools.getMatchingMembers(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type, name, false);
                    this.methods[i] = Tools.getMatchingGetter(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type, name, true);
                }
                for (int j = 0; j < propertyNames.size(); ++j) {
                    if (!name.equals(propertyNames.get(j)) && !nameLC.equals(propertyNames.get(j))) continue;
                    this.propertyIndexes[i] = j;
                    continue block0;
                }
            }
        }

        @Override
        void set(Record from, Object[] to, int i) {
            if (this.propertyIndexes[i] != null) {
                to[this.propertyIndexes[i].intValue()] = from.get(i, this.parameterTypes[this.propertyIndexes[i]]);
            } else {
                String name;
                int index;
                for (java.lang.reflect.Field member : this.members[i]) {
                    int index2 = this.propertyNames.indexOf(member.getName());
                    if (index2 < 0) continue;
                    to[index2] = from.get(i, member.getType());
                }
                if (this.methods[i] != null && (index = this.propertyNames.indexOf(name = Tools.getPropertyName(this.methods[i].getName()))) >= 0) {
                    to[index] = from.get(i, this.methods[i].getReturnType());
                }
            }
        }
    }

    private class ImmutablePOJOMapper
    implements RecordMapper<R, E> {
        final Constructor<E> constructor;
        final Class<?>[] parameterTypes;
        private final boolean nested;
        private final int[] nonNestedIndexLookup;
        private final NestedMappingInfo[] nestedMappingInfo;

        ImmutablePOJOMapper(Constructor<E> constructor, Class<?>[] parameterTypes, boolean supportsNesting) {
            int size = DefaultRecordMapper.this.prefixes().size();
            this.constructor = Reflect.accessible(constructor);
            this.parameterTypes = parameterTypes;
            this.nestedMappingInfo = new NestedMappingInfo[size];
            this.nonNestedIndexLookup = new int[size];
            int i = -1;
            boolean hasNestedFields = false;
            List[] nestedMappedFields = new List[size];
            if (supportsNesting) {
                block0: for (String prefix : DefaultRecordMapper.this.prefixes()) {
                    ++i;
                    for (int j = 0; j < DefaultRecordMapper.this.fields.length; ++j) {
                        if (DefaultRecordMapper.this.fields[j].getName().equals(prefix)) {
                            this.nonNestedIndexLookup[i] = j;
                            continue block0;
                        }
                        if (!DefaultRecordMapper.this.fields[j].getName().startsWith(prefix + ".")) continue;
                        hasNestedFields = true;
                        if (nestedMappedFields[i] == null) {
                            nestedMappedFields[i] = new ArrayList();
                        }
                        if (this.nestedMappingInfo[i] == null) {
                            this.nestedMappingInfo[i] = new NestedMappingInfo();
                        }
                        nestedMappedFields[i].add(DSL.field(DSL.name(DefaultRecordMapper.this.fields[j].getName().substring(prefix.length() + 1)), DefaultRecordMapper.this.fields[j].getDataType()));
                        this.nestedMappingInfo[i].indexLookup.add(j);
                    }
                    if (nestedMappedFields[i] == null) continue;
                    this.nestedMappingInfo[i].row = Tools.row0(nestedMappedFields[i].toArray(Tools.EMPTY_FIELD));
                    this.nestedMappingInfo[i].recordDelegate = Tools.newRecord(true, Tools.recordType(this.nestedMappingInfo[i].row.size()), this.nestedMappingInfo[i].row, DefaultRecordMapper.this.configuration);
                    this.nestedMappingInfo[i].mappers.add(DefaultRecordMapper.this.configuration.recordMapperProvider().provide(this.nestedMappingInfo[i].row.fields, parameterTypes[i]));
                }
            }
            this.nested = hasNestedFields;
        }

        @Override
        public final E map(R record) {
            try {
                return this.constructor.newInstance(this.nested ? this.mapNested(record) : this.mapNonnested(record));
            }
            catch (Exception e) {
                throw new MappingException("An error ocurred when mapping record to " + DefaultRecordMapper.this.type, e);
            }
        }

        private final Object[] mapNonnested(R record) {
            int i;
            Object[] converted = new Object[this.parameterTypes.length];
            for (i = 0; i < converted.length; ++i) {
                converted[i] = Reflect.initValue(this.parameterTypes[i]);
            }
            for (i = 0; i < record.size(); ++i) {
                this.set((Record)record, converted, i);
            }
            return converted;
        }

        private final Object[] mapNested(final R record) {
            Object[] converted = new Object[DefaultRecordMapper.this.prefixes().size()];
            for (int i = 0; i < converted.length; ++i) {
                if (this.nestedMappingInfo[i] == null) {
                    converted[i] = record.get(this.nonNestedIndexLookup[i], this.parameterTypes[i]);
                    continue;
                }
                final List<Integer> indexLookup = this.nestedMappingInfo[i].indexLookup;
                converted[i] = this.nestedMappingInfo[i].mappers.get(0).map(this.nestedMappingInfo[i].recordDelegate.operate(new RecordOperation<AbstractRecord, RuntimeException>(){

                    @Override
                    public AbstractRecord operate(AbstractRecord rec) {
                        for (int j = 0; j < indexLookup.size(); ++j) {
                            rec.set(j, record.get((Integer)indexLookup.get(j)));
                        }
                        return rec;
                    }
                }));
            }
            return converted;
        }

        void set(Record from, Object[] to, int index) {
            to[index] = from.get(index, this.parameterTypes[index]);
        }
    }

    private class MutablePOJOMapper
    implements RecordMapper<R, E> {
        private final Callable<E> constructor;
        private final boolean useAnnotations;
        private final List<java.lang.reflect.Field>[] members;
        private final List<Method>[] methods;
        private final Map<String, NestedMappingInfo> nestedMappingInfos;
        private final E instance;

        MutablePOJOMapper(Callable<E> constructor, E instance) {
            this.constructor = constructor;
            this.useAnnotations = Tools.hasColumnAnnotations(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type);
            this.members = new List[DefaultRecordMapper.this.fields.length];
            this.methods = new List[DefaultRecordMapper.this.fields.length];
            this.instance = instance;
            this.nestedMappingInfos = new HashMap<String, NestedMappingInfo>();
            HashMap nestedMappedFields = null;
            for (int i = 0; i < DefaultRecordMapper.this.fields.length; ++i) {
                Field field = DefaultRecordMapper.this.fields[i];
                String name = field.getName();
                if (this.useAnnotations) {
                    this.members[i] = Tools.getAnnotatedMembers(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type, name, true);
                    this.methods[i] = Tools.getAnnotatedSetters(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type, name, true);
                    continue;
                }
                int dot = name.indexOf(46);
                if (dot > -1) {
                    NestedMappingInfo nestedMappingInfo;
                    ArrayList f;
                    String prefix = name.substring(0, dot);
                    if (nestedMappedFields == null) {
                        nestedMappedFields = new HashMap();
                    }
                    if ((f = (ArrayList)nestedMappedFields.get(prefix)) == null) {
                        f = new ArrayList();
                        nestedMappedFields.put(prefix, f);
                    }
                    if ((nestedMappingInfo = this.nestedMappingInfos.get(prefix)) == null) {
                        nestedMappingInfo = new NestedMappingInfo();
                        this.nestedMappingInfos.put(prefix, nestedMappingInfo);
                    }
                    f.add(DSL.field(DSL.name(name.substring(prefix.length() + 1)), field.getDataType()));
                    nestedMappingInfo.indexLookup.add(i);
                    this.members[i] = Collections.emptyList();
                    this.methods[i] = Collections.emptyList();
                    continue;
                }
                this.members[i] = Tools.getMatchingMembers(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type, name, true);
                this.methods[i] = Tools.getMatchingSetters(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type, name, true);
            }
            if (nestedMappedFields != null) {
                for (Map.Entry entry : nestedMappedFields.entrySet()) {
                    String prefix = (String)entry.getKey();
                    NestedMappingInfo nestedMappingInfo = this.nestedMappingInfos.get(prefix);
                    nestedMappingInfo.row = Tools.row0((Collection)entry.getValue());
                    nestedMappingInfo.recordDelegate = Tools.newRecord(true, Tools.recordType(nestedMappingInfo.row.size()), nestedMappingInfo.row, DefaultRecordMapper.this.configuration);
                    for (java.lang.reflect.Field member : Tools.getMatchingMembers(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type, prefix, true)) {
                        nestedMappingInfo.mappers.add(DefaultRecordMapper.this.configuration.recordMapperProvider().provide(nestedMappingInfo.row.fields, member.getType()));
                    }
                    for (Method method : Tools.getMatchingSetters(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type, prefix, true)) {
                        nestedMappingInfo.mappers.add(DefaultRecordMapper.this.configuration.recordMapperProvider().provide(nestedMappingInfo.row.fields, method.getParameterTypes()[0]));
                    }
                }
            }
        }

        final boolean isMutable() {
            for (List<Method> list : this.methods) {
                if (list.isEmpty()) continue;
                return true;
            }
            for (List<AccessibleObject> list : this.members) {
                for (java.lang.reflect.Field field : list) {
                    if ((field.getModifiers() & 0x10) != 0) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public final E map(final R record) {
            try {
                final Object result = this.instance != null ? this.instance : this.constructor.call();
                for (int i = 0; i < DefaultRecordMapper.this.fields.length; ++i) {
                    for (java.lang.reflect.Field member : this.members[i]) {
                        if ((member.getModifiers() & 0x10) != 0) continue;
                        this.map((Record)record, result, member, i);
                    }
                    for (Method method : this.methods[i]) {
                        Class<?> mType = method.getParameterTypes()[0];
                        Object value = record.get(i, mType);
                        List<?> list = this.tryConvertToList(value, mType, method.getGenericParameterTypes()[0]);
                        if (list != null) {
                            method.invoke(result, list);
                            continue;
                        }
                        method.invoke(result, record.get(i, mType));
                    }
                }
                for (final Map.Entry<String, NestedMappingInfo> entry : this.nestedMappingInfos.entrySet()) {
                    final String prefix = entry.getKey();
                    for (final RecordMapper<AbstractRecord, Object> mapper : entry.getValue().mappers) {
                        entry.getValue().recordDelegate.operate(new RecordOperation<AbstractRecord, Exception>(){

                            @Override
                            public AbstractRecord operate(AbstractRecord rec) throws Exception {
                                List<Integer> indexes = ((NestedMappingInfo)entry.getValue()).indexLookup;
                                for (int index = 0; index < indexes.size(); ++index) {
                                    rec.set(index, record.get(indexes.get(index)));
                                }
                                Object value = mapper.map(rec);
                                for (java.lang.reflect.Field member : Tools.getMatchingMembers(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type, prefix, true)) {
                                    if ((member.getModifiers() & 0x10) != 0) continue;
                                    MutablePOJOMapper.this.map(value, result, member);
                                }
                                for (Method method : Tools.getMatchingSetters(DefaultRecordMapper.this.configuration, DefaultRecordMapper.this.type, prefix, true)) {
                                    method.invoke(result, value);
                                }
                                return rec;
                            }
                        });
                    }
                }
                return result;
            }
            catch (Exception e) {
                throw new MappingException("An error ocurred when mapping record to " + DefaultRecordMapper.this.type, e);
            }
        }

        private final void map(Record record, Object result, java.lang.reflect.Field member, int index) throws IllegalAccessException {
            Class<?> mType = member.getType();
            if (mType.isPrimitive()) {
                if (mType == Byte.TYPE) {
                    this.map(record.get(index, Byte.TYPE), result, member);
                } else if (mType == Short.TYPE) {
                    this.map(record.get(index, Short.TYPE), result, member);
                } else if (mType == Integer.TYPE) {
                    this.map(record.get(index, Integer.TYPE), result, member);
                } else if (mType == Long.TYPE) {
                    this.map(record.get(index, Long.TYPE), result, member);
                } else if (mType == Float.TYPE) {
                    this.map(record.get(index, Float.TYPE), result, member);
                } else if (mType == Double.TYPE) {
                    this.map(record.get(index, Double.TYPE), result, member);
                } else if (mType == Boolean.TYPE) {
                    this.map(record.get(index, Boolean.TYPE), result, member);
                } else if (mType == Character.TYPE) {
                    this.map(record.get(index, Character.TYPE), result, member);
                }
            } else {
                Object value = record.get(index, mType);
                List<?> list = this.tryConvertToList(value, mType, member.getGenericType());
                if (list != null) {
                    member.set(result, list);
                } else {
                    this.map(value, result, member);
                }
            }
        }

        private final List<?> tryConvertToList(Object value, Class<?> mType, Type genericType) {
            if (value instanceof Collection && (mType == List.class || mType == ArrayList.class) && genericType instanceof ParameterizedType) {
                Class componentType = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                return Convert.convert((Collection)value, componentType);
            }
            return null;
        }

        private final void map(Object value, Object result, java.lang.reflect.Field member) throws IllegalAccessException {
            Class<?> mType = member.getType();
            if (mType.isPrimitive()) {
                if (mType == Byte.TYPE) {
                    member.setByte(result, (Byte)value);
                } else if (mType == Short.TYPE) {
                    member.setShort(result, (Short)value);
                } else if (mType == Integer.TYPE) {
                    member.setInt(result, (Integer)value);
                } else if (mType == Long.TYPE) {
                    member.setLong(result, (Long)value);
                } else if (mType == Float.TYPE) {
                    member.setFloat(result, ((Float)value).floatValue());
                } else if (mType == Double.TYPE) {
                    member.setDouble(result, (Double)value);
                } else if (mType == Boolean.TYPE) {
                    member.setBoolean(result, (Boolean)value);
                } else if (mType == Character.TYPE) {
                    member.setChar(result, ((Character)value).charValue());
                }
            } else {
                member.set(result, value);
            }
        }
    }

    private static final class ConstructorCall<E>
    implements Callable<E> {
        private final Constructor<? extends E> constructor;

        ConstructorCall(Constructor<? extends E> constructor) {
            this.constructor = constructor;
        }

        @Override
        public E call() throws Exception {
            return this.constructor.newInstance(new Object[0]);
        }
    }

    private class RecordToRecordMapper
    implements RecordMapper<R, AbstractRecord> {
        private RecordToRecordMapper() {
        }

        @Override
        public final AbstractRecord map(R record) {
            try {
                if (record instanceof AbstractRecord) {
                    return (AbstractRecord)((AbstractRecord)record).intoRecord(DefaultRecordMapper.this.type);
                }
                throw new MappingException("Cannot map record " + record + " to type " + DefaultRecordMapper.this.type);
            }
            catch (Exception e) {
                throw new MappingException("An error ocurred when mapping record to " + DefaultRecordMapper.this.type, e);
            }
        }
    }

    private class ProxyMapper
    implements RecordMapper<R, E> {
        private Constructor<MethodHandles.Lookup> constructor;
        private final MutablePOJOMapper pojomapper;

        ProxyMapper() {
            this.pojomapper = new MutablePOJOMapper(new Callable<E>(){

                @Override
                public E call() throws Exception {
                    return ProxyMapper.this.proxy();
                }
            }, null);
        }

        @Override
        public final E map(R record) {
            return this.pojomapper.map(record);
        }

        private E proxy() {
            final Object[] result = new Object[1];
            final HashMap map = new HashMap();
            InvocationHandler handler = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) {
                    int length;
                    String name = method.getName();
                    int n = length = args == null ? 0 : args.length;
                    if (length == 0 && name.startsWith("get")) {
                        return map.get(name.substring(3));
                    }
                    if (length == 0 && name.startsWith("is")) {
                        return map.get(name.substring(2));
                    }
                    if (length == 1 && name.startsWith("set")) {
                        map.put(name.substring(3), args[0]);
                    } else if (method.isDefault()) {
                        try {
                            if (ProxyMapper.this.constructor == null) {
                                ProxyMapper.this.constructor = Reflect.accessible(MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE));
                            }
                            Class<?> declaringClass = method.getDeclaringClass();
                            return ((MethodHandles.Lookup)ProxyMapper.this.constructor.newInstance(declaringClass, 2)).unreflectSpecial(method, declaringClass).bindTo(result[0]).invokeWithArguments(args);
                        }
                        catch (Throwable e) {
                            throw new MappingException("Cannot invoke default method", e);
                        }
                    }
                    return null;
                }
            };
            result[0] = Proxy.newProxyInstance(DefaultRecordMapper.this.type.getClassLoader(), new Class[]{DefaultRecordMapper.this.type}, handler);
            return result[0];
        }
    }

    private class ValueTypeMapper
    implements RecordMapper<R, E> {
        private ValueTypeMapper() {
        }

        @Override
        public final E map(R record) {
            int size = record.size();
            if (size != 1) {
                throw new MappingException("Cannot map multi-column record of degree " + size + " to value type " + DefaultRecordMapper.this.type);
            }
            return record.get(0, DefaultRecordMapper.this.type);
        }
    }

    private class ArrayMapper
    implements RecordMapper<R, E> {
        private final E instance;

        ArrayMapper(E instance) {
            this.instance = instance;
        }

        @Override
        public final E map(R record) {
            int size = record.size();
            Class<?> componentType = DefaultRecordMapper.this.type.getComponentType();
            Object[] result = (Object[])(this.instance != null ? this.instance : Array.newInstance(componentType, size));
            if (size > result.length) {
                result = (Object[])Array.newInstance(componentType, size);
            }
            for (int i = 0; i < size; ++i) {
                result[i] = Convert.convert(record.get(i), componentType);
            }
            return result;
        }
    }
}

