/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.DataType;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.Keyword;
import com.craftaro.third_party.org.jooq.impl.AbstractField;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.Keywords;
import com.craftaro.third_party.org.jooq.impl.Names;
import com.craftaro.third_party.org.jooq.impl.Tools;

final class DateOrTime<T>
extends AbstractField<T> {
    private static final long serialVersionUID = -6729613078727690134L;
    private final Field<?> field;

    DateOrTime(Field<?> field, DataType<T> dataType) {
        super(DSL.name(DateOrTime.name(dataType)), dataType);
        this.field = field;
    }

    private static String name(DataType<?> dataType) {
        return dataType.isDate() ? "date" : (dataType.isTime() ? "time" : "timestamp");
    }

    private static Keyword keyword(DataType<?> dataType) {
        return dataType.isDate() ? Keywords.K_DATE : (dataType.isTime() ? Keywords.K_TIME : Keywords.K_TIMESTAMP);
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case MYSQL: 
            case MARIADB: {
                ctx.visit(DateOrTime.keyword(this.getDataType())).sql('(').visit(this.field).sql(')');
                break;
            }
            case SQLITE: {
                if (this.getDataType().isDate()) {
                    ctx.visit(Keywords.K_DATE).sql('(').visit(this.field).sql(')');
                    break;
                }
                if (this.getDataType().isTime()) {
                    ctx.visit(Keywords.K_TIME).sql('(').visit(this.field).sql(')');
                    break;
                }
                ctx.visit(Names.N_STRFTIME).sql("('%Y-%m-%d %H:%M:%f', ").visit(this.field).sql(')');
                break;
            }
            default: {
                ctx.visit(Tools.castIfNeeded(this.field, this.getDataType()));
            }
        }
    }
}

