/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Clause;
import com.craftaro.third_party.org.jooq.Configuration;
import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.CreateViewAsStep;
import com.craftaro.third_party.org.jooq.CreateViewFinalStep;
import com.craftaro.third_party.org.jooq.DSLContext;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.QueryPart;
import com.craftaro.third_party.org.jooq.Record;
import com.craftaro.third_party.org.jooq.ResultQuery;
import com.craftaro.third_party.org.jooq.SQL;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.Select;
import com.craftaro.third_party.org.jooq.Table;
import com.craftaro.third_party.org.jooq.conf.ParamType;
import com.craftaro.third_party.org.jooq.impl.AbstractRowCountQuery;
import com.craftaro.third_party.org.jooq.impl.DDLStatementType;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.Keywords;
import com.craftaro.third_party.org.jooq.impl.QueryPartListView;
import com.craftaro.third_party.org.jooq.impl.Tools;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;

final class CreateViewImpl<R extends Record>
extends AbstractRowCountQuery
implements CreateViewAsStep<R>,
CreateViewFinalStep {
    private static final long serialVersionUID = 8904572826501186329L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.CREATE_VIEW};
    private static final Set<SQLDialect> NO_SUPPORT_IF_NOT_EXISTS = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.POSTGRES);
    private final boolean ifNotExists;
    private final boolean orReplace;
    private final Table<?> view;
    private final BiFunction<? super Field<?>, ? super Integer, ? extends Field<?>> fieldNameFunction;
    private Field<?>[] fields;
    private ResultQuery<?> select;
    private transient Select<?> parsed;

    CreateViewImpl(Configuration configuration, Table<?> view, Field<?>[] fields, boolean ifNotExists, boolean orReplace) {
        super(configuration);
        this.view = view;
        this.fields = fields;
        this.fieldNameFunction = null;
        this.ifNotExists = ifNotExists;
        this.orReplace = orReplace;
    }

    CreateViewImpl(Configuration configuration, Table<?> view, BiFunction<? super Field<?>, ? super Integer, ? extends Field<?>> fieldNameFunction, boolean ifNotExists, boolean orReplace) {
        super(configuration);
        this.view = view;
        this.fields = null;
        this.fieldNameFunction = fieldNameFunction;
        this.ifNotExists = ifNotExists;
        this.orReplace = orReplace;
    }

    final boolean $ifNotExists() {
        return this.ifNotExists;
    }

    final boolean $orReplace() {
        return this.orReplace;
    }

    final Table<?> $view() {
        return this.view;
    }

    final Field<?>[] $fields() {
        return this.fields;
    }

    final Select<?> $select() {
        return this.parsed();
    }

    @Override
    public final CreateViewFinalStep as(Select<? extends R> s) {
        this.select = s;
        if (this.fieldNameFunction != null) {
            List<Field<?>> source = s.getSelect();
            this.fields = new Field[source.size()];
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i] = this.fieldNameFunction.apply(source.get(i), i);
            }
        }
        return this;
    }

    @Override
    public final CreateViewFinalStep as(SQL sql) {
        this.select = DSL.resultQuery(sql);
        if (this.fieldNameFunction != null) {
            Select<?> s = this.parsed();
            List<Field<?>> source = s.getSelect();
            this.fields = new Field[source.size()];
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i] = this.fieldNameFunction.apply(source.get(i), i);
            }
        }
        return this;
    }

    @Override
    public final CreateViewFinalStep as(String sql) {
        return this.as(DSL.sql(sql));
    }

    @Override
    public final CreateViewFinalStep as(String sql, Object ... bindings) {
        return this.as(DSL.sql(sql, bindings));
    }

    @Override
    public final CreateViewFinalStep as(String sql, QueryPart ... parts) {
        return this.as(DSL.sql(sql, parts));
    }

    private final boolean supportsIfNotExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_NOT_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifNotExists && !this.supportsIfNotExists(ctx)) {
            Tools.beginTryCatch(ctx, DDLStatementType.CREATE_VIEW);
            this.accept0(ctx);
            Tools.endTryCatch(ctx, DDLStatementType.CREATE_VIEW);
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        QueryPart[] f = this.fields;
        boolean rename = f != null && f.length > 0;
        boolean renameSupported = true;
        boolean replaceSupported = false;
        ParamType paramType = ctx.paramType();
        ctx.start(Clause.CREATE_VIEW_NAME).visit(replaceSupported && this.orReplace ? Keywords.K_REPLACE : Keywords.K_CREATE);
        if (this.orReplace && !replaceSupported) {
            ctx.sql(' ').visit(Keywords.K_OR);
            switch (ctx.family()) {
                case FIREBIRD: {
                    ctx.sql(' ').visit(Keywords.K_ALTER);
                    break;
                }
                default: {
                    ctx.sql(' ').visit(Keywords.K_REPLACE);
                }
            }
        }
        ctx.sql(' ').visit(Keywords.K_VIEW).sql(' ');
        if (this.ifNotExists && this.supportsIfNotExists(ctx)) {
            ctx.visit(Keywords.K_IF_NOT_EXISTS).sql(' ');
        }
        ctx.visit(this.view);
        if (rename && renameSupported) {
            boolean qualify = ctx.qualify();
            ctx.sql('(').qualify(false).visit(QueryPartListView.wrap((QueryPart[])f)).qualify(qualify).sql(')');
        }
        ctx.end(Clause.CREATE_VIEW_NAME).formatSeparator().visit(Keywords.K_AS).formatSeparator().start(Clause.CREATE_VIEW_AS).paramType(ParamType.INLINED).visit(rename && !renameSupported ? DSL.selectFrom(this.parsed().asTable(DSL.name("t"), Tools.fieldNames(f))) : this.select).paramType(paramType).end(Clause.CREATE_VIEW_AS);
    }

    private final Select<?> parsed() {
        if (this.parsed != null) {
            return this.parsed;
        }
        if (this.select instanceof Select) {
            this.parsed = (Select)this.select;
            return this.parsed;
        }
        DSLContext dsl = this.configuration().dsl();
        return dsl.parser().parseSelect(dsl.renderInlined(this.select));
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

