/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Check;
import com.craftaro.third_party.org.jooq.ForeignKey;
import com.craftaro.third_party.org.jooq.Index;
import com.craftaro.third_party.org.jooq.Key;
import com.craftaro.third_party.org.jooq.Named;
import com.craftaro.third_party.org.jooq.SortField;
import com.craftaro.third_party.org.jooq.TableField;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.tools.StringUtils;
import java.util.Comparator;
import java.util.List;

final class Comparators {
    static final Comparator<Named> NAMED_COMP = new NamedComparator();
    static final Comparator<Key<?>> KEY_COMP = new KeyComparator();
    static final Comparator<ForeignKey<?, ?>> FOREIGN_KEY_COMP = new ForeignKeyComparator();
    static final Comparator<Check<?>> CHECK_COMP = new CheckComparator();
    static final Comparator<Index> INDEX_COMP = new IndexComparator();

    Comparators() {
    }

    private static final class IndexComparator
    implements Comparator<Index> {
        private IndexComparator() {
        }

        @Override
        public int compare(Index o1, Index o2) {
            int c2 = Boolean.valueOf(o1.getUnique()).compareTo(o2.getUnique());
            if (c2 != 0) {
                return c2;
            }
            c2 = StringUtils.defaultIfNull(o1.getWhere(), DSL.noCondition()).toString().compareTo(StringUtils.defaultIfNull(o2.getWhere(), DSL.noCondition()).toString());
            if (c2 != 0) {
                return c2;
            }
            List<SortField<?>> f1 = o1.getFields();
            List<SortField<?>> f2 = o2.getFields();
            c2 = f1.size() - f2.size();
            if (c2 != 0) {
                return c2;
            }
            for (int i = 0; i < f1.size(); ++i) {
                SortField<?> s1 = f1.get(i);
                SortField<?> s2 = f2.get(i);
                c2 = s1.getName().compareTo(s2.getName());
                if (c2 != 0) {
                    return c2;
                }
                c2 = s1.getOrder().compareTo(s2.getOrder());
                if (c2 == 0) continue;
                return c2;
            }
            return 0;
        }
    }

    private static final class CheckComparator
    implements Comparator<Check<?>> {
        private CheckComparator() {
        }

        @Override
        public int compare(Check<?> o1, Check<?> o2) {
            return o1.condition().toString().compareTo(o2.condition().toString());
        }
    }

    private static final class ForeignKeyComparator
    implements Comparator<ForeignKey<?, ?>> {
        private ForeignKeyComparator() {
        }

        @Override
        public int compare(ForeignKey<?, ?> o1, ForeignKey<?, ?> o2) {
            int c2 = KEY_COMP.compare(o1, o2);
            if (c2 != 0) {
                return c2;
            }
            return KEY_COMP.compare(o1.getKey(), o2.getKey());
        }
    }

    private static final class KeyComparator
    implements Comparator<Key<?>> {
        private KeyComparator() {
        }

        @Override
        public int compare(Key<?> o1, Key<?> o2) {
            List<TableField<?, ?>> f1 = o1.getFields();
            List<TableField<?, ?>> f2 = o2.getFields();
            int c2 = f1.size() - f2.size();
            if (c2 != 0) {
                return c2;
            }
            for (int i = 0; i < f1.size(); ++i) {
                c2 = NAMED_COMP.compare(f1.get(i), f2.get(i));
                if (c2 == 0) continue;
                return c2;
            }
            return 0;
        }
    }

    private static final class NamedComparator
    implements Comparator<Named> {
        private NamedComparator() {
        }

        @Override
        public final int compare(Named o1, Named o2) {
            return o1.getQualifiedName().compareTo(o2.getQualifiedName());
        }
    }
}

