/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.CommonTableExpression;
import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.Record;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.Select;
import com.craftaro.third_party.org.jooq.TableOptions;
import com.craftaro.third_party.org.jooq.impl.AbstractTable;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.DerivedColumnListImpl;
import com.craftaro.third_party.org.jooq.impl.Fields;
import com.craftaro.third_party.org.jooq.impl.Keywords;
import com.craftaro.third_party.org.jooq.impl.Tools;
import java.util.List;
import java.util.Set;

final class CommonTableExpressionImpl<R extends Record>
extends AbstractTable<R>
implements CommonTableExpression<R> {
    private static final long serialVersionUID = 2520235151216758958L;
    private static final Set<SQLDialect> SUPPORT_MATERIALIZED = SQLDialect.supportedBy(SQLDialect.POSTGRES);
    private final DerivedColumnListImpl name;
    private final Select<R> select;
    private final Fields<R> fields;
    private final Boolean materialized;

    CommonTableExpressionImpl(DerivedColumnListImpl name, Select<R> select, Boolean materialized) {
        super(TableOptions.expression(), name.name);
        this.name = name;
        this.select = select;
        this.fields = this.fields1();
        this.materialized = materialized;
    }

    @Override
    public final Class<? extends R> getRecordType() {
        return this.select.getRecordType();
    }

    @Override
    public final boolean declaresCTE() {
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (ctx.declareCTE()) {
            ctx.visit(this.name).sql(' ').visit(Keywords.K_AS).sql(' ');
            Object previous = null;
            if (this.materialized != null && SUPPORT_MATERIALIZED.contains((Object)ctx.dialect())) {
                if (this.materialized.booleanValue()) {
                    ctx.visit(Keywords.K_MATERIALIZED).sql(' ');
                } else {
                    ctx.visit(Keywords.K_NOT).sql(' ').visit(Keywords.K_MATERIALIZED).sql(' ');
                }
            }
            Tools.visitSubquery(ctx, this.select, true);
        } else {
            ctx.visit(DSL.name(this.name.name));
        }
    }

    @Override
    final Fields<R> fields0() {
        return this.fields;
    }

    final Fields<R> fields1() {
        List<Field<?>> s = this.select.getSelect();
        Field[] f = new Field[Tools.degree(this.select)];
        for (int i = 0; i < f.length; ++i) {
            f[i] = DSL.field(DSL.name(this.name.name, this.name.fieldNames.length > 0 ? this.name.fieldNames[i] : s.get(i).getUnqualifiedName()), f.length == 1 ? Tools.scalarType(this.select) : s.get(i).getDataType());
        }
        return new Fields(f);
    }
}

