/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.BetweenAndStep;
import com.craftaro.third_party.org.jooq.Clause;
import com.craftaro.third_party.org.jooq.Condition;
import com.craftaro.third_party.org.jooq.Configuration;
import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.QueryPartInternal;
import com.craftaro.third_party.org.jooq.RowN;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.impl.AbstractCondition;
import com.craftaro.third_party.org.jooq.impl.AbstractQueryPart;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.Keywords;
import com.craftaro.third_party.org.jooq.impl.Tools;
import java.util.Set;

final class BetweenCondition<T>
extends AbstractCondition
implements BetweenAndStep<T> {
    private static final long serialVersionUID = -4666251100802237878L;
    private static final Clause[] CLAUSES_BETWEEN = new Clause[]{Clause.CONDITION, Clause.CONDITION_BETWEEN};
    private static final Clause[] CLAUSES_BETWEEN_SYMMETRIC = new Clause[]{Clause.CONDITION, Clause.CONDITION_BETWEEN_SYMMETRIC};
    private static final Clause[] CLAUSES_NOT_BETWEEN = new Clause[]{Clause.CONDITION, Clause.CONDITION_NOT_BETWEEN};
    private static final Clause[] CLAUSES_NOT_BETWEEN_SYMMETRIC = new Clause[]{Clause.CONDITION, Clause.CONDITION_NOT_BETWEEN_SYMMETRIC};
    private static final Set<SQLDialect> NO_SUPPORT_SYMMETRIC = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE);
    private final boolean symmetric;
    private final boolean not;
    private final Field<T> field;
    private final Field<T> minValue;
    private Field<T> maxValue;

    BetweenCondition(Field<T> field, Field<T> minValue, boolean not, boolean symmetric) {
        this.field = field;
        this.minValue = minValue;
        this.not = not;
        this.symmetric = symmetric;
    }

    @Override
    public final Condition and(T value) {
        return this.and((Field)DSL.val(value, this.field.getDataType()));
    }

    @Override
    public final Condition and(Field f) {
        if (this.maxValue == null) {
            this.maxValue = DSL.nullSafe(f, this.field.getDataType());
            return this;
        }
        return super.and(f);
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(this.delegate(ctx.configuration()));
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }

    private final QueryPartInternal delegate(Configuration configuration) {
        if (this.field.getDataType().isEmbeddable() && this.minValue.getDataType().isEmbeddable() && this.maxValue.getDataType().isEmbeddable()) {
            RowN f = DSL.row(Tools.embeddedFields(this.field));
            RowN min = DSL.row(Tools.embeddedFields(this.minValue));
            RowN max = DSL.row(Tools.embeddedFields(this.maxValue));
            return (QueryPartInternal)((Object)(this.not ? (this.symmetric ? f.notBetweenSymmetric(min).and(max) : f.notBetween(min).and(max)) : (this.symmetric ? f.betweenSymmetric(min).and(max) : f.between(min).and(max))));
        }
        if (this.symmetric && NO_SUPPORT_SYMMETRIC.contains((Object)configuration.dialect())) {
            return (QueryPartInternal)((Object)(this.not ? this.field.notBetween(this.minValue, this.maxValue).and(this.field.notBetween(this.maxValue, this.minValue)) : this.field.between(this.minValue, this.maxValue).or(this.field.between(this.maxValue, this.minValue))));
        }
        return new Native();
    }

    private class Native
    extends AbstractQueryPart {
        private static final long serialVersionUID = 2915703568738921575L;

        private Native() {
        }

        @Override
        public final void accept(Context<?> ctx) {
            ctx.visit(BetweenCondition.this.field);
            if (BetweenCondition.this.not) {
                ctx.sql(' ').visit(Keywords.K_NOT);
            }
            ctx.sql(' ').visit(Keywords.K_BETWEEN);
            if (BetweenCondition.this.symmetric) {
                ctx.sql(' ').visit(Keywords.K_SYMMETRIC);
            }
            ctx.sql(' ').visit(BetweenCondition.this.minValue);
            ctx.sql(' ').visit(Keywords.K_AND);
            ctx.sql(' ').visit(BetweenCondition.this.maxValue);
        }

        @Override
        public final Clause[] clauses(Context<?> ctx) {
            return BetweenCondition.this.not ? (BetweenCondition.this.symmetric ? CLAUSES_NOT_BETWEEN_SYMMETRIC : CLAUSES_NOT_BETWEEN) : (BetweenCondition.this.symmetric ? CLAUSES_BETWEEN_SYMMETRIC : CLAUSES_BETWEEN);
        }
    }
}

