/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.impl.AbstractField;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.Names;
import com.craftaro.third_party.org.jooq.impl.SQLDataType;
import com.craftaro.third_party.org.jooq.tools.StringUtils;

final class ArrayGet<T>
extends AbstractField<T> {
    private static final long serialVersionUID = 1852008882778358276L;
    private final Field<T[]> field;
    private final Field<Integer> index;

    ArrayGet(Field<T[]> field, Field<Integer> index) {
        super(Names.N_ARRAY_GET, StringUtils.defaultIfNull(field.getDataType().getArrayComponentDataType(), SQLDataType.OTHER));
        this.field = field;
        this.index = index;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case H2: {
                ctx.visit(Names.N_ARRAY_GET).sql('(').visit(this.field).sql(", ").visit(this.index).sql(')');
                break;
            }
            case HSQLDB: {
                ctx.visit(DSL.when(DSL.cardinality(this.field).ge(this.index), new Standard()));
                break;
            }
            default: {
                ctx.visit(new Standard());
            }
        }
    }

    private class Standard
    extends AbstractField<T> {
        private static final long serialVersionUID = 7727869539823288556L;

        Standard() {
            super(ArrayGet.this.getQualifiedName(), ArrayGet.this.getDataType());
        }

        @Override
        public void accept(Context<?> ctx) {
            ctx.sql('(').visit(ArrayGet.this.field).sql(')').sql('[').visit(ArrayGet.this.index).sql(']');
        }
    }
}

