/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.CharacterSet;
import com.craftaro.third_party.org.jooq.Collation;
import com.craftaro.third_party.org.jooq.Configuration;
import com.craftaro.third_party.org.jooq.DataType;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.Nullability;
import com.craftaro.third_party.org.jooq.impl.DefaultDataType;

final class ArrayDataType<T>
extends DefaultDataType<T[]> {
    private static final long serialVersionUID = 7883229760246533448L;
    final DataType<T> elementType;

    public ArrayDataType(DataType<T> elementType) {
        super(null, elementType.getArrayType(), elementType.getTypeName(), elementType.getCastTypeName());
        this.elementType = elementType;
    }

    ArrayDataType(DefaultDataType<T[]> t, DataType<T> elementType, Integer precision, Integer scale, Integer length, Nullability nullability, Collation collation, CharacterSet characterSet, boolean identity, Field<T[]> defaultValue) {
        super(t, precision, scale, length, nullability, collation, characterSet, identity, defaultValue);
        this.elementType = elementType;
    }

    @Override
    DefaultDataType<T[]> construct(Integer newPrecision, Integer newScale, Integer newLength, Nullability newNullability, Collation newCollation, CharacterSet newCharacterSet, boolean newIdentity, Field<T[]> newDefaultValue) {
        return new ArrayDataType<T>(this, (DefaultDataType)this.elementType, newPrecision, newScale, newLength, newNullability, newCollation, newCharacterSet, newIdentity, newDefaultValue);
    }

    @Override
    public final String getTypeName(Configuration configuration) {
        String typeName = this.elementType.getTypeName(configuration);
        return ArrayDataType.getArrayType(configuration, typeName);
    }

    @Override
    public final String getCastTypeName(Configuration configuration) {
        String castTypeName = this.elementType.getCastTypeName(configuration);
        return ArrayDataType.getArrayType(configuration, castTypeName);
    }

    @Override
    public final Class<?> getArrayComponentType() {
        return this.elementType.getType();
    }

    @Override
    public final DataType<?> getArrayComponentDataType() {
        return this.elementType;
    }

    private static String getArrayType(Configuration configuration, String dataType) {
        switch (configuration.family()) {
            case HSQLDB: {
                return dataType + " array";
            }
            case POSTGRES: {
                return dataType + "[]";
            }
            case H2: {
                return "array";
            }
        }
        return dataType + "[]";
    }
}

