/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.AlterTableAddStep;
import com.craftaro.third_party.org.jooq.AlterTableAlterStep;
import com.craftaro.third_party.org.jooq.AlterTableDropStep;
import com.craftaro.third_party.org.jooq.AlterTableFinalStep;
import com.craftaro.third_party.org.jooq.AlterTableRenameColumnToStep;
import com.craftaro.third_party.org.jooq.AlterTableRenameConstraintToStep;
import com.craftaro.third_party.org.jooq.AlterTableRenameIndexToStep;
import com.craftaro.third_party.org.jooq.AlterTableStep;
import com.craftaro.third_party.org.jooq.AlterTableUsingIndexStep;
import com.craftaro.third_party.org.jooq.Clause;
import com.craftaro.third_party.org.jooq.Comment;
import com.craftaro.third_party.org.jooq.Configuration;
import com.craftaro.third_party.org.jooq.Constraint;
import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.DataType;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.FieldOrConstraint;
import com.craftaro.third_party.org.jooq.Index;
import com.craftaro.third_party.org.jooq.Name;
import com.craftaro.third_party.org.jooq.Nullability;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.Table;
import com.craftaro.third_party.org.jooq.impl.AbstractRowCountQuery;
import com.craftaro.third_party.org.jooq.impl.Cascade;
import com.craftaro.third_party.org.jooq.impl.ConstraintType;
import com.craftaro.third_party.org.jooq.impl.DDLStatementType;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.Keywords;
import com.craftaro.third_party.org.jooq.impl.QueryPartList;
import com.craftaro.third_party.org.jooq.impl.Tools;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

final class AlterTableImpl
extends AbstractRowCountQuery
implements AlterTableStep,
AlterTableAddStep,
AlterTableDropStep,
AlterTableAlterStep,
AlterTableUsingIndexStep,
AlterTableRenameColumnToStep,
AlterTableRenameIndexToStep,
AlterTableRenameConstraintToStep {
    private static final long serialVersionUID = 8904572826501186329L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.ALTER_TABLE};
    private static final Set<SQLDialect> NO_SUPPORT_IF_EXISTS = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.MARIADB);
    private static final Set<SQLDialect> NO_SUPPORT_IF_EXISTS_COLUMN = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD);
    private static final Set<SQLDialect> NO_SUPPORT_IF_EXISTS_CONSTRAINT = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD);
    private static final Set<SQLDialect> NO_SUPPORT_IF_NOT_EXISTS_COLUMN = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD);
    private static final Set<SQLDialect> SUPPORT_RENAME_COLUMN = SQLDialect.supportedBy(SQLDialect.DERBY);
    private static final Set<SQLDialect> SUPPORT_RENAME_TABLE = SQLDialect.supportedBy(SQLDialect.DERBY);
    private static final Set<SQLDialect> NO_SUPPORT_RENAME_QUALIFIED_TABLE = SQLDialect.supportedBy(SQLDialect.POSTGRES);
    private static final Set<SQLDialect> NO_SUPPORT_ALTER_TYPE_AND_NULL = SQLDialect.supportedBy(SQLDialect.POSTGRES);
    private static final Set<SQLDialect> NO_SUPPORT_DROP_CONSTRAINT = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    private static final Set<SQLDialect> REQUIRE_REPEAT_ADD_ON_MULTI_ALTER = SQLDialect.supportedBy(SQLDialect.FIREBIRD, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES);
    private static final Set<SQLDialect> REQUIRE_REPEAT_DROP_ON_MULTI_ALTER = SQLDialect.supportedBy(SQLDialect.FIREBIRD, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES);
    private final Table<?> table;
    private final boolean ifExists;
    private boolean ifExistsColumn;
    private boolean ifExistsConstraint;
    private boolean ifNotExistsColumn;
    private Comment comment;
    private Table<?> renameTo;
    private Field<?> renameColumn;
    private Field<?> renameColumnTo;
    private Index renameIndex;
    private Index renameIndexTo;
    private Constraint renameConstraint;
    private Constraint renameConstraintTo;
    private QueryPartList<FieldOrConstraint> add;
    private Field<?> addColumn;
    private DataType<?> addColumnType;
    private Constraint addConstraint;
    private boolean addFirst;
    private Field<?> addBefore;
    private Field<?> addAfter;
    private Field<?> alterColumn;
    private Nullability alterColumnNullability;
    private DataType<?> alterColumnType;
    private Field<?> alterColumnDefault;
    private boolean alterColumnDropDefault;
    private QueryPartList<Field<?>> dropColumns;
    private Constraint dropConstraint;
    private ConstraintType dropConstraintType;
    private Cascade dropCascade;

    AlterTableImpl(Configuration configuration, Table<?> table) {
        this(configuration, table, false);
    }

    AlterTableImpl(Configuration configuration, Table<?> table, boolean ifExists) {
        super(configuration);
        this.table = table;
        this.ifExists = ifExists;
    }

    final Table<?> $table() {
        return this.table;
    }

    final boolean $ifExists() {
        return this.ifExists;
    }

    final boolean $ifExistsColumn() {
        return this.ifExistsColumn;
    }

    final boolean $ifExistsConstraint() {
        return this.ifExistsConstraint;
    }

    final boolean $ifNotExistsColumn() {
        return this.ifNotExistsColumn;
    }

    final List<FieldOrConstraint> $add() {
        return this.add;
    }

    final Field<?> $addColumn() {
        return this.addColumn;
    }

    final DataType<?> $addColumnType() {
        return this.addColumnType;
    }

    final Constraint $addConstraint() {
        return this.addConstraint;
    }

    final boolean $addFirst() {
        return this.addFirst;
    }

    final Field<?> $addBefore() {
        return this.addBefore;
    }

    final Field<?> $addAfter() {
        return this.addAfter;
    }

    final Field<?> $alterColumn() {
        return this.alterColumn;
    }

    final Nullability $alterColumnNullability() {
        return this.alterColumnNullability;
    }

    final DataType<?> $alterColumnType() {
        return this.alterColumnType;
    }

    final Field<?> $alterColumnDefault() {
        return this.alterColumnDefault;
    }

    final boolean $alterColumnDropDefault() {
        return this.alterColumnDropDefault;
    }

    final Table<?> $renameTo() {
        return this.renameTo;
    }

    final Field<?> $renameColumn() {
        return this.renameColumn;
    }

    final Field<?> $renameColumnTo() {
        return this.renameColumnTo;
    }

    final Constraint $renameConstraint() {
        return this.renameConstraint;
    }

    final Constraint $renameConstraintTo() {
        return this.renameConstraintTo;
    }

    final List<Field<?>> $dropColumns() {
        return this.dropColumns;
    }

    final Cascade $dropCascade() {
        return this.dropCascade;
    }

    final Constraint $dropConstraint() {
        return this.dropConstraint;
    }

    final ConstraintType $dropConstraintType() {
        return this.dropConstraintType;
    }

    @Override
    public final AlterTableImpl comment(String c2) {
        return this.comment(DSL.comment(c2));
    }

    @Override
    public final AlterTableImpl comment(Comment c2) {
        this.comment = c2;
        return this;
    }

    @Override
    public final AlterTableImpl renameTo(Table<?> newName) {
        this.renameTo = newName;
        return this;
    }

    @Override
    public final AlterTableImpl renameTo(Name newName) {
        return this.renameTo((Table)DSL.table(newName));
    }

    @Override
    public final AlterTableImpl renameTo(String newName) {
        return this.renameTo(DSL.name(newName));
    }

    @Override
    public final AlterTableImpl renameColumn(Field<?> oldName) {
        this.renameColumn = oldName;
        return this;
    }

    @Override
    public final AlterTableImpl renameColumn(Name oldName) {
        return this.renameColumn((Field)DSL.field(oldName));
    }

    @Override
    public final AlterTableImpl renameColumn(String oldName) {
        return this.renameColumn(DSL.name(oldName));
    }

    @Override
    public final AlterTableImpl renameConstraint(Constraint oldName) {
        this.renameConstraint = oldName;
        return this;
    }

    @Override
    public final AlterTableImpl renameIndex(String oldName) {
        return this.renameIndex(DSL.name(oldName));
    }

    @Override
    public final AlterTableImpl renameIndex(Name oldName) {
        return this.renameIndex(DSL.index(oldName));
    }

    @Override
    public final AlterTableImpl renameIndex(Index oldName) {
        this.renameIndex = oldName;
        return this;
    }

    @Override
    public final AlterTableImpl renameConstraint(Name oldName) {
        return this.renameConstraint(DSL.constraint(oldName));
    }

    @Override
    public final AlterTableImpl renameConstraint(String oldName) {
        return this.renameConstraint(DSL.name(oldName));
    }

    @Override
    public final AlterTableImpl to(String newName) {
        return this.to(DSL.name(newName));
    }

    @Override
    public final AlterTableImpl to(Name newName) {
        if (this.renameColumn != null) {
            return this.to((Field)DSL.field(newName));
        }
        if (this.renameConstraint != null) {
            return this.to(DSL.constraint(newName));
        }
        if (this.renameIndex != null) {
            return this.to(DSL.index(newName));
        }
        throw new IllegalStateException();
    }

    @Override
    public final AlterTableImpl to(Field<?> newName) {
        if (this.renameColumn == null) {
            throw new IllegalStateException();
        }
        this.renameColumnTo = newName;
        return this;
    }

    @Override
    public final AlterTableImpl to(Constraint newName) {
        if (this.renameConstraint == null) {
            throw new IllegalStateException();
        }
        this.renameConstraintTo = newName;
        return this;
    }

    @Override
    public final AlterTableImpl to(Index newName) {
        if (this.renameIndex == null) {
            throw new IllegalStateException();
        }
        this.renameIndexTo = newName;
        return this;
    }

    @Override
    public final AlterTableImpl add(Field<?> field) {
        return this.addColumn((Field)field);
    }

    @Override
    public final AlterTableImpl add(FieldOrConstraint ... fields) {
        return this.add(Arrays.asList(fields));
    }

    @Override
    public final AlterTableImpl add(Collection<? extends FieldOrConstraint> fields) {
        if (fields.size() == 1) {
            FieldOrConstraint first = fields.iterator().next();
            if (first instanceof Field) {
                return this.add((Field)first);
            }
            if (first instanceof Constraint) {
                return this.add((Constraint)first);
            }
        }
        this.add = new QueryPartList<FieldOrConstraint>((Iterable<? extends FieldOrConstraint>)fields);
        return this;
    }

    @Override
    public final <T> AlterTableImpl add(Field<T> field, DataType<T> type) {
        return this.addColumn((Field)field, (DataType)type);
    }

    @Override
    public final AlterTableImpl add(Name field, DataType<?> type) {
        return this.addColumn(field, (DataType)type);
    }

    @Override
    public final AlterTableImpl add(String field, DataType<?> type) {
        return this.addColumn(field, (DataType)type);
    }

    @Override
    public final AlterTableImpl addIfNotExists(Field<?> field) {
        return this.addColumnIfNotExists((Field)field);
    }

    @Override
    public final <T> AlterTableImpl addIfNotExists(Field<T> field, DataType<T> type) {
        return this.addColumnIfNotExists((Field)field, (DataType)type);
    }

    @Override
    public final AlterTableImpl addIfNotExists(Name field, DataType<?> type) {
        return this.addColumnIfNotExists(field, (DataType)type);
    }

    @Override
    public final AlterTableImpl addIfNotExists(String field, DataType<?> type) {
        return this.addColumnIfNotExists(field, (DataType)type);
    }

    @Override
    public final AlterTableImpl addColumn(String field, DataType<?> type) {
        return this.addColumn(DSL.name(field), (DataType)type);
    }

    @Override
    public final AlterTableImpl addColumn(Name field, DataType<?> type) {
        return this.addColumn((Field)DSL.field(field, type), (DataType)type);
    }

    @Override
    public final AlterTableImpl addColumn(Field<?> field) {
        return this.addColumn((Field)field, field.getDataType());
    }

    @Override
    public final <T> AlterTableImpl addColumn(Field<T> field, DataType<T> type) {
        this.addColumn = field;
        this.addColumnType = type;
        return this;
    }

    @Override
    public final AlterTableImpl addColumnIfNotExists(String field, DataType<?> type) {
        return this.addColumnIfNotExists(DSL.name(field), (DataType)type);
    }

    @Override
    public final AlterTableImpl addColumnIfNotExists(Name field, DataType<?> type) {
        return this.addColumnIfNotExists((Field)DSL.field(field, type), (DataType)type);
    }

    @Override
    public final AlterTableImpl addColumnIfNotExists(Field<?> field) {
        return this.addColumnIfNotExists((Field)field, field.getDataType());
    }

    @Override
    public final <T> AlterTableImpl addColumnIfNotExists(Field<T> field, DataType<T> type) {
        this.ifNotExistsColumn = true;
        return this.addColumn((Field)field, (DataType)type);
    }

    @Override
    public final AlterTableImpl add(Constraint constraint) {
        this.addConstraint = constraint;
        return this;
    }

    @Override
    public final AlterTableImpl first() {
        this.addFirst = true;
        return this;
    }

    @Override
    public final AlterTableImpl before(String columnName) {
        return this.before(DSL.name(columnName));
    }

    @Override
    public final AlterTableImpl before(Name columnName) {
        return this.before((Field)DSL.field(columnName));
    }

    @Override
    public final AlterTableImpl before(Field<?> columnName) {
        this.addBefore = columnName;
        return this;
    }

    @Override
    public final AlterTableImpl after(String columnName) {
        return this.after(DSL.name(columnName));
    }

    @Override
    public final AlterTableImpl after(Name columnName) {
        return this.after((Field)DSL.field(columnName));
    }

    @Override
    public final AlterTableImpl after(Field<?> columnName) {
        this.addAfter = columnName;
        return this;
    }

    public final <T> AlterTableImpl alter(Field<T> field) {
        return this.alterColumn((Field)field);
    }

    public final AlterTableImpl alter(Name field) {
        return this.alterColumn(field);
    }

    public final AlterTableImpl alter(String field) {
        return this.alterColumn(field);
    }

    public final AlterTableImpl alterColumn(Name field) {
        return this.alterColumn((Field)DSL.field(field));
    }

    public final AlterTableImpl alterColumn(String field) {
        return this.alterColumn(DSL.name(field));
    }

    public final <T> AlterTableImpl alterColumn(Field<T> field) {
        this.alterColumn = field;
        return this;
    }

    public final AlterTableImpl set(DataType type) {
        this.alterColumnType = type;
        return this;
    }

    @Override
    public final AlterTableImpl setNotNull() {
        this.alterColumnNullability = Nullability.NOT_NULL;
        return this;
    }

    @Override
    public final AlterTableImpl dropNotNull() {
        this.alterColumnNullability = Nullability.NULL;
        return this;
    }

    public final AlterTableImpl defaultValue(Object literal) {
        return this.setDefault(literal);
    }

    public final AlterTableImpl defaultValue(Field expression) {
        return this.setDefault(expression);
    }

    public final AlterTableImpl default_(Object literal) {
        return this.setDefault(literal);
    }

    public final AlterTableImpl default_(Field expression) {
        return this.setDefault(expression);
    }

    public final AlterTableImpl setDefault(Object literal) {
        return this.default_((Field)Tools.field(literal));
    }

    public final AlterTableImpl setDefault(Field expression) {
        this.alterColumnDefault = expression;
        return this;
    }

    @Override
    public final AlterTableImpl dropDefault() {
        this.alterColumnDropDefault = true;
        return this;
    }

    @Override
    public final AlterTableImpl drop(Field<?> field) {
        return this.dropColumn((Field)field);
    }

    @Override
    public final AlterTableImpl drop(Name field) {
        return this.dropColumn(field);
    }

    @Override
    public final AlterTableImpl drop(String field) {
        return this.dropColumn(field);
    }

    @Override
    public final AlterTableImpl dropIfExists(Field<?> field) {
        return this.dropColumnIfExists((Field)field);
    }

    @Override
    public final AlterTableImpl dropIfExists(Name field) {
        return this.dropColumnIfExists(field);
    }

    @Override
    public final AlterTableImpl dropIfExists(String field) {
        return this.dropColumnIfExists(field);
    }

    @Override
    public final AlterTableImpl dropColumn(Name field) {
        return this.dropColumn((Field)DSL.field(field));
    }

    @Override
    public final AlterTableImpl dropColumn(String field) {
        return this.dropColumn(DSL.name(field));
    }

    @Override
    public final AlterTableImpl dropColumn(Field<?> field) {
        return this.dropColumns0(Collections.singletonList(field));
    }

    @Override
    public final AlterTableImpl dropColumnIfExists(Name field) {
        return this.dropColumnIfExists((Field)DSL.field(field));
    }

    @Override
    public final AlterTableImpl dropColumnIfExists(String field) {
        return this.dropColumnIfExists(DSL.name(field));
    }

    @Override
    public final AlterTableImpl dropColumnIfExists(Field<?> field) {
        this.ifExistsColumn = true;
        return this.dropColumn((Field)field);
    }

    @Override
    public final AlterTableImpl drop(Field<?> ... fields) {
        return this.dropColumns((Field[])fields);
    }

    @Override
    public final AlterTableImpl drop(Name ... fields) {
        return this.dropColumns(fields);
    }

    @Override
    public final AlterTableImpl drop(String ... fields) {
        return this.dropColumns(fields);
    }

    @Override
    public final AlterTableImpl dropColumns(Field<?> ... fields) {
        return this.dropColumns(Arrays.asList(fields));
    }

    @Override
    public final AlterTableImpl dropColumns(Name ... fields) {
        return this.dropColumns((Field[])Tools.fieldsByName(fields));
    }

    @Override
    public final AlterTableImpl dropColumns(String ... fields) {
        return this.dropColumns((Field[])Tools.fieldsByName(fields));
    }

    @Override
    public final AlterTableImpl drop(Collection<? extends Field<?>> fields) {
        return this.dropColumns((Collection)fields);
    }

    @Override
    public final AlterTableImpl dropColumns(Collection<? extends Field<?>> fields) {
        return this.dropColumns0(fields);
    }

    private final AlterTableImpl dropColumns0(Collection<? extends Field<?>> fields) {
        this.dropColumns = new QueryPartList((Iterable<Field<?>>)fields);
        return this;
    }

    @Override
    public final AlterTableImpl drop(Constraint constraint) {
        this.dropConstraint = constraint;
        this.dropConstraintType = null;
        return this;
    }

    @Override
    public final AlterTableImpl dropConstraint(Constraint constraint) {
        return this.drop(constraint);
    }

    @Override
    public final AlterTableImpl dropConstraint(Name constraint) {
        return this.dropConstraint(DSL.constraint(constraint));
    }

    @Override
    public final AlterTableImpl dropConstraint(String constraint) {
        return this.dropConstraint(DSL.constraint(constraint));
    }

    @Override
    public final AlterTableImpl dropIfExists(Constraint constraint) {
        this.ifExistsConstraint = true;
        return this.drop(constraint);
    }

    @Override
    public final AlterTableImpl dropConstraintIfExists(Constraint constraint) {
        return this.dropIfExists(constraint);
    }

    @Override
    public final AlterTableImpl dropConstraintIfExists(Name constraint) {
        return this.dropIfExists(DSL.constraint(constraint));
    }

    @Override
    public final AlterTableImpl dropConstraintIfExists(String constraint) {
        return this.dropIfExists(DSL.constraint(constraint));
    }

    @Override
    public final AlterTableImpl dropPrimaryKey() {
        this.dropConstraintType = ConstraintType.PRIMARY_KEY;
        return this;
    }

    @Override
    public final AlterTableImpl dropPrimaryKey(Constraint constraint) {
        this.dropConstraint = constraint;
        this.dropConstraintType = ConstraintType.PRIMARY_KEY;
        return this;
    }

    @Override
    public final AlterTableImpl dropPrimaryKey(Name constraint) {
        return this.dropPrimaryKey(DSL.constraint(constraint));
    }

    @Override
    public final AlterTableImpl dropPrimaryKey(String constraint) {
        return this.dropPrimaryKey(DSL.constraint(constraint));
    }

    @Override
    public final AlterTableImpl dropUnique(Constraint constraint) {
        this.dropConstraint = constraint;
        this.dropConstraintType = ConstraintType.UNIQUE;
        return this;
    }

    @Override
    public final AlterTableImpl dropUnique(Name constraint) {
        return this.dropUnique(DSL.constraint(constraint));
    }

    @Override
    public final AlterTableImpl dropUnique(String constraint) {
        return this.dropUnique(DSL.constraint(constraint));
    }

    @Override
    public final AlterTableImpl dropForeignKey(Constraint constraint) {
        this.dropConstraint = constraint;
        this.dropConstraintType = ConstraintType.FOREIGN_KEY;
        return this;
    }

    @Override
    public final AlterTableImpl dropForeignKey(Name constraint) {
        return this.dropForeignKey(DSL.constraint(constraint));
    }

    @Override
    public final AlterTableImpl dropForeignKey(String constraint) {
        return this.dropForeignKey(DSL.constraint(constraint));
    }

    @Override
    public final AlterTableFinalStep cascade() {
        this.dropCascade = Cascade.CASCADE;
        return this;
    }

    @Override
    public final AlterTableFinalStep restrict() {
        this.dropCascade = Cascade.RESTRICT;
        return this;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_EXISTS.contains((Object)ctx.dialect());
    }

    private final boolean supportsIfExistsColumn(Context<?> ctx) {
        return !NO_SUPPORT_IF_EXISTS_COLUMN.contains((Object)ctx.dialect());
    }

    private final boolean supportsIfNotExistsColumn(Context<?> ctx) {
        return !NO_SUPPORT_IF_NOT_EXISTS_COLUMN.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifExists && !this.supportsIfExists(ctx) || (this.ifExistsColumn || this.ifExistsConstraint || this.ifNotExistsColumn) && !this.supportsIfExistsColumn(ctx)) {
            Tools.beginTryCatch(ctx, DDLStatementType.ALTER_TABLE, this.ifExists ? Boolean.TRUE : null, this.ifExistsColumn || this.ifExistsConstraint ? Boolean.TRUE : (this.ifNotExistsColumn ? Boolean.FALSE : null));
            this.accept0(ctx);
            Tools.endTryCatch(ctx, DDLStatementType.ALTER_TABLE, this.ifExists ? Boolean.TRUE : null, this.ifExistsColumn || this.ifExistsConstraint ? Boolean.TRUE : (this.ifNotExistsColumn ? Boolean.FALSE : null));
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        SQLDialect family = ctx.family();
        if (this.comment != null) {
            switch (family) {
                case MARIADB: 
                case MYSQL: {
                    break;
                }
                default: {
                    ctx.visit(DSL.commentOnTable(this.table).is(this.comment));
                    return;
                }
            }
        }
        if (family == SQLDialect.FIREBIRD && this.addFirst) {
            Tools.begin(ctx);
            Tools.beginExecuteImmediate(ctx);
            this.accept1(ctx);
            Tools.endExecuteImmediate(ctx);
            ctx.formatSeparator();
            Tools.beginExecuteImmediate(ctx);
            ctx.visit(Keywords.K_ALTER_TABLE).sql(' ').visit(this.table).sql(' ').visit(Keywords.K_ALTER).sql(' ').visit(this.addColumn).sql(' ').visit(Keywords.K_POSITION).sql(" 1");
            Tools.endExecuteImmediate(ctx);
            Tools.end(ctx);
            return;
        }
        if (this.renameIndexTo != null) {
            switch (family) {
                case MYSQL: {
                    break;
                }
                default: {
                    ctx.visit(DSL.alterIndex(this.renameIndex).renameTo(this.renameIndexTo));
                    return;
                }
            }
        }
        if (this.alterColumnType != null && this.alterColumnType.nullability() != Nullability.DEFAULT) {
            switch (family) {
                case POSTGRES: {
                    this.alterColumnTypeAndNullabilityInBlock(ctx);
                    return;
                }
            }
        }
        this.accept1(ctx);
    }

    private final void accept1(Context<?> ctx) {
        boolean renameTable;
        SQLDialect family = ctx.family();
        boolean omitAlterTable = this.renameConstraint != null && family == SQLDialect.HSQLDB || this.renameColumn != null && SUPPORT_RENAME_COLUMN.contains((Object)ctx.dialect());
        boolean bl = renameTable = this.renameTo != null && SUPPORT_RENAME_TABLE.contains((Object)ctx.dialect());
        if (this.renameTo != null) {
            // empty if block
        }
        boolean renameObject = false;
        if (!omitAlterTable) {
            ctx.start(Clause.ALTER_TABLE_TABLE).visit(renameObject ? Keywords.K_RENAME_OBJECT : (renameTable ? Keywords.K_RENAME_TABLE : Keywords.K_ALTER_TABLE));
            if (this.ifExists && this.supportsIfExists(ctx)) {
                ctx.sql(' ').visit(Keywords.K_IF_EXISTS);
            }
            ctx.sql(' ').visit(this.table).end(Clause.ALTER_TABLE_TABLE).formatIndentStart().formatSeparator();
        }
        if (this.comment != null) {
            ctx.visit(Keywords.K_COMMENT).sql(' ').visit(this.comment);
        } else if (this.renameTo != null) {
            boolean qualify = ctx.qualify();
            ctx.start(Clause.ALTER_TABLE_RENAME);
            if (NO_SUPPORT_RENAME_QUALIFIED_TABLE.contains((Object)ctx.dialect())) {
                ctx.qualify(false);
            }
            ctx.visit(renameObject || renameTable ? Keywords.K_TO : Keywords.K_RENAME_TO).sql(' ').visit(this.renameTo);
            if (NO_SUPPORT_RENAME_QUALIFIED_TABLE.contains((Object)ctx.dialect())) {
                ctx.qualify(qualify);
            }
            ctx.end(Clause.ALTER_TABLE_RENAME);
        } else if (this.renameColumn != null) {
            boolean qualify = ctx.qualify();
            ctx.start(Clause.ALTER_TABLE_RENAME_COLUMN);
            switch (ctx.family()) {
                case DERBY: {
                    ctx.visit(Keywords.K_RENAME_COLUMN).sql(' ').visit(this.renameColumn).formatSeparator().visit(Keywords.K_TO).sql(' ').qualify(false).visit(this.renameColumnTo).qualify(qualify);
                    break;
                }
                case H2: 
                case HSQLDB: {
                    ctx.qualify(false).visit(Keywords.K_ALTER_COLUMN).sql(' ').visit(this.renameColumn).formatSeparator().visit(Keywords.K_RENAME_TO).sql(' ').visit(this.renameColumnTo).qualify(qualify);
                    break;
                }
                case FIREBIRD: {
                    ctx.qualify(false).visit(Keywords.K_ALTER_COLUMN).sql(' ').visit(this.renameColumn).formatSeparator().visit(Keywords.K_TO).sql(' ').visit(this.renameColumnTo).qualify(qualify);
                    break;
                }
                default: {
                    ctx.qualify(false).visit(Keywords.K_RENAME_COLUMN).sql(' ').visit(this.renameColumn).formatSeparator().visit(Keywords.K_TO).sql(' ').visit(this.renameColumnTo).qualify(qualify);
                }
            }
            ctx.end(Clause.ALTER_TABLE_RENAME_COLUMN);
        } else if (this.renameIndex != null) {
            boolean qualify = ctx.qualify();
            ctx.start(Clause.ALTER_TABLE_RENAME_INDEX).qualify(false).visit(Keywords.K_RENAME_INDEX).sql(' ').visit(this.renameIndex).formatSeparator().visit(Keywords.K_TO).sql(' ').visit(this.renameIndexTo).qualify(qualify).end(Clause.ALTER_TABLE_RENAME_INDEX);
        } else if (this.renameConstraint != null) {
            boolean qualify = ctx.qualify();
            ctx.start(Clause.ALTER_TABLE_RENAME_CONSTRAINT);
            ctx.data((Object)Tools.BooleanDataKey.DATA_CONSTRAINT_REFERENCE, true);
            if (family == SQLDialect.HSQLDB) {
                ctx.qualify(false).visit(Keywords.K_ALTER_CONSTRAINT).sql(' ').visit(this.renameConstraint).formatSeparator().visit(Keywords.K_RENAME_TO).sql(' ').visit(this.renameConstraintTo).qualify(qualify);
            } else {
                ctx.qualify(false).visit(Keywords.K_RENAME_CONSTRAINT).sql(' ').visit(this.renameConstraint).formatSeparator().visit(Keywords.K_TO).sql(' ').visit(this.renameConstraintTo).qualify(qualify);
            }
            ctx.data().remove((Object)Tools.BooleanDataKey.DATA_CONSTRAINT_REFERENCE);
            ctx.end(Clause.ALTER_TABLE_RENAME_CONSTRAINT);
        } else if (this.add != null) {
            boolean indent;
            boolean qualify = ctx.qualify();
            boolean multiAdd = REQUIRE_REPEAT_ADD_ON_MULTI_ALTER.contains((Object)ctx.dialect());
            boolean bl2 = !multiAdd;
            boolean comma = true;
            ctx.start(Clause.ALTER_TABLE_ADD).visit(Keywords.K_ADD).sql(' ');
            if (bl2) {
                ctx.sql('(');
            }
            boolean bl3 = indent = !multiAdd && this.add.size() > 1;
            if (indent) {
                ctx.formatIndentStart().formatNewLine();
            }
            for (int i = 0; i < this.add.size(); ++i) {
                if (i > 0) {
                    if (multiAdd) {
                        ctx.sql(comma ? "," : "").formatSeparator().visit(Keywords.K_ADD).sql(' ');
                    } else {
                        ctx.sql(comma ? "," : "").formatSeparator();
                    }
                }
                FieldOrConstraint part = (FieldOrConstraint)this.add.get(i);
                ctx.qualify(false).visit(part).qualify(qualify);
                if (!(part instanceof Field)) continue;
                ctx.sql(' ');
                Tools.toSQLDDLTypeDeclarationForAddition(ctx, ((Field)part).getDataType());
            }
            if (indent) {
                ctx.formatIndentEnd().formatNewLine();
            }
            if (bl2) {
                ctx.sql(')');
            }
            this.acceptFirstBeforeAfter(ctx);
            ctx.end(Clause.ALTER_TABLE_ADD);
        } else if (this.addColumn != null) {
            boolean qualify = ctx.qualify();
            ctx.start(Clause.ALTER_TABLE_ADD).visit(Keywords.K_ADD).sql(' ');
            if (this.ifNotExistsColumn && this.supportsIfNotExistsColumn(ctx)) {
                ctx.visit(Keywords.K_IF_NOT_EXISTS).sql(' ');
            }
            ctx.qualify(false).visit(this.addColumn).sql(' ').qualify(qualify);
            Tools.toSQLDDLTypeDeclarationForAddition(ctx, this.addColumnType);
            this.acceptFirstBeforeAfter(ctx);
            ctx.end(Clause.ALTER_TABLE_ADD);
        } else if (this.addConstraint != null) {
            ctx.start(Clause.ALTER_TABLE_ADD);
            ctx.visit(Keywords.K_ADD).sql(' ');
            ctx.visit(this.addConstraint);
            ctx.end(Clause.ALTER_TABLE_ADD);
        } else if (this.alterColumn != null) {
            ctx.start(Clause.ALTER_TABLE_ALTER);
            switch (family) {
                case MARIADB: 
                case MYSQL: 
                case CUBRID: {
                    if (this.alterColumnDefault == null && !this.alterColumnDropDefault) {
                        ctx.visit(Keywords.K_CHANGE_COLUMN).sql(' ').qualify(false).visit(this.alterColumn).qualify(true);
                        break;
                    }
                    ctx.visit(Keywords.K_ALTER_COLUMN);
                    break;
                }
                default: {
                    ctx.visit(Keywords.K_ALTER);
                }
            }
            ctx.sql(' ');
            ctx.qualify(false).visit(this.alterColumn).qualify(true);
            if (this.alterColumnType != null) {
                switch (family) {
                    case DERBY: {
                        ctx.sql(' ').visit(Keywords.K_SET_DATA_TYPE);
                        break;
                    }
                    case POSTGRES: 
                    case FIREBIRD: {
                        ctx.sql(' ').visit(Keywords.K_TYPE);
                    }
                }
                ctx.sql(' ');
                Tools.toSQLDDLTypeDeclaration(ctx, this.alterColumnType);
                Tools.toSQLDDLTypeDeclarationIdentityBeforeNull(ctx, this.alterColumnType);
                if (!NO_SUPPORT_ALTER_TYPE_AND_NULL.contains((Object)ctx.dialect())) {
                    switch (this.alterColumnType.nullability()) {
                        case NULL: {
                            ctx.sql(' ').visit(Keywords.K_NULL);
                            break;
                        }
                        case NOT_NULL: {
                            ctx.sql(' ').visit(Keywords.K_NOT_NULL);
                            break;
                        }
                    }
                }
                Tools.toSQLDDLTypeDeclarationIdentityAfterNull(ctx, this.alterColumnType);
            } else if (this.alterColumnDefault != null) {
                ctx.start(Clause.ALTER_TABLE_ALTER_DEFAULT);
                switch (family) {
                    default: 
                }
                ctx.sql(' ').visit(Keywords.K_SET_DEFAULT);
                ctx.sql(' ').visit(this.alterColumnDefault).end(Clause.ALTER_TABLE_ALTER_DEFAULT);
            } else if (this.alterColumnDropDefault) {
                ctx.start(Clause.ALTER_TABLE_ALTER_DEFAULT);
                switch (family) {
                    case MARIADB: 
                    case MYSQL: {
                        ctx.sql(' ').visit(Keywords.K_SET_DEFAULT).sql(' ').visit(Keywords.K_NULL);
                        break;
                    }
                    default: {
                        ctx.sql(' ').visit(Keywords.K_DROP_DEFAULT);
                    }
                }
                ctx.end(Clause.ALTER_TABLE_ALTER_DEFAULT);
            } else if (this.alterColumnNullability != null) {
                ctx.start(Clause.ALTER_TABLE_ALTER_NULL);
                switch (ctx.family()) {
                    default: 
                }
                ctx.sql(' ').visit(this.alterColumnNullability.nullable() ? Keywords.K_DROP_NOT_NULL : Keywords.K_SET_NOT_NULL);
                ctx.end(Clause.ALTER_TABLE_ALTER_NULL);
            }
            ctx.end(Clause.ALTER_TABLE_ALTER);
        } else if (this.dropColumns != null) {
            ctx.start(Clause.ALTER_TABLE_DROP);
            if (REQUIRE_REPEAT_DROP_ON_MULTI_ALTER.contains((Object)ctx.dialect())) {
                String separator = "";
                for (Field field : this.dropColumns) {
                    ctx.sql(separator).qualify(false);
                    this.acceptDropColumn(ctx);
                    if (this.ifExistsColumn && this.supportsIfExistsColumn(ctx)) {
                        ctx.sql(' ').visit(Keywords.K_IF_EXISTS);
                    }
                    ctx.sql(' ').visit(field).qualify(true);
                    separator = ", ";
                }
            } else {
                this.acceptDropColumn(ctx);
                if (this.ifExistsColumn && this.supportsIfExistsColumn(ctx)) {
                    ctx.sql(' ').visit(Keywords.K_IF_EXISTS);
                }
                ctx.sql(' ');
                ctx.qualify(false).visit(this.dropColumns).qualify(true);
            }
            this.acceptCascade(ctx);
            ctx.end(Clause.ALTER_TABLE_DROP);
        } else if (this.dropConstraint != null) {
            ctx.start(Clause.ALTER_TABLE_DROP);
            ctx.data((Object)Tools.BooleanDataKey.DATA_CONSTRAINT_REFERENCE, true);
            if (this.dropConstraintType == ConstraintType.FOREIGN_KEY && NO_SUPPORT_DROP_CONSTRAINT.contains((Object)ctx.dialect())) {
                ctx.visit(Keywords.K_DROP).sql(' ').visit(Keywords.K_FOREIGN_KEY).sql(' ').visit(this.dropConstraint);
            } else if (this.dropConstraintType == ConstraintType.PRIMARY_KEY && NO_SUPPORT_DROP_CONSTRAINT.contains((Object)ctx.dialect())) {
                ctx.visit(Keywords.K_DROP).sql(' ').visit(Keywords.K_PRIMARY_KEY);
            } else {
                ctx.visit(this.dropConstraint.getUnqualifiedName().empty() ? Keywords.K_DROP : Keywords.K_DROP_CONSTRAINT).sql(' ');
                if (this.ifExistsConstraint && !NO_SUPPORT_IF_EXISTS_CONSTRAINT.contains((Object)ctx.dialect())) {
                    ctx.visit(Keywords.K_IF_EXISTS).sql(' ');
                }
                ctx.visit(this.dropConstraint);
            }
            this.acceptCascade(ctx);
            ctx.data().remove((Object)Tools.BooleanDataKey.DATA_CONSTRAINT_REFERENCE);
            ctx.end(Clause.ALTER_TABLE_DROP);
        } else if (this.dropConstraintType == ConstraintType.PRIMARY_KEY) {
            ctx.start(Clause.ALTER_TABLE_DROP);
            ctx.visit(Keywords.K_DROP).sql(' ').visit(Keywords.K_PRIMARY_KEY);
            ctx.end(Clause.ALTER_TABLE_DROP);
        }
        if (!omitAlterTable) {
            ctx.formatIndentEnd();
        }
    }

    private final void acceptCascade(Context<?> ctx) {
        switch (ctx.family()) {
            case H2: {
                break;
            }
            default: {
                if (this.dropCascade == Cascade.CASCADE) {
                    ctx.sql(' ').visit(Keywords.K_CASCADE);
                    break;
                }
                if (this.dropCascade != Cascade.RESTRICT) break;
                ctx.sql(' ').visit(Keywords.K_RESTRICT);
            }
        }
    }

    private final void acceptFirstBeforeAfter(Context<?> ctx) {
        boolean previous = ctx.qualify();
        if (this.addFirst && ctx.family() != SQLDialect.FIREBIRD) {
            ctx.sql(' ').visit(Keywords.K_FIRST);
        } else if (this.addBefore != null) {
            ctx.sql(' ').visit(Keywords.K_BEFORE).sql(' ').qualify(false).visit(this.addBefore).qualify(previous);
        } else if (this.addAfter != null) {
            ctx.sql(' ').visit(Keywords.K_AFTER).sql(' ').qualify(false).visit(this.addAfter).qualify(previous);
        }
    }

    private final void acceptDropColumn(Context<?> ctx) {
        switch (ctx.family()) {
            default: 
        }
        ctx.visit(Keywords.K_DROP);
    }

    private final void alterColumnTypeAndNullabilityInBlock(Context<?> ctx) {
        Tools.begin(ctx);
        this.accept1(ctx);
        ctx.sql(';').formatSeparator();
        switch (ctx.family()) {
            case POSTGRES: {
                AlterTableAlterStep<?> step = ctx.dsl().alterTable(this.table).alterColumn(this.alterColumn);
                ctx.visit(this.alterColumnType.nullable() ? step.dropNotNull() : step.setNotNull()).sql(';');
                break;
            }
        }
        Tools.end(ctx);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

