/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum SQLDialect {
    SQL99("", false, false),
    DEFAULT("", false, false),
    CUBRID("CUBRID", false, true),
    DERBY("Derby", false, true),
    FIREBIRD("Firebird", false, true),
    H2("H2", false, true),
    HSQLDB("HSQLDB", false, true),
    MARIADB("MariaDB", false, true),
    MYSQL("MySQL", false, true),
    POSTGRES("Postgres", false, true),
    SQLITE("SQLite", false, true);

    private static final SQLDialect[] FAMILIES;
    private final String name;
    private final boolean commercial;
    private final boolean supported;
    private final SQLDialect family;
    private SQLDialect predecessor;
    private transient EnumSet<SQLDialect> predecessors;
    private final ThirdParty thirdParty;

    @NotNull
    public static final SQLDialect[] families() {
        return (SQLDialect[])FAMILIES.clone();
    }

    @NotNull
    public static final Set<SQLDialect> predecessors(SQLDialect ... dialects) {
        EnumSet<SQLDialect> result = EnumSet.noneOf(SQLDialect.class);
        for (SQLDialect dialect : dialects) {
            result.addAll(dialect.predecessors());
        }
        return Collections.unmodifiableSet(result);
    }

    @NotNull
    public static final Set<SQLDialect> supportedUntil(SQLDialect dialect) {
        return SQLDialect.predecessors(dialect);
    }

    @NotNull
    public static final Set<SQLDialect> supportedUntil(SQLDialect ... dialects) {
        return SQLDialect.predecessors(dialects);
    }

    @NotNull
    public static final Set<SQLDialect> supportedBy(SQLDialect dialect) {
        EnumSet<SQLDialect> result = EnumSet.noneOf(SQLDialect.class);
        SQLDialect.addSupportedBy(dialect, result);
        return Collections.unmodifiableSet(result);
    }

    @NotNull
    public static final Set<SQLDialect> supportedBy(SQLDialect ... dialects) {
        EnumSet<SQLDialect> result = EnumSet.noneOf(SQLDialect.class);
        for (SQLDialect dialect : dialects) {
            SQLDialect.addSupportedBy(dialect, result);
        }
        return Collections.unmodifiableSet(result);
    }

    private static final void addSupportedBy(SQLDialect dialect, EnumSet<SQLDialect> supported) {
        supported.add(dialect);
        if (dialect.isFamily()) {
            supported.addAll(dialect.predecessors());
        } else {
            for (SQLDialect candidate = dialect.family(); candidate != dialect; candidate = candidate.predecessor()) {
                supported.add(candidate);
            }
        }
    }

    private SQLDialect(String name, boolean commercial, boolean supported) {
        this(name, commercial, supported, null, null);
    }

    private SQLDialect(String name, boolean commercial, boolean supported, SQLDialect family) {
        this(name, commercial, supported, family, null);
    }

    private SQLDialect(String name, boolean commercial, boolean supported, SQLDialect family, SQLDialect predecessor) {
        this.name = name;
        this.commercial = commercial;
        this.supported = supported;
        this.family = family == null ? this : family;
        SQLDialect sQLDialect = this.predecessor = predecessor == null ? this : predecessor;
        if (family != null) {
            family.predecessor = this;
        }
        this.thirdParty = new ThirdParty();
    }

    public final boolean commercial() {
        return this.commercial;
    }

    public final boolean supported() {
        return this.supported;
    }

    @NotNull
    public final SQLDialect family() {
        return this.family;
    }

    public final boolean isFamily() {
        return this == this.family;
    }

    @NotNull
    public final SQLDialect predecessor() {
        return this.predecessor;
    }

    @NotNull
    public final Set<SQLDialect> predecessors() {
        if (this.predecessors == null) {
            SQLDialect curr = this;
            EnumSet<SQLDialect> result = EnumSet.of(curr);
            while (true) {
                SQLDialect pred = curr.predecessor();
                result.add(pred);
                if (curr == pred) break;
                curr = pred;
            }
            this.predecessors = result;
        }
        return Collections.unmodifiableSet(this.predecessors);
    }

    public final boolean precedes(SQLDialect other) {
        if (this.family != other.family) {
            return false;
        }
        return other.predecessors().contains((Object)this);
    }

    public final boolean supports(SQLDialect other) {
        if (this.family != other.family) {
            return false;
        }
        if (this.isFamily() || other.isFamily()) {
            return true;
        }
        return other.precedes(this);
    }

    @Deprecated
    public final boolean supports(Collection<SQLDialect> other) {
        if (other.contains((Object)this.family)) {
            return true;
        }
        SQLDialect candidate = this.family.predecessor();
        boolean successor = this == this.family;
        do {
            boolean bl = successor = successor || this == candidate;
            if (!other.contains((Object)candidate)) continue;
            return successor;
        } while (candidate != (candidate = candidate.predecessor()));
        return false;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getNameLC() {
        return this.name == null ? null : this.name.toLowerCase();
    }

    @NotNull
    public final String getNameUC() {
        return this.name == null ? null : this.name.toUpperCase();
    }

    @NotNull
    public final ThirdParty thirdParty() {
        return this.thirdParty;
    }

    static {
        EnumSet<SQLDialect> set = EnumSet.noneOf(SQLDialect.class);
        for (SQLDialect dialect : SQLDialect.values()) {
            set.add(dialect.family());
        }
        FAMILIES = set.toArray(new SQLDialect[0]);
    }

    public final class ThirdParty {
        @NotNull
        public final String driver() {
            try {
                Class<?> utils = Class.forName("com.craftaro.third_party.org.jooq.tools.jdbc.JDBCUtils");
                return (String)utils.getMethod("driver", SQLDialect.class).invoke(utils, new Object[]{SQLDialect.this});
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Nullable
        public final String springDbName() {
            switch (SQLDialect.this.family) {
                case DERBY: {
                    return "Derby";
                }
                case H2: {
                    return "H2";
                }
                case HSQLDB: {
                    return "HSQL";
                }
                case MARIADB: 
                case MYSQL: {
                    return "MySQL";
                }
                case POSTGRES: {
                    return "PostgreSQL";
                }
            }
            return null;
        }

        @Nullable
        public final String hibernateDialect() {
            switch (SQLDialect.this) {
                case CUBRID: {
                    return "org.hibernate.dialect.CUBRIDDialect";
                }
                case DERBY: {
                    return "org.hibernate.dialect.DerbyTenSevenDialect";
                }
                case FIREBIRD: {
                    return "org.hibernate.dialect.FirebirdDialect";
                }
                case H2: {
                    return "org.hibernate.dialect.H2Dialect";
                }
                case HSQLDB: {
                    return "org.hibernate.dialect.HSQLDialect";
                }
                case MARIADB: 
                case MYSQL: {
                    return "org.hibernate.dialect.MySQL5Dialect";
                }
                case POSTGRES: {
                    return "org.hibernate.dialect.PostgreSQL94Dialect";
                }
                case SQLITE: {
                    return null;
                }
            }
            return null;
        }
    }
}

