/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.h2.value;

import com.craftaro.third_party.org.h2.engine.CastDataProvider;
import com.craftaro.third_party.org.h2.value.CompareMode;
import com.craftaro.third_party.org.h2.value.TypeInfo;
import com.craftaro.third_party.org.h2.value.Value;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class ValueBoolean
extends Value {
    public static final int PRECISION = 1;
    public static final int DISPLAY_SIZE = 5;
    public static final ValueBoolean TRUE = new ValueBoolean(true);
    public static final ValueBoolean FALSE = new ValueBoolean(false);
    private final boolean value;

    private ValueBoolean(boolean bl) {
        this.value = bl;
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_BOOLEAN;
    }

    @Override
    public int getValueType() {
        return 1;
    }

    @Override
    public int getMemory() {
        return 0;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        return stringBuilder.append(this.getString());
    }

    @Override
    public String getString() {
        return this.value ? "TRUE" : "FALSE";
    }

    @Override
    public Value negate() {
        return this.value ? FALSE : TRUE;
    }

    @Override
    public boolean getBoolean() {
        return this.value;
    }

    @Override
    public int compareTypeSafe(Value value, CompareMode compareMode, CastDataProvider castDataProvider) {
        return Boolean.compare(this.value, ((ValueBoolean)value).value);
    }

    @Override
    public int hashCode() {
        return this.value ? 1 : 0;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setBoolean(n, this.value);
    }

    public static ValueBoolean get(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }
}

