/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.h2.value;

import com.craftaro.third_party.org.h2.engine.CastDataProvider;
import com.craftaro.third_party.org.h2.engine.SysProperties;
import com.craftaro.third_party.org.h2.util.MathUtils;
import com.craftaro.third_party.org.h2.value.CompareMode;
import com.craftaro.third_party.org.h2.value.Value;
import com.craftaro.third_party.org.h2.value.ValueCollectionBase;
import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;

public class ValueArray
extends ValueCollectionBase {
    private static final Object EMPTY = ValueArray.get(new Value[0]);
    private final Class<?> componentType;

    private ValueArray(Class<?> clazz, Value[] valueArray) {
        super(valueArray);
        this.componentType = clazz;
    }

    public static ValueArray get(Value[] valueArray) {
        return new ValueArray(Object.class, valueArray);
    }

    public static ValueArray get(Class<?> clazz, Value[] valueArray) {
        return new ValueArray(clazz, valueArray);
    }

    public static ValueArray getEmpty() {
        return (ValueArray)EMPTY;
    }

    @Override
    public int getValueType() {
        return 17;
    }

    public Class<?> getComponentType() {
        return this.componentType;
    }

    @Override
    public String getString() {
        StringBuilder stringBuilder = new StringBuilder().append('[');
        for (int i = 0; i < this.values.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.values[i].getString());
        }
        return stringBuilder.append(']').toString();
    }

    @Override
    public int compareTypeSafe(Value value, CompareMode compareMode, CastDataProvider castDataProvider) {
        ValueArray valueArray = (ValueArray)value;
        if (this.values == valueArray.values) {
            return 0;
        }
        int n = this.values.length;
        int n2 = valueArray.values.length;
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            Value value2 = this.values[i];
            Value value3 = valueArray.values[i];
            int n4 = value2.compareTo(value3, castDataProvider, compareMode);
            if (n4 == 0) continue;
            return n4;
        }
        return Integer.compare(n, n2);
    }

    @Override
    public Object getObject() {
        int n = this.values.length;
        Object[] objectArray = (Object[])Array.newInstance(this.componentType, n);
        for (int i = 0; i < n; ++i) {
            int n2;
            Value value = this.values[i];
            objectArray[i] = !SysProperties.OLD_RESULT_SET_GET_OBJECT && ((n2 = value.getValueType()) == 2 || n2 == 3) ? Integer.valueOf(value.getInt()) : value.getObject();
        }
        return objectArray;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setArray(n, preparedStatement.getConnection().createArrayOf("NULL", (Object[])this.getObject()));
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        stringBuilder.append("ARRAY [");
        int n = this.values.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            this.values[i].getSQL(stringBuilder);
        }
        return stringBuilder.append(']');
    }

    @Override
    public String getTraceSQL() {
        StringBuilder stringBuilder = new StringBuilder("[");
        for (int i = 0; i < this.values.length; ++i) {
            Value value;
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append((value = this.values[i]) == null ? "null" : value.getTraceSQL());
        }
        return stringBuilder.append(']').toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ValueArray)) {
            return false;
        }
        ValueArray valueArray = (ValueArray)object;
        if (this.values == valueArray.values) {
            return true;
        }
        int n = this.values.length;
        if (n != valueArray.values.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.values[i].equals(valueArray.values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Value convertPrecision(long l) {
        int n = MathUtils.convertLongToInt(l);
        if (this.values.length <= n) {
            return this;
        }
        return ValueArray.get(this.componentType, Arrays.copyOf(this.values, n));
    }
}

