/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.h2.table;

import com.craftaro.third_party.org.h2.command.dml.Query;
import com.craftaro.third_party.org.h2.command.dml.Select;
import com.craftaro.third_party.org.h2.command.dml.SelectUnion;
import com.craftaro.third_party.org.h2.index.Cursor;
import com.craftaro.third_party.org.h2.index.IndexCursor;
import com.craftaro.third_party.org.h2.index.IndexLookupBatch;
import com.craftaro.third_party.org.h2.index.ViewCursor;
import com.craftaro.third_party.org.h2.index.ViewIndex;
import com.craftaro.third_party.org.h2.message.DbException;
import com.craftaro.third_party.org.h2.result.ResultInterface;
import com.craftaro.third_party.org.h2.result.Row;
import com.craftaro.third_party.org.h2.result.SearchRow;
import com.craftaro.third_party.org.h2.table.Column;
import com.craftaro.third_party.org.h2.table.TableFilter;
import com.craftaro.third_party.org.h2.util.DoneFuture;
import com.craftaro.third_party.org.h2.util.LazyFuture;
import com.craftaro.third_party.org.h2.util.Utils;
import com.craftaro.third_party.org.h2.value.Value;
import com.craftaro.third_party.org.h2.value.ValueLong;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;

public final class JoinBatch {
    static final Cursor EMPTY_CURSOR = new Cursor(){

        @Override
        public boolean previous() {
            return false;
        }

        @Override
        public boolean next() {
            return false;
        }

        @Override
        public SearchRow getSearchRow() {
            return null;
        }

        @Override
        public Row get() {
            return null;
        }

        public String toString() {
            return "EMPTY_CURSOR";
        }
    };
    static final Future<Cursor> EMPTY_FUTURE_CURSOR = new DoneFuture<Cursor>(EMPTY_CURSOR);
    Future<Cursor> viewTopFutureCursor;
    JoinFilter top;
    final JoinFilter[] filters;
    boolean batchedSubQuery;
    private boolean started;
    private JoinRow current;
    private boolean found;
    private final TableFilter additionalFilter;

    public JoinBatch(int n, TableFilter tableFilter) {
        if (n > 32) {
            throw DbException.getUnsupportedException("Too many tables in join (at most 32 supported).");
        }
        this.filters = new JoinFilter[n];
        this.additionalFilter = tableFilter;
    }

    public IndexLookupBatch getLookupBatch(int n) {
        return this.filters[n].lookupBatch;
    }

    public void reset(boolean bl) {
        this.current = null;
        this.started = false;
        this.found = false;
        for (JoinFilter joinFilter : this.filters) {
            joinFilter.reset(bl);
        }
        if (bl && this.additionalFilter != null) {
            this.additionalFilter.reset();
        }
    }

    public void register(TableFilter tableFilter, IndexLookupBatch indexLookupBatch) {
        assert (tableFilter != null);
        this.filters[this.top.id] = this.top = new JoinFilter(indexLookupBatch, tableFilter, this.top);
    }

    public Value getValue(int n, Column column) {
        if (this.current == null) {
            return null;
        }
        Object object = this.current.row(n);
        assert (object != null);
        Row row = this.current.isRow(n) ? (Row)object : ((Cursor)object).get();
        int n2 = column.getColumnId();
        if (n2 == -1) {
            return ValueLong.get(row.getKey());
        }
        Value value = row.getValue(column.getColumnId());
        if (value == null) {
            throw DbException.throwInternalError("value is null: " + column + " " + row);
        }
        return value;
    }

    private void start() {
        Object object;
        Cursor cursor;
        this.current = new JoinRow(new Object[this.filters.length]);
        if (this.batchedSubQuery) {
            assert (this.viewTopFutureCursor != null);
            cursor = JoinBatch.get(this.viewTopFutureCursor);
        } else {
            object = this.top.filter;
            IndexCursor indexCursor = ((TableFilter)object).getIndexCursor();
            indexCursor.find(((TableFilter)object).getSession(), ((TableFilter)object).getIndexConditions());
            cursor = indexCursor;
        }
        this.current.updateRow(this.top.id, cursor, 0L, 2L);
        object = new JoinRow(null);
        ((JoinRow)object).next = this.current;
        this.current = object;
    }

    public boolean next() {
        if (!this.started) {
            this.start();
            this.started = true;
        }
        if (this.additionalFilter == null) {
            if (this.batchedNext()) {
                assert (this.current.isComplete());
                return true;
            }
            return false;
        }
        while (true) {
            if (!this.found) {
                if (!this.batchedNext()) {
                    return false;
                }
                assert (this.current.isComplete());
                this.found = true;
                this.additionalFilter.reset();
            }
            if (this.additionalFilter.next()) {
                return true;
            }
            this.found = false;
        }
    }

    private static Cursor get(Future<Cursor> future) {
        Cursor cursor;
        try {
            cursor = future.get();
        }
        catch (Exception exception) {
            throw DbException.convert(exception);
        }
        return cursor == null ? EMPTY_CURSOR : cursor;
    }

    /*
     * Unable to fully structure code
     */
    private boolean batchedNext() {
        if (this.current == null) {
            return false;
        }
        this.current = this.current.next;
        if (this.current == null) {
            return false;
        }
        this.current.prev = null;
        var2_2 = var1_1 = this.filters.length - 1;
        while (this.current.row(var2_2) == null) {
            --var2_2;
        }
        block1: while (true) {
            this.fetchCurrent(var2_2);
            if (!this.current.isDropped()) {
                if (var2_2 == var1_1) {
                    return true;
                }
                var3_3 = this.filters[var2_2 + 1];
                if (var3_3.isBatchFull()) {
                    this.current = var3_3.find(this.current);
                }
                if (this.current.row(var3_3.id) != null) {
                    var2_2 = var3_3.id;
                    continue;
                }
            }
            if (this.current.next == null) {
                if (this.current.isDropped()) {
                    this.current = this.current.prev;
                    if (this.current == null) {
                        return false;
                    }
                }
                if (!JoinBatch.$assertionsDisabled && this.current.isDropped()) {
                    throw new AssertionError();
                }
                if (!JoinBatch.$assertionsDisabled && var2_2 == var1_1) {
                    throw new AssertionError();
                }
                var2_2 = 0;
                while (this.current.row(var2_2) != null) {
                    ++var2_2;
                }
                this.current = this.filters[var2_2].find(this.current);
                continue;
            }
            this.current = this.current.next;
            if (!JoinBatch.$assertionsDisabled && this.current.isRow(var2_2)) {
                throw new AssertionError();
            }
            do {
                if (this.current.row(var2_2) == null) ** break;
                continue block1;
                if (!JoinBatch.$assertionsDisabled && var2_2 == this.top.id) {
                    throw new AssertionError();
                }
            } while (JoinBatch.$assertionsDisabled || !this.current.isRow(--var2_2));
            break;
        }
        throw new AssertionError();
    }

    private void fetchCurrent(int n) {
        boolean bl;
        JoinFilter joinFilter;
        Cursor cursor;
        block15: {
            boolean bl2;
            assert (this.current.prev == null || this.current.prev.isRow(n)) : "prev must be already fetched";
            assert (n == 0 || this.current.isRow(n - 1)) : "left must be already fetched";
            assert (!this.current.isRow(n)) : "double fetching";
            Object object = this.current.row(n);
            assert (object != null) : "x null";
            boolean bl3 = bl2 = object == EMPTY_CURSOR;
            if (bl2) {
                if (n == 0) {
                    this.current.drop();
                    return;
                }
            } else if (this.current.isFuture(n)) {
                object = JoinBatch.get((Future)object);
                this.current.updateRow(n, object, 1L, 2L);
                bl2 = true;
            }
            JoinFilter joinFilter2 = this.filters[n];
            cursor = (Cursor)object;
            assert (cursor != null);
            joinFilter = joinFilter2.join;
            while (true) {
                if (cursor == null || !cursor.next()) {
                    if (bl2 && joinFilter2.isOuterJoin()) {
                        this.current.updateRow(n, joinFilter2.getNullRow(), 2L, 3L);
                        cursor = null;
                        bl2 = false;
                    } else {
                        this.current.drop();
                        return;
                    }
                }
                if (!joinFilter2.isOk(cursor == null)) continue;
                bl = false;
                if (joinFilter == null || joinFilter.collectSearchRows()) break block15;
                if (joinFilter.isOuterJoin()) break;
            }
            bl = true;
        }
        if (cursor != null) {
            this.current = this.current.copyBehind(n);
            this.current.updateRow(n, cursor.get(), 2L, 3L);
        }
        if (bl) {
            this.current.updateRow(joinFilter.id, EMPTY_CURSOR, 0L, 2L);
        }
    }

    private IndexLookupBatch viewIndexLookupBatch(ViewIndex viewIndex) {
        return new ViewIndexLookupBatch(viewIndex);
    }

    public static IndexLookupBatch createViewIndexLookupBatch(ViewIndex viewIndex) {
        Query query = viewIndex.getQuery();
        if (query.isUnion()) {
            ViewIndexLookupBatchUnion viewIndexLookupBatchUnion = new ViewIndexLookupBatchUnion(viewIndex);
            return viewIndexLookupBatchUnion.initialize() ? viewIndexLookupBatchUnion : null;
        }
        JoinBatch joinBatch = ((Select)query).getJoinBatch();
        if (joinBatch == null || joinBatch.getLookupBatch(0) == null) {
            return null;
        }
        assert (!joinBatch.batchedSubQuery);
        joinBatch.batchedSubQuery = true;
        return joinBatch.viewIndexLookupBatch(viewIndex);
    }

    public static IndexLookupBatch createFakeIndexLookupBatch(TableFilter tableFilter) {
        return new FakeLookupBatch(tableFilter);
    }

    public String toString() {
        return "JoinBatch->\nprev->" + (this.current == null ? null : this.current.prev) + "\n" + "curr->" + this.current + "\n" + "next->" + (this.current == null ? null : this.current.next);
    }

    private static class QueryRunnerUnion
    extends QueryRunnerBase {
        final Future<Cursor>[] topFutureCursors;
        private final ViewIndexLookupBatchUnion batchUnion;

        QueryRunnerUnion(ViewIndexLookupBatchUnion viewIndexLookupBatchUnion) {
            super(viewIndexLookupBatchUnion.viewIndex);
            this.batchUnion = viewIndexLookupBatchUnion;
            this.topFutureCursors = new Future[viewIndexLookupBatchUnion.filters.size()];
        }

        @Override
        protected void clear() {
            super.clear();
            for (int i = 0; i < this.topFutureCursors.length; ++i) {
                this.topFutureCursors[i] = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Cursor run() throws Exception {
            ResultInterface resultInterface;
            this.viewIndex.setupQueryParameters(this.viewIndex.getSession(), this.first, this.last, null);
            ArrayList<JoinBatch> arrayList = this.batchUnion.joinBatches;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                assert (this.topFutureCursors[i] != null);
                arrayList.get((int)i).viewTopFutureCursor = this.topFutureCursors[i];
            }
            n = 0;
            try {
                resultInterface = this.viewIndex.getQuery().query(0);
                n = resultInterface.isLazy() ? 1 : 0;
            }
            finally {
                if (n == 0) {
                    this.resetViewTopFutureCursorAfterQuery();
                }
            }
            return this.newCursor(resultInterface);
        }

        @Override
        protected void resetViewTopFutureCursorAfterQuery() {
            ArrayList<JoinBatch> arrayList = this.batchUnion.joinBatches;
            if (arrayList == null) {
                return;
            }
            for (JoinBatch joinBatch : arrayList) {
                joinBatch.viewTopFutureCursor = null;
            }
        }
    }

    private static final class ViewIndexLookupBatchUnion
    extends ViewIndexLookupBatchBase<QueryRunnerUnion> {
        ArrayList<JoinFilter> filters;
        ArrayList<JoinBatch> joinBatches;
        private boolean onlyBatchedQueries = true;

        protected ViewIndexLookupBatchUnion(ViewIndex viewIndex) {
            super(viewIndex);
        }

        boolean initialize() {
            return this.collectJoinBatches(this.viewIndex.getQuery()) && this.joinBatches != null;
        }

        private boolean collectJoinBatches(Query query) {
            if (query.isUnion()) {
                SelectUnion selectUnion = (SelectUnion)query;
                return this.collectJoinBatches(selectUnion.getLeft()) && this.collectJoinBatches(selectUnion.getRight());
            }
            Select select = (Select)query;
            JoinBatch joinBatch = select.getJoinBatch();
            if (joinBatch == null) {
                this.onlyBatchedQueries = false;
            } else {
                if (joinBatch.getLookupBatch(0) == null) {
                    return false;
                }
                assert (!joinBatch.batchedSubQuery);
                joinBatch.batchedSubQuery = true;
                if (this.joinBatches == null) {
                    this.joinBatches = Utils.newSmallArrayList();
                    this.filters = Utils.newSmallArrayList();
                }
                this.filters.add(joinBatch.filters[0]);
                this.joinBatches.add(joinBatch);
            }
            return true;
        }

        @Override
        public boolean isBatchFull() {
            for (JoinFilter joinFilter : this.filters) {
                if (!joinFilter.isBatchFull()) continue;
                return true;
            }
            return false;
        }

        @Override
        protected boolean collectSearchRows(QueryRunnerUnion queryRunnerUnion) {
            boolean bl = false;
            for (int i = 0; i < this.filters.size(); ++i) {
                if (this.filters.get(i).collectSearchRows()) {
                    bl = true;
                    continue;
                }
                queryRunnerUnion.topFutureCursors[i] = EMPTY_FUTURE_CURSOR;
            }
            return bl || !this.onlyBatchedQueries;
        }

        @Override
        protected QueryRunnerUnion newQueryRunner() {
            return new QueryRunnerUnion(this);
        }

        @Override
        protected void startQueryRunners(int n) {
            for (int i = 0; i < this.filters.size(); ++i) {
                int n2;
                List<Future<Cursor>> list = this.filters.get(i).find();
                int n3 = 0;
                for (n2 = 0; n2 < n; ++n2) {
                    Future<Cursor>[] futureArray = ((QueryRunnerUnion)this.queryRunner((int)n2)).topFutureCursors;
                    if (futureArray[i] != null) continue;
                    futureArray[i] = list.get(n3++);
                }
                assert (n2 == n);
                assert (n3 == list.size());
            }
        }
    }

    private final class QueryRunner
    extends QueryRunnerBase {
        Future<Cursor> topFutureCursor;

        QueryRunner(ViewIndex viewIndex) {
            super(viewIndex);
        }

        @Override
        protected void clear() {
            super.clear();
            this.topFutureCursor = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Cursor run() throws Exception {
            ResultInterface resultInterface;
            if (this.topFutureCursor == null) {
                return EMPTY_CURSOR;
            }
            this.viewIndex.setupQueryParameters(this.viewIndex.getSession(), this.first, this.last, null);
            JoinBatch.this.viewTopFutureCursor = this.topFutureCursor;
            boolean bl = false;
            try {
                resultInterface = this.viewIndex.getQuery().query(0);
                bl = resultInterface.isLazy();
            }
            finally {
                if (!bl) {
                    this.resetViewTopFutureCursorAfterQuery();
                }
            }
            return this.newCursor(resultInterface);
        }

        @Override
        protected void resetViewTopFutureCursorAfterQuery() {
            JoinBatch.this.viewTopFutureCursor = null;
        }
    }

    private final class ViewIndexLookupBatch
    extends ViewIndexLookupBatchBase<QueryRunner> {
        ViewIndexLookupBatch(ViewIndex viewIndex) {
            super(viewIndex);
        }

        @Override
        protected QueryRunner newQueryRunner() {
            return new QueryRunner(this.viewIndex);
        }

        @Override
        protected boolean collectSearchRows(QueryRunner queryRunner) {
            return JoinBatch.this.top.collectSearchRows();
        }

        @Override
        public boolean isBatchFull() {
            return JoinBatch.this.top.isBatchFull();
        }

        @Override
        protected void startQueryRunners(int n) {
            List<Future<Cursor>> list = JoinBatch.this.top.find();
            if (list.size() != n) {
                throw DbException.throwInternalError("Unexpected result size: " + list.size() + ", expected :" + n);
            }
            for (int i = 0; i < n; ++i) {
                QueryRunner queryRunner = (QueryRunner)this.queryRunner(i);
                queryRunner.topFutureCursor = list.get(i);
            }
        }
    }

    private static abstract class QueryRunnerBase
    extends LazyFuture<Cursor> {
        protected final ViewIndex viewIndex;
        protected SearchRow first;
        protected SearchRow last;
        private boolean isLazyResult;

        QueryRunnerBase(ViewIndex viewIndex) {
            this.viewIndex = viewIndex;
        }

        protected void clear() {
            this.last = null;
            this.first = null;
        }

        @Override
        public final boolean reset() {
            if (this.isLazyResult) {
                this.resetViewTopFutureCursorAfterQuery();
            }
            if (super.reset()) {
                return true;
            }
            this.clear();
            return false;
        }

        protected final ViewCursor newCursor(ResultInterface resultInterface) {
            this.isLazyResult = resultInterface.isLazy();
            ViewCursor viewCursor = new ViewCursor(this.viewIndex, resultInterface, this.first, this.last);
            this.clear();
            return viewCursor;
        }

        protected abstract void resetViewTopFutureCursorAfterQuery();
    }

    private static abstract class ViewIndexLookupBatchBase<R extends QueryRunnerBase>
    implements IndexLookupBatch {
        protected final ViewIndex viewIndex;
        private final ArrayList<Future<Cursor>> result = Utils.newSmallArrayList();
        private int resultSize;
        private boolean findCalled;

        protected ViewIndexLookupBatchBase(ViewIndex viewIndex) {
            this.viewIndex = viewIndex;
        }

        @Override
        public String getPlanSQL() {
            return "view";
        }

        protected abstract boolean collectSearchRows(R var1);

        protected abstract R newQueryRunner();

        protected abstract void startQueryRunners(int var1);

        protected final boolean resetAfterFind() {
            if (!this.findCalled) {
                return false;
            }
            this.findCalled = false;
            for (int i = 0; i < this.resultSize; ++i) {
                ((QueryRunnerBase)this.queryRunner(i)).reset();
            }
            this.resultSize = 0;
            return true;
        }

        protected R queryRunner(int n) {
            return (R)((QueryRunnerBase)this.result.get(n));
        }

        @Override
        public final boolean addSearchRows(SearchRow searchRow, SearchRow searchRow2) {
            R r;
            this.resetAfterFind();
            this.viewIndex.setupQueryParameters(this.viewIndex.getSession(), searchRow, searchRow2, null);
            if (this.resultSize < this.result.size()) {
                r = this.queryRunner(this.resultSize);
            } else {
                r = this.newQueryRunner();
                this.result.add((Future<Cursor>)r);
            }
            ((QueryRunnerBase)r).first = searchRow;
            ((QueryRunnerBase)r).last = searchRow2;
            if (!this.collectSearchRows(r)) {
                ((QueryRunnerBase)r).clear();
                return false;
            }
            ++this.resultSize;
            return true;
        }

        @Override
        public void reset(boolean bl) {
            if (this.resultSize != 0 && !this.resetAfterFind()) {
                for (int i = 0; i < this.resultSize; ++i) {
                    ((QueryRunnerBase)this.queryRunner(i)).clear();
                }
                this.resultSize = 0;
            }
        }

        @Override
        public final List<Future<Cursor>> find() {
            if (this.resultSize == 0) {
                return Collections.emptyList();
            }
            this.findCalled = true;
            this.startQueryRunners(this.resultSize);
            return this.resultSize == this.result.size() ? this.result : this.result.subList(0, this.resultSize);
        }
    }

    static final class SingletonList<E>
    extends AbstractList<E> {
        private E element;

        SingletonList() {
        }

        @Override
        public E get(int n) {
            assert (n == 0);
            return this.element;
        }

        @Override
        public E set(int n, E e) {
            assert (n == 0);
            this.element = e;
            return null;
        }

        @Override
        public int size() {
            return 1;
        }
    }

    private static final class FakeLookupBatch
    implements IndexLookupBatch {
        private final TableFilter filter;
        private SearchRow first;
        private SearchRow last;
        private boolean full;
        private final List<Future<Cursor>> result = new SingletonList<Future<Cursor>>();

        FakeLookupBatch(TableFilter tableFilter) {
            this.filter = tableFilter;
        }

        @Override
        public String getPlanSQL() {
            return "fake";
        }

        @Override
        public void reset(boolean bl) {
            this.full = false;
            this.last = null;
            this.first = null;
            this.result.set(0, null);
        }

        @Override
        public boolean addSearchRows(SearchRow searchRow, SearchRow searchRow2) {
            assert (!this.full);
            this.first = searchRow;
            this.last = searchRow2;
            this.full = true;
            return true;
        }

        @Override
        public boolean isBatchFull() {
            return this.full;
        }

        @Override
        public List<Future<Cursor>> find() {
            if (!this.full) {
                return Collections.emptyList();
            }
            Cursor cursor = this.filter.getIndex().find(this.filter, this.first, this.last);
            this.result.set(0, new DoneFuture<Cursor>(cursor));
            this.full = false;
            this.last = null;
            this.first = null;
            return this.result;
        }
    }

    private static final class JoinRow {
        private static final long S_NULL = 0L;
        private static final long S_FUTURE = 1L;
        private static final long S_CURSOR = 2L;
        private static final long S_ROW = 3L;
        private static final long S_MASK = 3L;
        JoinRow prev;
        JoinRow next;
        private Object[] row;
        private long state;

        JoinRow(Object[] objectArray) {
            this.row = objectArray;
        }

        private long getState(int n) {
            return this.state >>> (n << 1) & 3L;
        }

        private void incrementState(int n, long l) {
            assert (l > 0L) : l;
            this.state += l << (n << 1);
        }

        void updateRow(int n, Object object, long l, long l2) {
            assert (this.getState(n) == l) : "old state: " + this.getState(n);
            this.row[n] = object;
            this.incrementState(n, l2 - l);
            assert (this.getState(n) == l2) : "new state: " + this.getState(n);
        }

        Object row(int n) {
            return this.row[n];
        }

        boolean isRow(int n) {
            return this.getState(n) == 3L;
        }

        boolean isFuture(int n) {
            return this.getState(n) == 1L;
        }

        private boolean isCursor(int n) {
            return this.getState(n) == 2L;
        }

        boolean isComplete() {
            return this.isRow(this.row.length - 1);
        }

        boolean isDropped() {
            return this.row == null;
        }

        void drop() {
            if (this.prev != null) {
                this.prev.next = this.next;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            this.row = null;
        }

        JoinRow copyBehind(int n) {
            assert (this.isCursor(n));
            assert (n + 1 == this.row.length || this.row[n + 1] == null);
            Object[] objectArray = new Object[this.row.length];
            if (n != 0) {
                System.arraycopy(this.row, 0, objectArray, 0, n);
            }
            JoinRow joinRow = new JoinRow(objectArray);
            joinRow.state = this.state;
            if (this.prev != null) {
                joinRow.prev = this.prev;
                this.prev.next = joinRow;
            }
            this.prev = joinRow;
            joinRow.next = this;
            return joinRow;
        }

        public String toString() {
            return "JoinRow->" + Arrays.toString(this.row);
        }
    }

    private static final class JoinFilter {
        final IndexLookupBatch lookupBatch;
        final int id;
        final JoinFilter join;
        final TableFilter filter;

        JoinFilter(IndexLookupBatch indexLookupBatch, TableFilter tableFilter, JoinFilter joinFilter) {
            this.filter = tableFilter;
            this.id = tableFilter.getJoinFilterId();
            this.join = joinFilter;
            this.lookupBatch = indexLookupBatch;
            assert (indexLookupBatch != null || this.id == 0);
        }

        void reset(boolean bl) {
            if (this.lookupBatch != null) {
                this.lookupBatch.reset(bl);
            }
        }

        Row getNullRow() {
            return this.filter.getTable().getNullRow();
        }

        boolean isOuterJoin() {
            return this.filter.isJoinOuter();
        }

        boolean isBatchFull() {
            return this.lookupBatch.isBatchFull();
        }

        boolean isOk(boolean bl) {
            boolean bl2 = this.filter.isOk(this.filter.getFilterCondition());
            boolean bl3 = this.filter.isOk(this.filter.getJoinCondition());
            return bl2 && (bl || bl3);
        }

        boolean collectSearchRows() {
            assert (!this.isBatchFull());
            IndexCursor indexCursor = this.filter.getIndexCursor();
            indexCursor.prepare(this.filter.getSession(), this.filter.getIndexConditions());
            if (indexCursor.isAlwaysFalse()) {
                return false;
            }
            return this.lookupBatch.addSearchRows(indexCursor.getStart(), indexCursor.getEnd());
        }

        List<Future<Cursor>> find() {
            return this.lookupBatch.find();
        }

        JoinRow find(JoinRow joinRow) {
            assert (joinRow != null);
            List<Future<Cursor>> list = this.lookupBatch.find();
            int n = list.size();
            while (n > 0) {
                Future<Cursor> future;
                assert (joinRow.isRow(this.id - 1));
                if (joinRow.row(this.id) == EMPTY_CURSOR) {
                    joinRow = joinRow.prev;
                    continue;
                }
                assert (joinRow.row(this.id) == null);
                if ((future = list.get(--n)) == null) {
                    joinRow.updateRow(this.id, EMPTY_CURSOR, 0L, 2L);
                } else {
                    joinRow.updateRow(this.id, future, 0L, 1L);
                }
                if (joinRow.prev == null || n == 0) break;
                joinRow = joinRow.prev;
            }
            while (joinRow.prev != null && joinRow.prev.row(this.id) == EMPTY_CURSOR) {
                joinRow = joinRow.prev;
            }
            assert (joinRow.prev == null || joinRow.prev.isRow(this.id));
            assert (joinRow.row(this.id) != null);
            assert (!joinRow.isRow(this.id));
            return joinRow;
        }

        public String toString() {
            return "JoinFilter->" + this.filter;
        }
    }
}

