/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.h2.mvstore;

import com.craftaro.third_party.org.h2.mvstore.Cursor;
import com.craftaro.third_party.org.h2.mvstore.CursorPos;
import com.craftaro.third_party.org.h2.mvstore.DataUtils;
import com.craftaro.third_party.org.h2.mvstore.MVStore;
import com.craftaro.third_party.org.h2.mvstore.Page;
import com.craftaro.third_party.org.h2.mvstore.RootReference;
import com.craftaro.third_party.org.h2.mvstore.type.DataType;
import com.craftaro.third_party.org.h2.mvstore.type.ObjectDataType;
import com.craftaro.third_party.org.h2.mvstore.type.StringDataType;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;

public class MVMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    public final MVStore store;
    private final AtomicReference<RootReference> root;
    private final int id;
    private final long createVersion;
    private final DataType keyType;
    private final DataType valueType;
    private final int keysPerPage;
    private final boolean singleWriter;
    private final K[] keysBuffer;
    private final V[] valuesBuffer;
    private final Object lock = new Object();
    private volatile boolean notificationRequested;
    private volatile boolean closed;
    private boolean readOnly;
    private boolean isVolatile;
    static final long INITIAL_VERSION = -1L;

    protected MVMap(Map<String, Object> map) {
        this((MVStore)map.get("store"), (DataType)map.get("key"), (DataType)map.get("val"), DataUtils.readHexInt(map, "id", 0), DataUtils.readHexLong(map, "createVersion", 0L), new AtomicReference<RootReference>(), ((MVStore)map.get("store")).getKeysPerPage(), map.containsKey("singleWriter") && (Boolean)map.get("singleWriter") != false);
        this.setInitialRoot(this.createEmptyLeaf(), this.store.getCurrentVersion());
    }

    protected MVMap(MVMap<K, V> mVMap) {
        this(mVMap.store, mVMap.keyType, mVMap.valueType, mVMap.id, mVMap.createVersion, new AtomicReference<RootReference>(mVMap.root.get()), mVMap.keysPerPage, mVMap.singleWriter);
    }

    MVMap(MVStore mVStore) {
        this(mVStore, StringDataType.INSTANCE, StringDataType.INSTANCE, 0, 0L, new AtomicReference<RootReference>(), mVStore.getKeysPerPage(), false);
        this.setInitialRoot(this.createEmptyLeaf(), mVStore.getCurrentVersion());
    }

    private MVMap(MVStore mVStore, DataType dataType, DataType dataType2, int n, long l, AtomicReference<RootReference> atomicReference, int n2, boolean bl) {
        this.store = mVStore;
        this.id = n;
        this.createVersion = l;
        this.keyType = dataType;
        this.valueType = dataType2;
        this.root = atomicReference;
        this.keysPerPage = n2;
        this.keysBuffer = bl ? new Object[n2] : null;
        this.valuesBuffer = bl ? new Object[n2] : null;
        this.singleWriter = bl;
    }

    protected MVMap<K, V> cloneIt() {
        return new MVMap<K, V>(this);
    }

    static String getMapRootKey(int n) {
        return "root." + Integer.toHexString(n);
    }

    static String getMapKey(int n) {
        return "map." + Integer.toHexString(n);
    }

    @Override
    public V put(K k, V v) {
        DataUtils.checkArgument(v != null, "The value may not be null", new Object[0]);
        return (V)this.operate(k, v, DecisionMaker.PUT);
    }

    public final K firstKey() {
        return this.getFirstLast(true);
    }

    public final K firstKey(Page page) {
        return this.getFirstLast(page, true);
    }

    public final K lastKey() {
        return this.getFirstLast(false);
    }

    public final K lastKey(Page page) {
        return this.getFirstLast(page, false);
    }

    public final K getKey(long l) {
        if (l < 0L || l >= this.sizeAsLong()) {
            return null;
        }
        Page page = this.getRootPage();
        long l2 = 0L;
        while (true) {
            long l3;
            int n;
            if (page.isLeaf()) {
                if (l >= l2 + (long)page.getKeyCount()) {
                    return null;
                }
                Object object = page.getKey((int)(l - l2));
                return (K)object;
            }
            int n2 = this.getChildPageCount(page);
            for (n = 0; n < n2 && l >= (l3 = page.getCounts(n)) + l2; ++n) {
                l2 += l3;
            }
            if (n == n2) {
                return null;
            }
            page = page.getChildPage(n);
        }
    }

    public final List<K> keyList() {
        return new AbstractList<K>(){

            @Override
            public K get(int n) {
                return MVMap.this.getKey(n);
            }

            @Override
            public int size() {
                return MVMap.this.size();
            }

            @Override
            public int indexOf(Object object) {
                return (int)MVMap.this.getKeyIndex(object);
            }
        };
    }

    public final long getKeyIndex(K k) {
        Page page = this.getRootPage();
        if (page.getTotalCount() == 0L) {
            return -1L;
        }
        long l = 0L;
        while (true) {
            int n = page.binarySearch(k);
            if (page.isLeaf()) {
                if (n < 0) {
                    l = -l;
                }
                return l + (long)n;
            }
            if (n++ < 0) {
                n = -n;
            }
            for (int i = 0; i < n; ++i) {
                l += page.getCounts(i);
            }
            page = page.getChildPage(n);
        }
    }

    private K getFirstLast(boolean bl) {
        Page page = this.getRootPage();
        return this.getFirstLast(page, bl);
    }

    private K getFirstLast(Page page, boolean bl) {
        if (page.getTotalCount() == 0L) {
            return null;
        }
        while (!page.isLeaf()) {
            page = page.getChildPage(bl ? 0 : this.getChildPageCount(page) - 1);
        }
        return (K)page.getKey(bl ? 0 : page.getKeyCount() - 1);
    }

    public final K higherKey(K k) {
        return this.getMinMax(k, false, true);
    }

    public final K higherKey(Page page, K k) {
        return this.getMinMax(page, k, false, true);
    }

    public final K ceilingKey(K k) {
        return this.getMinMax(k, false, false);
    }

    public final K ceilingKey(Page page, K k) {
        return this.getMinMax(page, k, false, false);
    }

    public final K floorKey(K k) {
        return this.getMinMax(k, true, false);
    }

    public final K floorKey(Page page, K k) {
        return this.getMinMax(page, k, true, false);
    }

    public final K lowerKey(K k) {
        return this.getMinMax(k, true, true);
    }

    public final K lowerKey(Page page, K k) {
        return this.getMinMax(page, k, true, true);
    }

    private K getMinMax(K k, boolean bl, boolean bl2) {
        return this.getMinMax(this.getRootPage(), k, bl, bl2);
    }

    private K getMinMax(Page page, K k, boolean bl, boolean bl2) {
        int n = page.binarySearch(k);
        if (page.isLeaf()) {
            if (n < 0) {
                n = -n - (bl ? 2 : 1);
            } else if (bl2) {
                n += bl ? -1 : 1;
            }
            if (n < 0 || n >= page.getKeyCount()) {
                return null;
            }
            return (K)page.getKey(n);
        }
        if (n++ < 0) {
            n = -n;
        }
        while (n >= 0 && n < this.getChildPageCount(page)) {
            K k2 = this.getMinMax(page.getChildPage(n), k, bl, bl2);
            if (k2 != null) {
                return k2;
            }
            n += bl ? -1 : 1;
        }
        return null;
    }

    @Override
    public final V get(Object object) {
        return this.get(this.getRootPage(), object);
    }

    public V get(Page page, Object object) {
        return (V)Page.get(page, object);
    }

    @Override
    public final boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    @Override
    public void clear() {
        this.clearIt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RootReference clearIt() {
        Page page = this.createEmptyLeaf();
        int n = 0;
        RootReference rootReference;
        while ((rootReference = this.flushAndGetRoot()).getTotalCount() != 0L) {
            boolean bl = rootReference.isLockedByCurrentThread();
            if (!bl) {
                if (n++ == 0) {
                    this.beforeWrite();
                } else if (n > 3 || rootReference.isLocked()) {
                    rootReference = this.lockRoot(rootReference, n);
                    bl = true;
                }
            }
            Page page2 = rootReference.root;
            long l = rootReference.version;
            try {
                if (!bl && (rootReference = rootReference.updateRootPage(page, n)) == null) continue;
                this.store.registerUnsavedMemory(page2.removeAllRecursive(l));
                page2 = page;
                RootReference rootReference2 = rootReference;
                return rootReference2;
            }
            finally {
                if (!bl) continue;
                this.unlockRoot(page2);
                continue;
            }
            break;
        }
        return rootReference;
    }

    final void close() {
        this.closed = true;
    }

    public final boolean isClosed() {
        return this.closed;
    }

    @Override
    public V remove(Object object) {
        return (V)this.operate(object, null, DecisionMaker.REMOVE);
    }

    @Override
    public final V putIfAbsent(K k, V v) {
        return (V)this.operate(k, v, DecisionMaker.IF_ABSENT);
    }

    @Override
    public boolean remove(Object object, Object object2) {
        EqualsDecisionMaker<Object> equalsDecisionMaker = new EqualsDecisionMaker<Object>(this.valueType, object2);
        this.operate(object, null, equalsDecisionMaker);
        return equalsDecisionMaker.getDecision() != Decision.ABORT;
    }

    static boolean areValuesEqual(DataType dataType, Object object, Object object2) {
        return object == object2 || object != null && object2 != null && dataType.compare(object, object2) == 0;
    }

    @Override
    public final boolean replace(K k, V v, V v2) {
        boolean bl;
        EqualsDecisionMaker<V> equalsDecisionMaker = new EqualsDecisionMaker<V>(this.valueType, v);
        V v3 = this.operate(k, v2, equalsDecisionMaker);
        boolean bl2 = bl = equalsDecisionMaker.getDecision() != Decision.ABORT;
        assert (!bl || MVMap.areValuesEqual(this.valueType, v, v3)) : v + " != " + v3;
        return bl;
    }

    private boolean rewrite(K k) {
        boolean bl;
        ContainsDecisionMaker containsDecisionMaker = new ContainsDecisionMaker();
        Object var3_3 = this.operate(k, null, containsDecisionMaker);
        boolean bl2 = bl = containsDecisionMaker.getDecision() != Decision.ABORT;
        assert (bl == (var3_3 != null));
        return bl;
    }

    @Override
    public final V replace(K k, V v) {
        return (V)this.operate(k, v, DecisionMaker.IF_PRESENT);
    }

    final int compare(Object object, Object object2) {
        return this.keyType.compare(object, object2);
    }

    public final DataType getKeyType() {
        return this.keyType;
    }

    public final DataType getValueType() {
        return this.valueType;
    }

    boolean isSingleWriter() {
        return this.singleWriter;
    }

    final Page readPage(long l) {
        return this.store.readPage(this, l);
    }

    final void setRootPos(long l, long l2) {
        Page page = this.readOrCreateRootPage(l);
        this.setInitialRoot(page, l2);
        this.setWriteVersion(this.store.getCurrentVersion());
    }

    private Page readOrCreateRootPage(long l) {
        Page page = l == 0L ? this.createEmptyLeaf() : this.readPage(l);
        return page;
    }

    public final Iterator<K> keyIterator(K k) {
        return new Cursor(this.getRootPage(), k);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int rewrite(Set<Integer> set) {
        if (!this.singleWriter) {
            return this.rewrite(this.getRootPage(), set);
        }
        RootReference rootReference = this.lockRoot(this.getRoot(), 1);
        int n = rootReference.getAppendCounter();
        try {
            int n2;
            if (n > 0) {
                rootReference = this.flushAppendBuffer(rootReference, true);
                assert (rootReference.getAppendCounter() == 0);
            }
            int n3 = n2 = this.rewrite(rootReference.root, set);
            return n3;
        }
        finally {
            this.unlockRoot();
        }
    }

    private int rewrite(Page page, Set<Integer> set) {
        long l;
        int n;
        if (page.isLeaf()) {
            long l2 = page.getPos();
            int n2 = DataUtils.getPageChunkId(l2);
            if (!set.contains(n2)) {
                return 0;
            }
            assert (page.getKeyCount() > 0);
            return this.rewritePage(page) ? 1 : 0;
        }
        int n3 = 0;
        for (int i = 0; i < this.getChildPageCount(page); ++i) {
            int n4;
            long l3 = page.getChildPagePos(i);
            if (l3 != 0L && DataUtils.getPageType(l3) == 0 && !set.contains(n4 = DataUtils.getPageChunkId(l3))) continue;
            n3 += this.rewrite(page.getChildPage(i), set);
        }
        if (n3 == 0 && set.contains(n = DataUtils.getPageChunkId(l = page.getPos()))) {
            while (!page.isLeaf()) {
                page = page.getChildPage(0);
            }
            if (this.rewritePage(page)) {
                n3 = 1;
            }
        }
        return n3;
    }

    private boolean rewritePage(Page page) {
        Object object = page.getKey(0);
        if (!this.isClosed()) {
            return this.rewrite(object);
        }
        return true;
    }

    public final Cursor<K, V> cursor(K k) {
        return new Cursor(this.getRootPage(), k);
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        final Page page = this.getRootPage();
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Cursor cursor = new Cursor(page, null);
                return new Iterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return cursor.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        Object k = cursor.next();
                        return new AbstractMap.SimpleImmutableEntry(k, cursor.getValue());
                    }

                    @Override
                    public void remove() {
                        throw DataUtils.newUnsupportedOperationException("Removing is not supported");
                    }
                };
            }

            @Override
            public int size() {
                return MVMap.this.size();
            }

            @Override
            public boolean contains(Object object) {
                return MVMap.this.containsKey(object);
            }
        };
    }

    @Override
    public Set<K> keySet() {
        final Page page = this.getRootPage();
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new Cursor(page, null);
            }

            @Override
            public int size() {
                return MVMap.this.size();
            }

            @Override
            public boolean contains(Object object) {
                return MVMap.this.containsKey(object);
            }
        };
    }

    public final String getName() {
        return this.store.getMapName(this.id);
    }

    public final MVStore getStore() {
        return this.store;
    }

    protected final boolean isPersistent() {
        return this.store.getFileStore() != null && !this.isVolatile;
    }

    public final int getId() {
        return this.id;
    }

    public final Page getRootPage() {
        return this.flushAndGetRoot().root;
    }

    public RootReference getRoot() {
        return this.root.get();
    }

    public RootReference flushAndGetRoot() {
        RootReference rootReference = this.getRoot();
        if (this.singleWriter && rootReference.getAppendCounter() > 0) {
            return this.flushAppendBuffer(rootReference, true);
        }
        return rootReference;
    }

    final void setInitialRoot(Page page, long l) {
        this.root.set(new RootReference(page, l));
    }

    final boolean compareAndSetRoot(RootReference rootReference, RootReference rootReference2) {
        return this.root.compareAndSet(rootReference, rootReference2);
    }

    final void rollbackTo(long l) {
        if (l > this.createVersion) {
            this.rollbackRoot(l);
        }
    }

    boolean rollbackRoot(long l) {
        RootReference rootReference;
        RootReference rootReference2 = this.flushAndGetRoot();
        while (rootReference2.version >= l && (rootReference = rootReference2.previous) != null) {
            if (!this.root.compareAndSet(rootReference2, rootReference)) continue;
            rootReference2 = rootReference;
            this.closed = false;
        }
        this.setWriteVersion(l);
        return rootReference2.version < l;
    }

    protected static boolean updateRoot(RootReference rootReference, Page page, int n) {
        return rootReference.updateRootPage(page, n) != null;
    }

    private void removeUnusedOldVersions(RootReference rootReference) {
        rootReference.removeUnusedOldVersions(this.store.getOldestVersionToKeep());
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final void setVolatile(boolean bl) {
        this.isVolatile = bl;
    }

    public final boolean isVolatile() {
        return this.isVolatile;
    }

    protected final void beforeWrite() {
        assert (!this.getRoot().isLockedByCurrentThread()) : this.getRoot();
        if (this.closed) {
            int n = this.getId();
            String string = this.store.getMapName(n);
            throw DataUtils.newIllegalStateException(4, "Map {0}({1}) is closed. {2}", string, n, this.store.getPanicException());
        }
        if (this.readOnly) {
            throw DataUtils.newUnsupportedOperationException("This map is read-only");
        }
        this.store.beforeWrite(this);
    }

    @Override
    public final int hashCode() {
        return this.id;
    }

    @Override
    public final boolean equals(Object object) {
        return this == object;
    }

    @Override
    public final int size() {
        long l = this.sizeAsLong();
        return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
    }

    public final long sizeAsLong() {
        return this.getRoot().getTotalCount();
    }

    @Override
    public boolean isEmpty() {
        return this.sizeAsLong() == 0L;
    }

    public final long getCreateVersion() {
        return this.createVersion;
    }

    public final MVMap<K, V> openVersion(long l) {
        RootReference rootReference;
        if (this.readOnly) {
            throw DataUtils.newUnsupportedOperationException("This map is read-only; need to call the method on the writable map");
        }
        DataUtils.checkArgument(l >= this.createVersion, "Unknown version {0}; this map was created in version is {1}", l, this.createVersion);
        RootReference rootReference2 = this.flushAndGetRoot();
        this.removeUnusedOldVersions(rootReference2);
        while ((rootReference = rootReference2.previous) != null && rootReference.version >= l) {
            rootReference2 = rootReference;
        }
        if (rootReference == null && l < this.store.getOldestVersionToKeep()) {
            throw DataUtils.newIllegalArgumentException("Unknown version {0}", l);
        }
        MVMap<K, V> mVMap = this.openReadOnly(rootReference2.root, l);
        assert (mVMap.getVersion() <= l) : mVMap.getVersion() + " <= " + l;
        return mVMap;
    }

    final MVMap<K, V> openReadOnly(long l, long l2) {
        Page page = this.readOrCreateRootPage(l);
        return this.openReadOnly(page, l2);
    }

    private MVMap<K, V> openReadOnly(Page page, long l) {
        MVMap<K, V> mVMap = this.cloneIt();
        mVMap.readOnly = true;
        mVMap.setInitialRoot(page, l);
        return mVMap;
    }

    public final long getVersion() {
        return this.getRoot().getVersion();
    }

    final boolean hasChangesSince(long l) {
        return this.getRoot().hasChangesSince(l);
    }

    protected int getChildPageCount(Page page) {
        return page.getRawChildPageCount();
    }

    public String getType() {
        return null;
    }

    protected String asString(String string) {
        String string2;
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            DataUtils.appendMap(stringBuilder, "name", string);
        }
        if (this.createVersion != 0L) {
            DataUtils.appendMap(stringBuilder, "createVersion", this.createVersion);
        }
        if ((string2 = this.getType()) != null) {
            DataUtils.appendMap(stringBuilder, "type", string2);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final RootReference setWriteVersion(long l) {
        int n = 0;
        while (true) {
            RootReference rootReference = this.flushAndGetRoot();
            if (rootReference.version >= l) {
                return rootReference;
            }
            if (this.isClosed() && rootReference.getVersion() + 1L < this.store.getOldestVersionToKeep()) {
                this.store.deregisterMapRoot(this.id);
                return null;
            }
            RootReference rootReference2 = null;
            if (++n > 3 || rootReference.isLocked()) {
                rootReference2 = this.lockRoot(rootReference, n);
                rootReference = this.flushAndGetRoot();
            }
            try {
                if ((rootReference = rootReference.tryUnlockAndUpdateVersion(l, n)) == null) continue;
                rootReference2 = null;
                this.removeUnusedOldVersions(rootReference);
                RootReference rootReference3 = rootReference;
                return rootReference3;
            }
            finally {
                if (rootReference2 == null) continue;
                this.unlockRoot();
                continue;
            }
            break;
        }
    }

    protected Page createEmptyLeaf() {
        return Page.createEmptyLeaf(this);
    }

    protected Page createEmptyNode() {
        return Page.createEmptyNode(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void copyFrom(MVMap<K, V> mVMap) {
        MVStore.TxCounter txCounter = this.store.registerVersionUsage();
        try {
            this.beforeWrite();
            this.copy(mVMap.getRootPage(), null, 0);
        }
        finally {
            this.store.deregisterVersionUsage(txCounter);
        }
    }

    private void copy(Page page, Page page2, int n) {
        Page page3 = page.copy(this);
        if (page2 == null) {
            this.setInitialRoot(page3, -1L);
        } else {
            page2.setChild(n, page3);
        }
        if (!page.isLeaf()) {
            for (int i = 0; i < this.getChildPageCount(page3); ++i) {
                if (page.getChildPagePos(i) == 0L) continue;
                this.copy(page.getChildPage(i), page3, i);
            }
            page3.setComplete();
        }
        this.store.registerUnsavedMemory(page3.getMemory());
        if (this.store.isSaveNeeded()) {
            this.store.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RootReference flushAppendBuffer(RootReference rootReference, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = rootReference.isLockedByCurrentThread();
        int n = this.store.getKeysPerPage();
        try {
            int n2;
            int n3;
            IntValueHolder intValueHolder = new IntValueHolder();
            int n4 = 0;
            int n5 = n3 = bl ? 0 : n - 1;
            while ((n2 = rootReference.getAppendCounter()) > n3) {
                Object[] objectArray;
                Object object;
                if (!bl3) {
                    if ((rootReference = this.tryLock(rootReference, ++n4)) == null) {
                        rootReference = this.getRoot();
                        continue;
                    }
                    bl3 = true;
                }
                Page page = rootReference.root;
                long l = rootReference.version;
                CursorPos cursorPos = page.getAppendCursorPos(null);
                assert (cursorPos != null);
                assert (cursorPos.index < 0) : cursorPos.index;
                int n6 = -cursorPos.index - 1;
                assert (n6 == cursorPos.page.getKeyCount()) : n6 + " != " + cursorPos.page.getKeyCount();
                Page page2 = cursorPos.page;
                CursorPos cursorPos2 = cursorPos;
                cursorPos = cursorPos.parent;
                int n7 = 0;
                Page page3 = null;
                int n8 = n - page2.getKeyCount();
                if (n8 > 0) {
                    page2 = page2.copy();
                    if (n2 <= n8) {
                        page2.expand(n2, this.keysBuffer, this.valuesBuffer);
                    } else {
                        page2.expand(n8, this.keysBuffer, this.valuesBuffer);
                        n2 -= n8;
                        if (bl) {
                            object = new Object[n2];
                            objectArray = new Object[n2];
                            System.arraycopy(this.keysBuffer, n8, object, 0, n2);
                            System.arraycopy(this.valuesBuffer, n8, objectArray, 0, n2);
                            page3 = Page.createLeaf(this, object, objectArray, 0);
                        } else {
                            System.arraycopy(this.keysBuffer, n8, this.keysBuffer, 0, n2);
                            System.arraycopy(this.valuesBuffer, n8, this.valuesBuffer, 0, n2);
                            n7 = n2;
                        }
                    }
                } else {
                    cursorPos2 = cursorPos2.parent;
                    page3 = Page.createLeaf(this, Arrays.copyOf(this.keysBuffer, n2), Arrays.copyOf(this.valuesBuffer, n2), 0);
                }
                intValueHolder.value = 0;
                if (page3 != null) {
                    assert (page3.map == this);
                    assert (page3.getKeyCount() > 0);
                    object = page3.getKey(0);
                    intValueHolder.value += page3.getMemory();
                    while (true) {
                        if (cursorPos == null) {
                            if (page2.getKeyCount() == 0) {
                                page2 = page3;
                                break;
                            }
                            objectArray = new Object[]{object};
                            Page.PageReference[] pageReferenceArray = new Page.PageReference[]{new Page.PageReference(page2), new Page.PageReference(page3)};
                            intValueHolder.value += page2.getMemory();
                            page2 = Page.createNode(this, objectArray, pageReferenceArray, page2.getTotalCount() + page3.getTotalCount(), 0);
                            break;
                        }
                        objectArray = page2;
                        page2 = cursorPos.page;
                        n6 = cursorPos.index;
                        cursorPos = cursorPos.parent;
                        page2 = page2.copy();
                        page2.setChild(n6, page3);
                        page2.insertNode(n6, object, (Page)objectArray);
                        n2 = page2.getKeyCount();
                        int n9 = n2 - (page2.isLeaf() ? 1 : 2);
                        if (n2 <= n && ((long)page2.getMemory() < this.store.getMaxPageSize() || n9 <= 0)) break;
                        object = page2.getKey(n9);
                        page3 = page2.split(n9);
                        intValueHolder.value += page2.getMemory() + page3.getMemory();
                    }
                }
                if ((rootReference = rootReference.updatePageAndLockedStatus(page2 = MVMap.replacePage(cursorPos, page2, intValueHolder), bl2 || this.isPersistent(), n7)) != null) {
                    boolean bl4 = bl3 = bl2 || this.isPersistent();
                    if (this.isPersistent() && cursorPos2 != null) {
                        this.store.registerUnsavedMemory(intValueHolder.value + cursorPos2.processRemovalInfo(l));
                    }
                    assert (rootReference.getAppendCounter() <= n3);
                    break;
                }
                rootReference = this.getRoot();
            }
        }
        finally {
            if (bl3 && !bl2) {
                rootReference = this.unlockRoot();
            }
        }
        return rootReference;
    }

    private static Page replacePage(CursorPos cursorPos, Page page, IntValueHolder intValueHolder) {
        int n;
        int n2 = n = page.isSaved() ? 0 : page.getMemory();
        while (cursorPos != null) {
            Page page2 = cursorPos.page;
            if (page2.getKeyCount() > 0) {
                Page page3 = page;
                page = page2.copy();
                page.setChild(cursorPos.index, page3);
                n += page.getMemory();
            }
            cursorPos = cursorPos.parent;
        }
        intValueHolder.value += n;
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(K k, V v) {
        if (this.singleWriter) {
            this.beforeWrite();
            RootReference rootReference = this.lockRoot(this.getRoot(), 1);
            int n = rootReference.getAppendCounter();
            try {
                if (n >= this.keysPerPage) {
                    rootReference = this.flushAppendBuffer(rootReference, false);
                    n = rootReference.getAppendCounter();
                    assert (n < this.keysPerPage);
                }
                this.keysBuffer[n] = k;
                this.valuesBuffer[n] = v;
                ++n;
            }
            finally {
                this.unlockRoot(n);
            }
        } else {
            this.put(k, v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimLast() {
        if (this.singleWriter) {
            boolean bl;
            RootReference rootReference = this.getRoot();
            int n = rootReference.getAppendCounter();
            boolean bl2 = bl = n == 0;
            if (!bl) {
                rootReference = this.lockRoot(rootReference, 1);
                try {
                    n = rootReference.getAppendCounter();
                    boolean bl3 = bl = n == 0;
                    if (!bl) {
                        --n;
                    }
                }
                finally {
                    this.unlockRoot(n);
                }
            }
            if (bl) {
                Page page = rootReference.root.getAppendCursorPos(null).page;
                assert (page.isLeaf());
                assert (page.getKeyCount() > 0);
                Object object = page.getKey(page.getKeyCount() - 1);
                this.remove(object);
            }
        } else {
            this.remove(this.lastKey());
        }
    }

    @Override
    public final String toString() {
        return this.asString(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V operate(K k, V object, DecisionMaker<? super V> decisionMaker) {
        IntValueHolder intValueHolder = new IntValueHolder();
        int n = 0;
        block16: while (true) {
            RootReference rootReference;
            boolean bl;
            if (!(bl = (rootReference = this.flushAndGetRoot()).isLockedByCurrentThread())) {
                if (n++ == 0) {
                    this.beforeWrite();
                } else if (n > 3 || rootReference.isLocked()) {
                    rootReference = this.lockRoot(rootReference, n);
                    bl = true;
                }
            }
            Page page = rootReference.root;
            long l = rootReference.version;
            intValueHolder.value = 0;
            try {
                CursorPos cursorPos = CursorPos.traverseDown(page, k);
                if (!bl && rootReference != this.getRoot()) continue;
                Object object2 = cursorPos.page;
                int n2 = cursorPos.index;
                CursorPos cursorPos2 = cursorPos;
                cursorPos = cursorPos.parent;
                Object object3 = n2 < 0 ? null : ((Page)object2).getValue(n2);
                Decision decision = decisionMaker.decide(object3, object);
                block8 : switch (decision) {
                    case REPEAT: {
                        decisionMaker.reset();
                        continue block16;
                    }
                    case ABORT: {
                        if (!bl && rootReference != this.getRoot()) {
                            decisionMaker.reset();
                            continue block16;
                        }
                        Object object4 = object3;
                        return (V)object4;
                    }
                    case REMOVE: {
                        int n3;
                        if (n2 < 0) {
                            if (!bl && rootReference != this.getRoot()) {
                                decisionMaker.reset();
                                continue block16;
                            }
                            V v = null;
                            return v;
                        }
                        if (((Page)object2).getTotalCount() == 1L && cursorPos != null) {
                            do {
                                object2 = cursorPos.page;
                                n2 = cursorPos.index;
                                cursorPos = cursorPos.parent;
                            } while ((n3 = ((Page)object2).getKeyCount()) == 0 && cursorPos != null);
                            if (n3 <= 1) {
                                if (n3 == 1) {
                                    assert (n2 <= 1);
                                    object2 = ((Page)object2).getChildPage(1 - n2);
                                    break;
                                }
                                object2 = Page.createEmptyLeaf(this);
                                break;
                            }
                        }
                        object2 = ((Page)object2).copy();
                        ((Page)object2).remove(n2);
                        break;
                    }
                    case PUT: {
                        int n3;
                        object = decisionMaker.selectValue(object3, object);
                        object2 = ((Page)object2).copy();
                        if (n2 < 0) {
                            ((Page)object2).insertLeaf(-n2 - 1, k, object);
                            while ((n3 = ((Page)object2).getKeyCount()) > this.store.getKeysPerPage() || (long)((Page)object2).getMemory() > this.store.getMaxPageSize() && n3 > (((Page)object2).isLeaf() ? 1 : 2)) {
                                Object[] objectArray;
                                long l2 = ((Page)object2).getTotalCount();
                                int n4 = n3 >> 1;
                                Object object5 = ((Page)object2).getKey(n4);
                                Page page2 = ((Page)object2).split(n4);
                                intValueHolder.value += ((Page)object2).getMemory() + page2.getMemory();
                                if (cursorPos == null) {
                                    objectArray = new Object[]{object5};
                                    Page.PageReference[] pageReferenceArray = new Page.PageReference[]{new Page.PageReference((Page)object2), new Page.PageReference(page2)};
                                    object2 = Page.createNode(this, objectArray, pageReferenceArray, l2, 0);
                                    break block8;
                                }
                                objectArray = object2;
                                object2 = cursorPos.page;
                                n2 = cursorPos.index;
                                cursorPos = cursorPos.parent;
                                object2 = ((Page)object2).copy();
                                ((Page)object2).setChild(n2, page2);
                                ((Page)object2).insertNode(n2, object5, (Page)objectArray);
                            }
                            break;
                        }
                        ((Page)object2).setValue(n2, object);
                    }
                }
                page = MVMap.replacePage(cursorPos, (Page)object2, intValueHolder);
                if (!bl && (rootReference = rootReference.updateRootPage(page, n)) == null) {
                    decisionMaker.reset();
                    continue;
                }
                this.store.registerUnsavedMemory(intValueHolder.value + cursorPos2.processRemovalInfo(l));
                Object object6 = object3;
                return (V)object6;
            }
            finally {
                if (!bl) continue;
                this.unlockRoot(page);
                continue;
            }
            break;
        }
    }

    private RootReference lockRoot(RootReference rootReference, int n) {
        RootReference rootReference2;
        while ((rootReference2 = this.tryLock(rootReference, n++)) == null) {
            rootReference = this.getRoot();
        }
        return rootReference2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RootReference tryLock(RootReference rootReference, int n) {
        RootReference rootReference2 = rootReference.tryLock(n);
        if (rootReference2 != null) {
            return rootReference2;
        }
        RootReference rootReference3 = rootReference.previous;
        int n2 = 1;
        if (rootReference3 != null) {
            long l = rootReference.updateAttemptCounter - rootReference3.updateAttemptCounter;
            assert (l >= 0L) : l;
            long l2 = rootReference.updateCounter - rootReference3.updateCounter;
            assert (l2 >= 0L) : l2;
            assert (l >= l2) : l + " >= " + l2;
            n2 += (int)((l + 1L) / (l2 + 1L));
        }
        if (n > 4) {
            if (n <= 12) {
                Thread.yield();
            } else {
                if (n <= 70 - 2 * n2) {
                    try {
                        Thread.sleep(n2);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new RuntimeException(interruptedException);
                    }
                }
                Object object = this.lock;
                synchronized (object) {
                    this.notificationRequested = true;
                    try {
                        this.lock.wait(5L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    private RootReference unlockRoot() {
        return this.unlockRoot(null, -1);
    }

    protected RootReference unlockRoot(Page page) {
        return this.unlockRoot(page, -1);
    }

    private void unlockRoot(int n) {
        this.unlockRoot(null, n);
    }

    private RootReference unlockRoot(Page page, int n) {
        RootReference rootReference;
        RootReference rootReference2;
        do {
            rootReference = this.getRoot();
            assert (rootReference.isLockedByCurrentThread());
        } while ((rootReference2 = rootReference.updatePageAndLockedStatus(page == null ? rootReference.root : page, false, n == -1 ? rootReference.getAppendCounter() : n)) == null);
        this.notifyWaiters();
        return rootReference2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaiters() {
        if (this.notificationRequested) {
            Object object = this.lock;
            synchronized (object) {
                this.notificationRequested = false;
                this.lock.notify();
            }
        }
    }

    private static final class IntValueHolder {
        int value;

        IntValueHolder() {
        }
    }

    private static final class ContainsDecisionMaker<V>
    extends DecisionMaker<V> {
        private Decision decision;

        ContainsDecisionMaker() {
        }

        @Override
        public Decision decide(V v, V v2) {
            assert (this.decision == null);
            this.decision = v == null ? Decision.ABORT : Decision.PUT;
            return this.decision;
        }

        @Override
        public <T extends V> T selectValue(T t, T t2) {
            return t;
        }

        @Override
        public void reset() {
            this.decision = null;
        }

        Decision getDecision() {
            return this.decision;
        }

        public String toString() {
            return "contains";
        }
    }

    private static final class EqualsDecisionMaker<V>
    extends DecisionMaker<V> {
        private final DataType dataType;
        private final V expectedValue;
        private Decision decision;

        EqualsDecisionMaker(DataType dataType, V v) {
            this.dataType = dataType;
            this.expectedValue = v;
        }

        @Override
        public Decision decide(V v, V v2) {
            assert (this.decision == null);
            this.decision = !MVMap.areValuesEqual(this.dataType, this.expectedValue, v) ? Decision.ABORT : (v2 == null ? Decision.REMOVE : Decision.PUT);
            return this.decision;
        }

        @Override
        public void reset() {
            this.decision = null;
        }

        Decision getDecision() {
            return this.decision;
        }

        public String toString() {
            return "equals_to " + this.expectedValue;
        }
    }

    public static abstract class DecisionMaker<V> {
        public static final DecisionMaker<Object> DEFAULT = new DecisionMaker<Object>(){

            @Override
            public Decision decide(Object object, Object object2) {
                return object2 == null ? Decision.REMOVE : Decision.PUT;
            }

            public String toString() {
                return "default";
            }
        };
        public static final DecisionMaker<Object> PUT = new DecisionMaker<Object>(){

            @Override
            public Decision decide(Object object, Object object2) {
                return Decision.PUT;
            }

            public String toString() {
                return "put";
            }
        };
        public static final DecisionMaker<Object> REMOVE = new DecisionMaker<Object>(){

            @Override
            public Decision decide(Object object, Object object2) {
                return Decision.REMOVE;
            }

            public String toString() {
                return "remove";
            }
        };
        static final DecisionMaker<Object> IF_ABSENT = new DecisionMaker<Object>(){

            @Override
            public Decision decide(Object object, Object object2) {
                return object == null ? Decision.PUT : Decision.ABORT;
            }

            public String toString() {
                return "if_absent";
            }
        };
        static final DecisionMaker<Object> IF_PRESENT = new DecisionMaker<Object>(){

            @Override
            public Decision decide(Object object, Object object2) {
                return object != null ? Decision.PUT : Decision.ABORT;
            }

            public String toString() {
                return "if_present";
            }
        };

        public abstract Decision decide(V var1, V var2);

        public <T extends V> T selectValue(T t, T t2) {
            return t2;
        }

        public void reset() {
        }
    }

    public static enum Decision {
        ABORT,
        REMOVE,
        PUT,
        REPEAT;

    }

    public static class Builder<K, V>
    extends BasicBuilder<MVMap<K, V>, K, V> {
        private boolean singleWriter;

        public Builder<K, V> keyType(DataType dataType) {
            this.setKeyType(dataType);
            return this;
        }

        public Builder<K, V> valueType(DataType dataType) {
            this.setValueType(dataType);
            return this;
        }

        public Builder<K, V> singleWriter() {
            this.singleWriter = true;
            return this;
        }

        @Override
        protected MVMap<K, V> create(Map<String, Object> map) {
            map.put("singleWriter", this.singleWriter);
            Object object = map.get("type");
            if (object == null || object.equals("rtree")) {
                return new MVMap(map);
            }
            throw new IllegalArgumentException("Incompatible map type");
        }
    }

    public static abstract class BasicBuilder<M extends MVMap<K, V>, K, V>
    implements MapBuilder<M, K, V> {
        private DataType keyType;
        private DataType valueType;

        protected BasicBuilder() {
        }

        @Override
        public DataType getKeyType() {
            return this.keyType;
        }

        @Override
        public DataType getValueType() {
            return this.valueType;
        }

        @Override
        public void setKeyType(DataType dataType) {
            this.keyType = dataType;
        }

        @Override
        public void setValueType(DataType dataType) {
            this.valueType = dataType;
        }

        public BasicBuilder<M, K, V> keyType(DataType dataType) {
            this.keyType = dataType;
            return this;
        }

        public BasicBuilder<M, K, V> valueType(DataType dataType) {
            this.valueType = dataType;
            return this;
        }

        @Override
        public M create(MVStore mVStore, Map<String, Object> map) {
            if (this.getKeyType() == null) {
                this.setKeyType(new ObjectDataType());
            }
            if (this.getValueType() == null) {
                this.setValueType(new ObjectDataType());
            }
            DataType dataType = this.getKeyType();
            DataType dataType2 = this.getValueType();
            map.put("store", mVStore);
            map.put("key", dataType);
            map.put("val", dataType2);
            return this.create(map);
        }

        protected abstract M create(Map<String, Object> var1);
    }

    public static interface MapBuilder<M extends MVMap<K, V>, K, V> {
        public M create(MVStore var1, Map<String, Object> var2);

        public DataType getKeyType();

        public DataType getValueType();

        public void setKeyType(DataType var1);

        public void setValueType(DataType var1);
    }
}

