/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.h2.mode;

import com.craftaro.third_party.org.h2.engine.Database;
import com.craftaro.third_party.org.h2.engine.Session;
import com.craftaro.third_party.org.h2.expression.Expression;
import com.craftaro.third_party.org.h2.expression.function.Function;
import com.craftaro.third_party.org.h2.expression.function.FunctionInfo;
import com.craftaro.third_party.org.h2.message.DbException;
import com.craftaro.third_party.org.h2.mode.FunctionsBase;
import com.craftaro.third_party.org.h2.value.TypeInfo;
import com.craftaro.third_party.org.h2.value.Value;
import com.craftaro.third_party.org.h2.value.ValueUuid;
import java.util.HashMap;

public final class FunctionsOracle
extends FunctionsBase {
    private static final int SYS_GUID = 2001;
    private static final HashMap<String, FunctionInfo> FUNCTIONS = new HashMap();

    public static Function getFunction(Database database, String string) {
        FunctionInfo functionInfo = FUNCTIONS.get(string);
        return functionInfo != null ? new FunctionsOracle(database, functionInfo) : null;
    }

    private FunctionsOracle(Database database, FunctionInfo functionInfo) {
        super(database, functionInfo);
    }

    @Override
    public Expression optimize(Session session) {
        switch (this.info.type) {
            case 2001: {
                this.type = TypeInfo.getTypeInfo(12, 16L, 0, null);
                break;
            }
            default: {
                this.type = TypeInfo.getTypeInfo(this.info.returnDataType);
            }
        }
        return this;
    }

    @Override
    protected Value getValueWithArgs(Session session, Expression[] expressionArray) {
        Value value;
        switch (this.info.type) {
            case 2001: {
                value = ValueUuid.getNewRandom().convertTo(12);
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + this.info.type);
            }
        }
        return value;
    }

    static {
        FUNCTIONS.put("SYS_GUID", new FunctionInfo("SYS_GUID", 2001, 0, 12, false, false, true, false));
    }
}

