/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.h2.jdbcx;

import com.craftaro.third_party.org.h2.jdbcx.JdbcDataSourceFactory;
import com.craftaro.third_party.org.h2.message.DbException;
import com.craftaro.third_party.org.h2.message.TraceObject;
import com.craftaro.third_party.org.h2.util.StringUtils;
import java.util.StringTokenizer;
import javax.transaction.xa.Xid;

public class JdbcXid
extends TraceObject
implements Xid {
    private static final String PREFIX = "XID";
    private final int formatId;
    private final byte[] branchQualifier;
    private final byte[] globalTransactionId;

    JdbcXid(JdbcDataSourceFactory jdbcDataSourceFactory, int n, String string) {
        this.setTrace(jdbcDataSourceFactory.getTrace(), 15, n);
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
            String string2 = stringTokenizer.nextToken();
            if (!PREFIX.equals(string2)) {
                throw DbException.get(90101, string);
            }
            this.formatId = Integer.parseInt(stringTokenizer.nextToken());
            this.branchQualifier = StringUtils.convertHexToBytes(stringTokenizer.nextToken());
            this.globalTransactionId = StringUtils.convertHexToBytes(stringTokenizer.nextToken());
        }
        catch (RuntimeException runtimeException) {
            throw DbException.get(90101, string);
        }
    }

    public static String toString(Xid xid) {
        StringBuilder stringBuilder = new StringBuilder().append(PREFIX).append('_').append(xid.getFormatId()).append('_');
        StringUtils.convertBytesToHex(stringBuilder, xid.getBranchQualifier()).append('_');
        StringUtils.convertBytesToHex(stringBuilder, xid.getGlobalTransactionId());
        return stringBuilder.toString();
    }

    @Override
    public int getFormatId() {
        this.debugCodeCall("getFormatId");
        return this.formatId;
    }

    @Override
    public byte[] getBranchQualifier() {
        this.debugCodeCall("getBranchQualifier");
        return this.branchQualifier;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        this.debugCodeCall("getGlobalTransactionId");
        return this.globalTransactionId;
    }
}

