/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.h2.jdbc;

import com.craftaro.third_party.org.h2.jdbc.JdbcConnection;
import com.craftaro.third_party.org.h2.jdbc.JdbcLob;
import com.craftaro.third_party.org.h2.message.DbException;
import com.craftaro.third_party.org.h2.value.Value;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.sql.SQLXML;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class JdbcSQLXML
extends JdbcLob
implements SQLXML {
    private DOMResult domResult;
    private Closeable closable;

    public JdbcSQLXML(JdbcConnection jdbcConnection, Value value, JdbcLob.State state, int n) {
        super(jdbcConnection, value, state, 17, n);
    }

    @Override
    void checkReadable() throws SQLException, IOException {
        this.checkClosed();
        if (this.state == JdbcLob.State.SET_CALLED) {
            if (this.domResult != null) {
                Node node = this.domResult.getNode();
                this.domResult = null;
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                try {
                    Transformer transformer = transformerFactory.newTransformer();
                    DOMSource dOMSource = new DOMSource(node);
                    StringWriter stringWriter = new StringWriter();
                    StreamResult streamResult = new StreamResult(stringWriter);
                    transformer.transform(dOMSource, streamResult);
                    this.completeWrite(this.conn.createClob(new StringReader(stringWriter.toString()), -1L));
                }
                catch (Exception exception) {
                    throw this.logAndConvert(exception);
                }
                return;
            }
            if (this.closable != null) {
                this.closable.close();
                this.closable = null;
                return;
            }
            throw DbException.getUnsupportedException("Stream setter is not yet closed.");
        }
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return super.getBinaryStream();
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return super.getCharacterStream();
    }

    @Override
    public <T extends Source> T getSource(Class<T> clazz) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCodeCall("getSource(" + (clazz != null ? clazz.getSimpleName() + ".class" : "null") + ')');
            }
            this.checkReadable();
            if (clazz == null || clazz == DOMSource.class) {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                return (T)new DOMSource(documentBuilderFactory.newDocumentBuilder().parse(new InputSource(this.value.getInputStream())));
            }
            if (clazz == SAXSource.class) {
                return (T)new SAXSource(new InputSource(this.value.getInputStream()));
            }
            if (clazz == StAXSource.class) {
                XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
                return (T)new StAXSource(xMLInputFactory.createXMLStreamReader(this.value.getInputStream()));
            }
            if (clazz == StreamSource.class) {
                return (T)new StreamSource(this.value.getInputStream());
            }
            throw this.unsupported(clazz.getName());
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getString() throws SQLException {
        try {
            this.debugCodeCall("getString");
            this.checkReadable();
            return this.value.getString();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public OutputStream setBinaryStream() throws SQLException {
        try {
            this.debugCodeCall("setBinaryStream");
            this.checkEditable();
            this.state = JdbcLob.State.SET_CALLED;
            return new BufferedOutputStream(this.setClobOutputStreamImpl());
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Writer setCharacterStream() throws SQLException {
        try {
            this.debugCodeCall("setCharacterStream");
            this.checkEditable();
            this.state = JdbcLob.State.SET_CALLED;
            return this.setCharacterStreamImpl();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public <T extends Result> T setResult(Class<T> clazz) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCodeCall("getSource(" + (clazz != null ? clazz.getSimpleName() + ".class" : "null") + ')');
            }
            this.checkEditable();
            if (clazz == null || clazz == DOMResult.class) {
                this.domResult = new DOMResult();
                this.state = JdbcLob.State.SET_CALLED;
                return (T)this.domResult;
            }
            if (clazz == SAXResult.class) {
                SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
                TransformerHandler transformerHandler = sAXTransformerFactory.newTransformerHandler();
                Writer writer = this.setCharacterStreamImpl();
                transformerHandler.setResult(new StreamResult(writer));
                SAXResult sAXResult = new SAXResult(transformerHandler);
                this.closable = writer;
                this.state = JdbcLob.State.SET_CALLED;
                return (T)sAXResult;
            }
            if (clazz == StAXResult.class) {
                XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
                Writer writer = this.setCharacterStreamImpl();
                StAXResult stAXResult = new StAXResult(xMLOutputFactory.createXMLStreamWriter(writer));
                this.closable = writer;
                this.state = JdbcLob.State.SET_CALLED;
                return (T)stAXResult;
            }
            if (StreamResult.class.equals(clazz)) {
                Writer writer = this.setCharacterStreamImpl();
                StreamResult streamResult = new StreamResult(writer);
                this.closable = writer;
                this.state = JdbcLob.State.SET_CALLED;
                return (T)streamResult;
            }
            throw this.unsupported(clazz.getName());
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setString(String string) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCodeCall("getSource", string);
            }
            this.checkEditable();
            this.completeWrite(this.conn.createClob(new StringReader(string), -1L));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }
}

